/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.project;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;

public class MavenUpdateRequest {
    private boolean offline = false;
    private boolean forceDependencyUpdate = false;
    private final Set<IFile> pomFiles = new LinkedHashSet<IFile>();

    public MavenUpdateRequest(boolean offline, boolean forceDependencyUpdate) {
        this.offline = offline;
        this.forceDependencyUpdate = forceDependencyUpdate;
    }

    public MavenUpdateRequest(IProject project, boolean offline, boolean updateSnapshots) {
        this(offline, updateSnapshots);
        this.addPomFile(project);
    }

    public MavenUpdateRequest(Collection<IProject> projects, boolean offline, boolean updateSnapshots) {
        this(offline, updateSnapshots);
        for (IProject project : projects) {
            this.addPomFile(project);
        }
    }

    public boolean isOffline() {
        return this.offline;
    }

    public boolean isForceDependencyUpdate() {
        return this.forceDependencyUpdate;
    }

    public void addPomFiles(Set<IFile> pomFiles) {
        for (IFile pomFile : pomFiles) {
            this.addPomFile(pomFile);
        }
    }

    public void addPomFile(IFile pomFile) {
        this.pomFiles.add(pomFile);
    }

    public void addPomFile(IProject project) {
        this.pomFiles.add(project.getFile("pom.xml"));
    }

    public void removePomFile(IFile pomFile) {
        this.pomFiles.remove(pomFile);
    }

    public Set<IFile> getPomFiles() {
        return this.pomFiles;
    }

    public boolean isEmpty() {
        return this.pomFiles.isEmpty();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[");
        String sep = "";
        for (IFile pomFile : this.pomFiles) {
            sb.append(sep);
            sb.append(pomFile.getFullPath());
            sep = ", ";
        }
        sb.append("]");
        if (this.offline) {
            sb.append(" offline");
        }
        if (this.forceDependencyUpdate) {
            sb.append(" forceDependencyUpdate");
        }
        return sb.toString();
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object object) {
        void request;
        void var3_2;
        MavenUpdateRequest mavenUpdateRequest;
        if (this == object) {
            return true;
        }
        Object object2 = object;
        return object2 instanceof MavenUpdateRequest && (mavenUpdateRequest = (MavenUpdateRequest)object2) == (MavenUpdateRequest)var3_2 && this.offline == request.offline && this.forceDependencyUpdate == request.forceDependencyUpdate && this.pomFiles.equals(request.pomFiles);
    }

    public int hashCode() {
        int result = 17;
        result = result * 31 + (this.offline ? 1 : 0);
        result = result * 31 + (this.forceDependencyUpdate ? 1 : 0);
        result = result * 31 + this.pomFiles.hashCode();
        return result;
    }
}

