/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.core.graphql.java;

import java.util.Arrays;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4mp.commons.DocumentFormat;
import org.eclipse.lsp4mp.commons.MicroProfileJavaDiagnosticsParams;
import org.eclipse.lsp4mp.jdt.core.BasePropertiesManagerTest;
import org.eclipse.lsp4mp.jdt.core.MicroProfileForJavaAssert;
import org.eclipse.lsp4mp.jdt.core.java.diagnostics.IJavaErrorCode;
import org.eclipse.lsp4mp.jdt.core.utils.IJDTUtils;
import org.eclipse.lsp4mp.jdt.internal.graphql.java.MicroProfileGraphQLErrorCode;
import org.junit.Test;

public class MicroProfileGraphQLValidationTest
extends BasePropertiesManagerTest {
    @Test
    public void testVoidQueryMethod() throws Exception {
        IJavaProject javaProject = MicroProfileGraphQLValidationTest.loadMavenProject(BasePropertiesManagerTest.MicroProfileMavenProjectName.microprofile_graphql);
        IJDTUtils utils = JDT_UTILS;
        MicroProfileJavaDiagnosticsParams diagnosticsParams = new MicroProfileJavaDiagnosticsParams();
        IFile javaFile = javaProject.getProject().getFile((IPath)new Path("src/main/java/io/openliberty/graphql/sample/WeatherService.java"));
        diagnosticsParams.setUris(Arrays.asList(javaFile.getLocation().toFile().toURI().toString()));
        diagnosticsParams.setDocumentFormat(DocumentFormat.Markdown);
        Diagnostic d1 = MicroProfileForJavaAssert.d(31, 13, 27, "Annotate 'WeatherService' with '@GraphQLApi' in order for microprofile-graphql to recognize 'currentConditions' as a part of the GraphQL API.", DiagnosticSeverity.Warning, "microprofile-graphql", (IJavaErrorCode)MicroProfileGraphQLErrorCode.MISSING_GRAPHQL_API_ANNOTATION);
        Diagnostic d2 = MicroProfileForJavaAssert.d(88, 11, 15, "Methods annotated with microprofile-graphql's `@Query` cannot have 'void' as a return type.", DiagnosticSeverity.Error, "microprofile-graphql", (IJavaErrorCode)MicroProfileGraphQLErrorCode.NO_VOID_QUERIES);
        Diagnostic d3 = MicroProfileForJavaAssert.d(92, 11, 15, "Methods annotated with microprofile-graphql's `@Mutation` cannot have 'void' as a return type.", DiagnosticSeverity.Error, "microprofile-graphql", (IJavaErrorCode)MicroProfileGraphQLErrorCode.NO_VOID_MUTATIONS);
        MicroProfileForJavaAssert.assertJavaDiagnostics(diagnosticsParams, utils, d1, d2, d3);
    }
}

