/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.core.config.java;

import java.util.Arrays;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4mp.commons.DocumentFormat;
import org.eclipse.lsp4mp.commons.MicroProfileCodeActionFactory;
import org.eclipse.lsp4mp.commons.MicroProfileJavaCodeActionParams;
import org.eclipse.lsp4mp.commons.MicroProfileJavaDiagnosticsParams;
import org.eclipse.lsp4mp.commons.MicroProfileJavaDiagnosticsSettings;
import org.eclipse.lsp4mp.jdt.core.BasePropertiesManagerTest;
import org.eclipse.lsp4mp.jdt.core.MicroProfileForJavaAssert;
import org.eclipse.lsp4mp.jdt.core.java.diagnostics.IJavaErrorCode;
import org.eclipse.lsp4mp.jdt.core.utils.IJDTUtils;
import org.eclipse.lsp4mp.jdt.internal.config.java.MicroProfileConfigASTValidator;
import org.eclipse.lsp4mp.jdt.internal.config.java.MicroProfileConfigErrorCode;
import org.junit.Test;

public class MicroProfileConfigJavaDiagnosticsTest
extends BasePropertiesManagerTest {
    @Test
    public void improperDefaultValues() throws Exception {
        IJavaProject javaProject = MicroProfileConfigJavaDiagnosticsTest.loadMavenProject(BasePropertiesManagerTest.MicroProfileMavenProjectName.config_quickstart);
        IJDTUtils utils = JDT_UTILS;
        MicroProfileJavaDiagnosticsParams diagnosticsParams = new MicroProfileJavaDiagnosticsParams();
        IFile javaFile = javaProject.getProject().getFile((IPath)new Path("src/main/java/org/acme/config/DefaultValueResource.java"));
        diagnosticsParams.setUris(Arrays.asList(javaFile.getLocation().toFile().toURI().toString()));
        diagnosticsParams.setDocumentFormat(DocumentFormat.Markdown);
        Diagnostic d1 = MicroProfileForJavaAssert.d(8, 53, 58, "'foo' does not match the expected type of 'int'.", DiagnosticSeverity.Error, "microprofile-config", (IJavaErrorCode)MicroProfileConfigErrorCode.DEFAULT_VALUE_IS_WRONG_TYPE);
        Diagnostic d2 = MicroProfileForJavaAssert.d(11, 53, 58, "'bar' does not match the expected type of 'Integer'.", DiagnosticSeverity.Error, "microprofile-config", (IJavaErrorCode)MicroProfileConfigErrorCode.DEFAULT_VALUE_IS_WRONG_TYPE);
        Diagnostic d3 = MicroProfileForJavaAssert.d(17, 53, 58, "'128' does not match the expected type of 'byte'.", DiagnosticSeverity.Error, "microprofile-config", (IJavaErrorCode)MicroProfileConfigErrorCode.DEFAULT_VALUE_IS_WRONG_TYPE);
        Diagnostic d4 = MicroProfileForJavaAssert.d(32, 27, 38, "The property 'greeting9' is not assigned a value in any config file, and must be assigned at runtime.", DiagnosticSeverity.Warning, "microprofile-config", (IJavaErrorCode)MicroProfileConfigErrorCode.NO_VALUE_ASSIGNED_TO_PROPERTY);
        MicroProfileConfigASTValidator.setDataForUnassigned((String)"greeting9", (Diagnostic)d4);
        MicroProfileForJavaAssert.assertJavaDiagnostics(diagnosticsParams, utils, d1, d2, d3, d4);
    }

    @Test
    public void noValueAssignedWithIgnore() throws Exception {
        IJavaProject javaProject = MicroProfileConfigJavaDiagnosticsTest.loadMavenProject(BasePropertiesManagerTest.MicroProfileMavenProjectName.config_quickstart);
        IJDTUtils utils = JDT_UTILS;
        MicroProfileJavaDiagnosticsParams diagnosticsParams = new MicroProfileJavaDiagnosticsParams();
        IFile javaFile = javaProject.getProject().getFile((IPath)new Path("src/main/java/org/acme/config/DefaultValueResource.java"));
        diagnosticsParams.setSettings(new MicroProfileJavaDiagnosticsSettings(Arrays.asList("greeting?")));
        diagnosticsParams.setUris(Arrays.asList(javaFile.getLocation().toFile().toURI().toString()));
        diagnosticsParams.setDocumentFormat(DocumentFormat.Markdown);
        Diagnostic d1 = MicroProfileForJavaAssert.d(8, 53, 58, "'foo' does not match the expected type of 'int'.", DiagnosticSeverity.Error, "microprofile-config", (IJavaErrorCode)MicroProfileConfigErrorCode.DEFAULT_VALUE_IS_WRONG_TYPE);
        Diagnostic d2 = MicroProfileForJavaAssert.d(11, 53, 58, "'bar' does not match the expected type of 'Integer'.", DiagnosticSeverity.Error, "microprofile-config", (IJavaErrorCode)MicroProfileConfigErrorCode.DEFAULT_VALUE_IS_WRONG_TYPE);
        Diagnostic d3 = MicroProfileForJavaAssert.d(17, 53, 58, "'128' does not match the expected type of 'byte'.", DiagnosticSeverity.Error, "microprofile-config", (IJavaErrorCode)MicroProfileConfigErrorCode.DEFAULT_VALUE_IS_WRONG_TYPE);
        MicroProfileForJavaAssert.assertJavaDiagnostics(diagnosticsParams, utils, d1, d2, d3);
    }

    @Test
    public void unassignedWithConfigProperties() throws Exception {
        IJavaProject javaProject = MicroProfileConfigJavaDiagnosticsTest.loadMavenProject(BasePropertiesManagerTest.MicroProfileMavenProjectName.microprofile_configproperties);
        IJDTUtils utils = JDT_UTILS;
        MicroProfileJavaDiagnosticsParams diagnosticsParams = new MicroProfileJavaDiagnosticsParams();
        IFile javaFile = javaProject.getProject().getFile((IPath)new Path("src/main/java/org/acme/Details.java"));
        diagnosticsParams.setUris(Arrays.asList(javaFile.getLocation().toFile().toURI().toString()));
        diagnosticsParams.setDocumentFormat(DocumentFormat.Markdown);
        Diagnostic d = MicroProfileForJavaAssert.d(13, 32, 46, "The property 'server.old.location' is not assigned a value in any config file, and must be assigned at runtime.", DiagnosticSeverity.Warning, "microprofile-config", (IJavaErrorCode)MicroProfileConfigErrorCode.NO_VALUE_ASSIGNED_TO_PROPERTY);
        MicroProfileConfigASTValidator.setDataForUnassigned((String)"server.old.location", (Diagnostic)d);
        MicroProfileForJavaAssert.assertJavaDiagnostics(diagnosticsParams, utils, d);
    }

    @Test
    public void codeActionForUnassigned() throws Exception {
        IJavaProject javaProject = MicroProfileConfigJavaDiagnosticsTest.loadMavenProject(BasePropertiesManagerTest.MicroProfileMavenProjectName.config_quickstart);
        IJDTUtils utils = JDT_UTILS;
        MicroProfileConfigJavaDiagnosticsTest.saveFile("META-INF/microprofile-config.properties", "", javaProject);
        IFile propertiesFile = javaProject.getProject().getFile((IPath)new Path("src/main/resources/META-INF/microprofile-config.properties"));
        MicroProfileJavaDiagnosticsParams diagnosticsParams = new MicroProfileJavaDiagnosticsParams();
        IFile javaFile = javaProject.getProject().getFile((IPath)new Path("src/main/java/org/acme/config/UnassignedValue.java"));
        diagnosticsParams.setUris(Arrays.asList(javaFile.getLocation().toFile().toURI().toString()));
        diagnosticsParams.setDocumentFormat(DocumentFormat.Markdown);
        Diagnostic d1 = MicroProfileForJavaAssert.d(8, 24, 29, "The property 'foo' is not assigned a value in any config file, and must be assigned at runtime.", DiagnosticSeverity.Warning, "microprofile-config", (IJavaErrorCode)MicroProfileConfigErrorCode.NO_VALUE_ASSIGNED_TO_PROPERTY);
        MicroProfileConfigASTValidator.setDataForUnassigned((String)"foo", (Diagnostic)d1);
        Diagnostic d2 = MicroProfileForJavaAssert.d(14, 25, 30, "The property 'server.url' is not assigned a value in any config file, and must be assigned at runtime.", DiagnosticSeverity.Warning, "microprofile-config", (IJavaErrorCode)MicroProfileConfigErrorCode.NO_VALUE_ASSIGNED_TO_PROPERTY);
        MicroProfileConfigASTValidator.setDataForUnassigned((String)"server.url", (Diagnostic)d2);
        MicroProfileForJavaAssert.assertJavaDiagnostics(diagnosticsParams, utils, d1, d2);
        String javaUri = MicroProfileConfigJavaDiagnosticsTest.fixURI(javaFile.getLocation().toFile().toURI().toString());
        String propertiesUri = MicroProfileConfigJavaDiagnosticsTest.fixURI(propertiesFile.getLocation().toFile().toURI().toString());
        MicroProfileJavaCodeActionParams codeActionParams1 = MicroProfileForJavaAssert.createCodeActionParams(javaUri, d1, false);
        MicroProfileForJavaAssert.assertJavaCodeAction(codeActionParams1, utils, MicroProfileForJavaAssert.ca(javaUri, "Insert 'defaultValue' attribute", d1, MicroProfileForJavaAssert.te(8, 29, 8, 29, ", defaultValue = \"\"")), MicroProfileForJavaAssert.ca(propertiesUri, "Insert 'foo' property in 'META-INF/microprofile-config.properties'", d1, MicroProfileForJavaAssert.te(0, 0, 0, 0, "foo=\r\n")));
        MicroProfileJavaCodeActionParams codeActionParams2 = MicroProfileForJavaAssert.createCodeActionParams(javaUri, d2, false);
        MicroProfileForJavaAssert.assertJavaCodeAction(codeActionParams2, utils, MicroProfileForJavaAssert.ca(javaUri, "Insert 'defaultValue' attribute", d2, MicroProfileForJavaAssert.te(14, 30, 14, 30, ", defaultValue = \"\"")), MicroProfileForJavaAssert.ca(propertiesUri, "Insert 'server.url' property in 'META-INF/microprofile-config.properties'", d2, MicroProfileForJavaAssert.te(0, 0, 0, 0, "server.url=\r\n")));
        Diagnostic d1_1 = MicroProfileForJavaAssert.d(8, 24, 29, "The property 'foo' is not assigned a value in any config file, and must be assigned at runtime.", DiagnosticSeverity.Warning, "microprofile-config", (IJavaErrorCode)MicroProfileConfigErrorCode.NO_VALUE_ASSIGNED_TO_PROPERTY);
        MicroProfileConfigASTValidator.setDataForUnassigned((String)"foo", (Diagnostic)d1_1);
        Diagnostic d2_1 = MicroProfileForJavaAssert.d(14, 25, 30, "The property 'server.url' is not assigned a value in any config file, and must be assigned at runtime.", DiagnosticSeverity.Warning, "microprofile-config", (IJavaErrorCode)MicroProfileConfigErrorCode.NO_VALUE_ASSIGNED_TO_PROPERTY);
        MicroProfileConfigASTValidator.setDataForUnassigned((String)"server.url", (Diagnostic)d2_1);
        MicroProfileJavaCodeActionParams codeActionParams1_1 = MicroProfileForJavaAssert.createCodeActionParams(javaUri, d1_1);
        codeActionParams1_1.setCommandConfigurationUpdateSupported(true);
        MicroProfileForJavaAssert.assertJavaCodeAction(codeActionParams1_1, utils, MicroProfileCodeActionFactory.createAddToUnassignedExcludedCodeAction((String)"foo", (Diagnostic)d1_1), MicroProfileForJavaAssert.ca(javaUri, "Insert 'defaultValue' attribute", d1_1, MicroProfileForJavaAssert.te(8, 29, 8, 29, ", defaultValue = \"\"")), MicroProfileForJavaAssert.ca(propertiesUri, "Insert 'foo' property in 'META-INF/microprofile-config.properties'", d1_1, MicroProfileForJavaAssert.te(0, 0, 0, 0, "foo=\r\n")));
        MicroProfileJavaCodeActionParams codeActionParams2_1 = MicroProfileForJavaAssert.createCodeActionParams(javaUri, d2_1);
        codeActionParams2_1.setCommandConfigurationUpdateSupported(true);
        MicroProfileForJavaAssert.assertJavaCodeAction(codeActionParams2_1, utils, MicroProfileCodeActionFactory.createAddToUnassignedExcludedCodeAction((String)"server.url", (Diagnostic)d2_1), MicroProfileForJavaAssert.ca(javaUri, "Insert 'defaultValue' attribute", d2_1, MicroProfileForJavaAssert.te(14, 30, 14, 30, ", defaultValue = \"\"")), MicroProfileForJavaAssert.ca(propertiesUri, "Insert 'server.url' property in 'META-INF/microprofile-config.properties'", d2_1, MicroProfileForJavaAssert.te(0, 0, 0, 0, "server.url=\r\n")));
    }

    @Test
    public void emptyNameKeyValue() throws Exception {
        IJavaProject javaProject = MicroProfileConfigJavaDiagnosticsTest.loadMavenProject(BasePropertiesManagerTest.MicroProfileMavenProjectName.microprofile_configproperties);
        IJDTUtils utils = JDT_UTILS;
        MicroProfileJavaDiagnosticsParams diagnosticsParams = new MicroProfileJavaDiagnosticsParams();
        IFile javaFile = javaProject.getProject().getFile((IPath)new Path("src/main/java/org/acme/EmptyKey.java"));
        diagnosticsParams.setUris(Arrays.asList(javaFile.getLocation().toFile().toURI().toString()));
        diagnosticsParams.setDocumentFormat(DocumentFormat.Markdown);
        Diagnostic d1 = MicroProfileForJavaAssert.d(5, 25, 27, "The member 'name' can't be empty.", DiagnosticSeverity.Error, "microprofile-config", (IJavaErrorCode)MicroProfileConfigErrorCode.EMPTY_KEY);
        MicroProfileForJavaAssert.assertJavaDiagnostics(diagnosticsParams, utils, d1);
    }

    private static String fixURI(String uriString) {
        return uriString.replaceFirst("file:/([^/])", "file:///$1");
    }
}

