/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.internal.openapi.java;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4mp.commons.CodeActionResolveData;
import org.eclipse.lsp4mp.jdt.core.java.codeaction.ExtendedCodeAction;
import org.eclipse.lsp4mp.jdt.core.java.codeaction.IJavaCodeActionParticipant;
import org.eclipse.lsp4mp.jdt.core.java.codeaction.JavaCodeActionContext;
import org.eclipse.lsp4mp.jdt.core.java.codeaction.JavaCodeActionResolveContext;
import org.eclipse.lsp4mp.jdt.core.utils.JDTTypeUtils;
import org.eclipse.lsp4mp.jdt.internal.openapi.java.OpenAPIAnnotationProposal;

public class MicroProfileGenerateOpenAPIOperation
implements IJavaCodeActionParticipant {
    private static final String MESSAGE = "Generate OpenAPI Annotations for ''{0}''";
    private static final String TYPE_NAME_KEY = "type";

    @Override
    public String getParticipantId() {
        return MicroProfileGenerateOpenAPIOperation.class.getName();
    }

    @Override
    public boolean isAdaptedForCodeAction(JavaCodeActionContext context, IProgressMonitor monitor) throws CoreException {
        IJavaProject javaProject = context.getJavaProject();
        return JDTTypeUtils.findType(javaProject, "org.eclipse.microprofile.openapi.annotations.Operation") != null;
    }

    @Override
    public List<? extends CodeAction> getCodeActions(JavaCodeActionContext context, Diagnostic diagnostic, IProgressMonitor monitor) throws CoreException {
        ArrayList<ExtendedCodeAction> codeActions = new ArrayList<ExtendedCodeAction>();
        CompilationUnit cu = context.getASTRoot();
        List types = cu.types();
        for (Object type : types) {
            if (!(type instanceof TypeDeclaration)) continue;
            TypeDeclaration typeDeclaration = (TypeDeclaration)type;
            String typeName = typeDeclaration.getName().getFullyQualifiedName();
            HashMap<String, Object> extendedData = new HashMap<String, Object>();
            extendedData.put(TYPE_NAME_KEY, typeName);
            CodeActionResolveData data = new CodeActionResolveData(context.getUri(), this.getParticipantId(), context.getParams().getRange(), extendedData, context.getParams().isResourceOperationSupported(), context.getParams().isCommandConfigurationUpdateSupported());
            ExtendedCodeAction codeAction = new ExtendedCodeAction(MessageFormat.format(MESSAGE, MicroProfileGenerateOpenAPIOperation.getSimpleName(typeName)));
            codeAction.setData(data);
            codeAction.setRelevance(0);
            codeAction.setKind("source");
            codeActions.add(codeAction);
        }
        return codeActions;
    }

    @Override
    public CodeAction resolveCodeAction(JavaCodeActionResolveContext context) {
        CodeAction toResolve = context.getUnresolved();
        CodeActionResolveData data = (CodeActionResolveData)toResolve.getData();
        String typeName = (String)data.getExtendedDataEntry(TYPE_NAME_KEY);
        if (StringUtils.isEmpty((CharSequence)typeName)) {
            return toResolve;
        }
        CompilationUnit cu = context.getASTRoot();
        Optional<Object> typeDeclarationOpt = cu.types().stream().filter(type -> type instanceof TypeDeclaration && typeName.equals(((TypeDeclaration)type).getName().getFullyQualifiedName())).map(type -> (TypeDeclaration)type).findFirst();
        if (typeDeclarationOpt.isEmpty()) {
            return toResolve;
        }
        TypeDeclaration typeDeclaration = (TypeDeclaration)typeDeclarationOpt.get();
        OpenAPIAnnotationProposal proposal = new OpenAPIAnnotationProposal(MessageFormat.format(MESSAGE, MicroProfileGenerateOpenAPIOperation.getSimpleName(typeName)), context.getCompilationUnit(), context.getASTRoot(), typeDeclaration, "org.eclipse.microprofile.openapi.annotations.Operation", 0);
        try {
            WorkspaceEdit we = context.convertToWorkspaceEdit(proposal);
            toResolve.setEdit(we);
        }
        catch (CoreException coreException) {}
        return toResolve;
    }

    private static final String getSimpleName(String fullyQualifiedName) {
        int lastDot = fullyQualifiedName.lastIndexOf(46);
        if (lastDot == -1) {
            return fullyQualifiedName;
        }
        return fullyQualifiedName.substring(lastDot);
    }
}

