/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.core.restclient.java;

import java.util.Arrays;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4mp.commons.DocumentFormat;
import org.eclipse.lsp4mp.commons.MicroProfileJavaCodeActionParams;
import org.eclipse.lsp4mp.commons.MicroProfileJavaDiagnosticsParams;
import org.eclipse.lsp4mp.jdt.core.BasePropertiesManagerTest;
import org.eclipse.lsp4mp.jdt.core.MicroProfileForJavaAssert;
import org.eclipse.lsp4mp.jdt.core.java.diagnostics.IJavaErrorCode;
import org.eclipse.lsp4mp.jdt.core.utils.IJDTUtils;
import org.eclipse.lsp4mp.jdt.internal.restclient.MicroProfileRestClientErrorCode;
import org.junit.Test;

public class MicroProfileRestClientJavaDiagnosticsTest
extends BasePropertiesManagerTest {
    @Test
    public void restClientAnnotationMissingForFields() throws Exception {
        IJavaProject javaProject = MicroProfileRestClientJavaDiagnosticsTest.loadMavenProject(BasePropertiesManagerTest.MicroProfileMavenProjectName.rest_client_quickstart);
        IJDTUtils utils = JDT_UTILS;
        MicroProfileJavaDiagnosticsParams params = new MicroProfileJavaDiagnosticsParams();
        IFile javaFile = javaProject.getProject().getFile((IPath)new Path("src/main/java/org/acme/restclient/Fields.java"));
        params.setUris(Arrays.asList(javaFile.getLocation().toFile().toURI().toString()));
        params.setDocumentFormat(DocumentFormat.Markdown);
        Diagnostic d1 = MicroProfileForJavaAssert.d(12, 18, 26, "The corresponding `org.acme.restclient.MyService` interface does not have the @RegisterRestClient annotation. The field `service1` will not be injected as a CDI bean.", DiagnosticSeverity.Warning, "microprofile-restclient", null);
        Diagnostic d2 = MicroProfileForJavaAssert.d(12, 28, 36, "The corresponding `org.acme.restclient.MyService` interface does not have the @RegisterRestClient annotation. The field `service2` will not be injected as a CDI bean.", DiagnosticSeverity.Warning, "microprofile-restclient", null);
        Diagnostic d3 = MicroProfileForJavaAssert.d(15, 25, 52, "The Rest Client object should have the @RestClient annotation to be injected as a CDI bean.", DiagnosticSeverity.Warning, "microprofile-restclient", (IJavaErrorCode)MicroProfileRestClientErrorCode.RestClientAnnotationMissing);
        Diagnostic d4 = MicroProfileForJavaAssert.d(18, 25, 48, "The Rest Client object should have the @Inject annotation to be injected as a CDI bean.", DiagnosticSeverity.Warning, "microprofile-restclient", (IJavaErrorCode)MicroProfileRestClientErrorCode.InjectAnnotationMissing);
        Diagnostic d5 = MicroProfileForJavaAssert.d(20, 25, 61, "The Rest Client object should have the @Inject and @RestClient annotations to be injected as a CDI bean.", DiagnosticSeverity.Warning, "microprofile-restclient", (IJavaErrorCode)MicroProfileRestClientErrorCode.InjectAndRestClientAnnotationMissing);
        MicroProfileForJavaAssert.assertJavaDiagnostics(params, utils, d1, d2, d3, d4, d5);
        String uri = javaFile.getLocation().toFile().toURI().toString();
        MicroProfileJavaCodeActionParams codeActionParams = MicroProfileForJavaAssert.createCodeActionParams(uri, d3);
        MicroProfileForJavaAssert.assertJavaCodeAction(codeActionParams, utils, MicroProfileForJavaAssert.ca(uri, "Insert @RestClient", d3, MicroProfileForJavaAssert.te(14, 1, 14, 1, "@RestClient\r\n\t")));
        codeActionParams = MicroProfileForJavaAssert.createCodeActionParams(uri, d4);
        MicroProfileForJavaAssert.assertJavaCodeAction(codeActionParams, utils, MicroProfileForJavaAssert.ca(uri, "Insert @Inject", d4, MicroProfileForJavaAssert.te(17, 1, 17, 1, "@Inject\r\n\t")));
        codeActionParams = MicroProfileForJavaAssert.createCodeActionParams(uri, d5);
        MicroProfileForJavaAssert.assertJavaCodeAction(codeActionParams, utils, MicroProfileForJavaAssert.ca(uri, "Insert @Inject, @RestClient", d5, MicroProfileForJavaAssert.te(20, 1, 20, 1, "@RestClient\r\n\t@Inject\r\n\t")));
    }

    @Test
    public void restClientAnnotationMissingForInterface() throws Exception {
        IJavaProject javaProject = MicroProfileRestClientJavaDiagnosticsTest.loadMavenProject(BasePropertiesManagerTest.MicroProfileMavenProjectName.rest_client_quickstart);
        IJDTUtils utils = JDT_UTILS;
        MicroProfileJavaDiagnosticsParams params = new MicroProfileJavaDiagnosticsParams();
        IFile javaFile = javaProject.getProject().getFile((IPath)new Path("src/main/java/org/acme/restclient/MyService.java"));
        params.setUris(Arrays.asList(javaFile.getLocation().toFile().toURI().toString()));
        params.setDocumentFormat(DocumentFormat.Markdown);
        Diagnostic d = MicroProfileForJavaAssert.d(2, 17, 26, "The interface `MyService` does not have the @RegisterRestClient annotation. The 1 fields references will not be injected as CDI beans.", DiagnosticSeverity.Warning, "microprofile-restclient", (IJavaErrorCode)MicroProfileRestClientErrorCode.RegisterRestClientAnnotationMissing);
        MicroProfileForJavaAssert.assertJavaDiagnostics(params, utils, d);
        String uri = javaFile.getLocation().toFile().toURI().toString();
        MicroProfileJavaCodeActionParams codeActionParams = MicroProfileForJavaAssert.createCodeActionParams(uri, d);
        MicroProfileForJavaAssert.assertJavaCodeAction(codeActionParams, utils, MicroProfileForJavaAssert.ca(uri, "Insert @RegisterRestClient", d, MicroProfileForJavaAssert.te(0, 28, 2, 0, "\r\n\r\nimport org.eclipse.microprofile.rest.client.inject.RegisterRestClient;\r\n\r\n@RegisterRestClient\r\n")));
    }
}

