/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.internal.core.java.validators.annotations;

import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4mp.jdt.core.java.validators.JavaASTValidator;
import org.eclipse.lsp4mp.jdt.core.utils.AnnotationUtils;
import org.eclipse.lsp4mp.jdt.internal.core.java.validators.JavaASTValidatorRegistry;
import org.eclipse.lsp4mp.jdt.internal.core.java.validators.annotations.AnnotationAttributeRule;
import org.eclipse.lsp4mp.jdt.internal.core.java.validators.annotations.AnnotationRule;

public class AnnotationRulesJavaASTValidator
extends JavaASTValidator {
    private static final Logger LOGGER = Logger.getLogger(AnnotationRulesJavaASTValidator.class.getName());
    private final Collection<AnnotationRule> rules;

    public AnnotationRulesJavaASTValidator(Collection<AnnotationRule> rules) {
        this.rules = rules;
    }

    public boolean visit(SingleMemberAnnotation annotation) {
        this.validateAnnotation((Annotation)annotation);
        return false;
    }

    public boolean visit(NormalAnnotation annotation) {
        this.validateAnnotation((Annotation)annotation);
        return false;
    }

    private void validateAnnotation(Annotation annotation) {
        for (AnnotationRule annotationRule : this.rules) {
            if (!AnnotationUtils.isMatchAnnotation(annotation, annotationRule.getAnnotation())) continue;
            List<AnnotationAttributeRule> attributeRules = annotationRule.getRules();
            for (AnnotationAttributeRule attributeRule : attributeRules) {
                try {
                    Expression attributeValueExpr = AnnotationUtils.getAnnotationMemberValueExpression(annotation, attributeRule.getAttribute());
                    if (attributeValueExpr == null) continue;
                    this.validateAnnotationAttributeValue(attributeValueExpr, attributeRule);
                }
                catch (JavaModelException e) {
                    LOGGER.log(Level.WARNING, "Exception when trying to validate annotation attribute value", e);
                }
            }
        }
    }

    private void validateAnnotationAttributeValue(Expression attributeValueExpr, AnnotationAttributeRule attributeRule) throws JavaModelException {
        if (attributeValueExpr == null) {
            return;
        }
        String valueAsString = attributeValueExpr.toString();
        if (StringUtils.isEmpty((CharSequence)valueAsString)) {
            return;
        }
        String validationResult = JavaASTValidatorRegistry.getInstance().validate(valueAsString, attributeRule);
        if (validationResult != null) {
            super.addDiagnostic(validationResult, attributeRule.getSource(), (ASTNode)attributeValueExpr, null, DiagnosticSeverity.Error);
        }
    }
}

