/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.commons.runtime.converter.safe;

import io.smallrye.config.common.utils.StringUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.lsp4mp.commons.runtime.DiagnosticsCollector;
import org.eclipse.lsp4mp.commons.runtime.EnumConstantsProvider;
import org.eclipse.lsp4mp.commons.runtime.ExecutionMode;
import org.eclipse.lsp4mp.commons.runtime.TypeProvider;
import org.eclipse.lsp4mp.commons.runtime.TypeSignatureParser;
import org.eclipse.lsp4mp.commons.runtime.converter.ConverterValidator;

public class EnumTypeConverterValidator
implements ConverterValidator {
    private static final String ENUM_ERROR_MESSAGE = "SRCFG00049: Cannot convert %s to enum class %s, allowed values: %s";
    private final TypeSignatureParser.EnumType enumType;
    private final Map<String, String> values = new HashMap<String, String>();

    public EnumTypeConverterValidator(TypeSignatureParser.EnumType enumType) {
        this.enumType = enumType;
        this.updateValues();
    }

    @Override
    public void refreshEnumType(EnumConstantsProvider enumConstNamesProvider, TypeProvider typeProvider, ExecutionMode executionMode) {
        List<String> enumConstants = enumConstNamesProvider.getConstants(this.enumType.getTypeName());
        if (!Objects.equals(this.enumType.getEnumConstants(), enumConstants)) {
            this.enumType.setEnumConstNames(enumConstants);
            this.updateValues();
        }
    }

    @Override
    public void validate(String value, int start, DiagnosticsCollector collector) {
        String trimmedValue = value.trim();
        if (trimmedValue.isEmpty()) {
            return;
        }
        String hyphenatedValue = EnumTypeConverterValidator.hyphenate(trimmedValue);
        String enumValue = this.values.get(hyphenatedValue);
        if (enumValue != null) {
            return;
        }
        String errorMessage = String.format(ENUM_ERROR_MESSAGE, value, this.enumType.getTypeName(), String.join((CharSequence)",", this.values.keySet()));
        collector.collect(errorMessage, "microprofile-config", "value", start, value.length());
    }

    private void updateValues() {
        this.values.clear();
        for (String enumValue : this.enumType.getEnumConstants()) {
            this.values.put(EnumTypeConverterValidator.hyphenate(enumValue), enumValue);
        }
    }

    private static String hyphenate(String value) {
        return StringUtil.skewer((String)value);
    }

    @Override
    public boolean canValidate() {
        return true;
    }

    @Override
    public String getConverterClassName() {
        return null;
    }

    @Override
    public String getConverterSimpleClassName() {
        return "EnumConverter";
    }
}

