/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.commons;

import java.util.Objects;
import org.eclipse.lsp4mp.commons.MicroProfileInlayHintTypeSettings;

public class MicroProfileInlayHintSettings {
    private static final MicroProfileInlayHintTypeSettings DEFAULT_CONVERTERS = new MicroProfileInlayHintTypeSettings();
    private static final MicroProfileInlayHintTypeSettings DEFAULT_DEFAULT_VALUES;
    private static final MicroProfileInlayHintTypeSettings DEFAULT_RESOLVE_EXPRESSIONS;
    private static final MicroProfileInlayHintTypeSettings DEFAULT_TYPES;
    private boolean enabled;
    private MicroProfileInlayHintTypeSettings converters;
    private MicroProfileInlayHintTypeSettings defaultValues;
    private MicroProfileInlayHintTypeSettings resolveExpressions;
    private MicroProfileInlayHintTypeSettings types;
    private transient boolean updated;

    static {
        DEFAULT_CONVERTERS.setEnabled(false);
        DEFAULT_DEFAULT_VALUES = new MicroProfileInlayHintTypeSettings();
        DEFAULT_DEFAULT_VALUES.setEnabled(true);
        DEFAULT_RESOLVE_EXPRESSIONS = new MicroProfileInlayHintTypeSettings();
        DEFAULT_RESOLVE_EXPRESSIONS.setEnabled(true);
        DEFAULT_TYPES = new MicroProfileInlayHintTypeSettings();
        DEFAULT_TYPES.setEnabled(false);
    }

    public MicroProfileInlayHintSettings() {
        this.setEnabled(true);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public MicroProfileInlayHintTypeSettings getConverters() {
        this.updateDefault();
        return this.converters;
    }

    public void setConverters(MicroProfileInlayHintTypeSettings converters) {
        this.converters = converters;
        this.updated = false;
    }

    public MicroProfileInlayHintTypeSettings getDefaultValues() {
        this.updateDefault();
        return this.defaultValues;
    }

    public void setDefaultValues(MicroProfileInlayHintTypeSettings defaultValues) {
        this.defaultValues = defaultValues;
        this.updated = false;
    }

    public MicroProfileInlayHintTypeSettings getResolveExpressions() {
        this.updateDefault();
        return this.resolveExpressions;
    }

    public void setResolveExpressions(MicroProfileInlayHintTypeSettings resolveExpressions) {
        this.resolveExpressions = resolveExpressions;
        this.updated = false;
    }

    public MicroProfileInlayHintTypeSettings getTypes() {
        this.updateDefault();
        return this.types;
    }

    public void setTypes(MicroProfileInlayHintTypeSettings types) {
        this.types = types;
        this.updated = false;
    }

    private void updateDefault() {
        if (this.updated) {
            return;
        }
        this.setConverters(this.converters != null ? this.converters : DEFAULT_CONVERTERS);
        this.setDefaultValues(this.defaultValues != null ? this.defaultValues : DEFAULT_DEFAULT_VALUES);
        this.setResolveExpressions(this.resolveExpressions != null ? this.resolveExpressions : DEFAULT_RESOLVE_EXPRESSIONS);
        this.setTypes(this.types != null ? this.types : DEFAULT_TYPES);
        this.updated = true;
    }

    public boolean update(MicroProfileInlayHintSettings newInlayHint) {
        if (newInlayHint == null || Objects.equals(this, newInlayHint)) {
            return false;
        }
        this.setEnabled(newInlayHint.isEnabled());
        this.setConverters(newInlayHint.getConverters());
        this.setDefaultValues(newInlayHint.getDefaultValues());
        this.setResolveExpressions(newInlayHint.getResolveExpressions());
        this.setTypes(newInlayHint.getTypes());
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.converters, this.defaultValues, this.enabled, this.resolveExpressions, this.types);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MicroProfileInlayHintSettings other = (MicroProfileInlayHintSettings)obj;
        return Objects.equals(this.converters, other.converters) && Objects.equals(this.defaultValues, other.defaultValues) && this.enabled == other.enabled && Objects.equals(this.resolveExpressions, other.resolveExpressions) && Objects.equals(this.types, other.types);
    }
}

