/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.core.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IImportContainer;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.internal.compiler.env.IElementInfo;
import org.eclipse.jdt.internal.core.ImportContainerInfo;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.util.Ranges;
import org.eclipse.lsp4mp.jdt.core.utils.AnnotationMemberInfo;
import org.eclipse.lsp4mp.jdt.core.utils.IJDTUtils;

public class AnnotationUtils {
    private static final String ATTRIBUTE_VALUE = "value";

    public static boolean hasAnnotation(IAnnotatable annotatable, String annotationName) throws JavaModelException {
        return AnnotationUtils.hasAnyAnnotation(annotatable, annotationName);
    }

    public static boolean hasAnyAnnotation(IAnnotatable annotatable, String ... annotationNames) throws JavaModelException {
        return AnnotationUtils.getFirstAnnotation(annotatable, annotationNames) != null;
    }

    public static IAnnotation getFirstAnnotation(IAnnotatable annotatable, String ... annotationNames) throws JavaModelException {
        IAnnotation[] annotations;
        if (annotatable == null) {
            return null;
        }
        IAnnotation[] iAnnotationArray = annotations = annotatable.getAnnotations();
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            IAnnotation annotation = iAnnotationArray[n2];
            String[] stringArray = annotationNames;
            int n3 = annotationNames.length;
            int n4 = 0;
            while (n4 < n3) {
                String annotationName = stringArray[n4];
                if (AnnotationUtils.isMatchAnnotation(annotation, annotationName)) {
                    return annotation;
                }
                ++n4;
            }
            ++n2;
        }
        return null;
    }

    public static IAnnotation getAnnotation(IAnnotatable annotatable, String ... annotationNames) throws JavaModelException {
        String[] stringArray = annotationNames;
        int n = annotationNames.length;
        int n2 = 0;
        while (n2 < n) {
            String annotationName = stringArray[n2];
            IAnnotation annotation = AnnotationUtils.getFirstAnnotation(annotatable, annotationName);
            if (annotation != null) {
                return annotation;
            }
            ++n2;
        }
        return null;
    }

    public static boolean isMatchAnnotation(IAnnotation annotation, String annotationName) {
        if (!annotationName.endsWith(annotation.getElementName())) {
            return false;
        }
        if (annotationName.equals(annotation.getElementName())) {
            return true;
        }
        return AnnotationUtils.isMatchAnnotationFullyQualifiedName(annotation, annotationName);
    }

    private static boolean isMatchAnnotationFullyQualifiedName(IAnnotation annotation, String annotationName) {
        IJavaElement[] elements;
        ICompilationUnit unit = (ICompilationUnit)annotation.getAncestor(5);
        if (unit == null) {
            return false;
        }
        IImportContainer container = unit.getImportContainer();
        if (container == null) {
            return false;
        }
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        IElementInfo info = manager.getInfo((IJavaElement)container);
        if (info == null) {
            if (manager.getInfo((IJavaElement)unit) != null) {
                return false;
            }
            try {
                unit.open(null);
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
            info = manager.getInfo((IJavaElement)container);
            if (info == null) {
                return false;
            }
        }
        IJavaElement[] iJavaElementArray = elements = ((ImportContainerInfo)info).getChildren();
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            String fqn;
            String qualifier;
            IJavaElement child = iJavaElementArray[n2];
            IImportDeclaration importDeclaration = (IImportDeclaration)child;
            if (importDeclaration.isOnDemand() ? (qualifier = (fqn = importDeclaration.getElementName()).substring(0, fqn.lastIndexOf(46))).equals(annotationName.substring(0, annotationName.lastIndexOf(46))) : importDeclaration.getElementName().equals(annotationName)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isMatchAnnotation(Annotation annotation, String annotationName) {
        IAnnotationBinding binding = annotation.resolveAnnotationBinding();
        ITypeBinding annotationType = binding.getAnnotationType();
        if (annotationType == null) {
            return false;
        }
        return annotationName.endsWith(annotationType.getQualifiedName());
    }

    public static String getAnnotationMemberValue(IAnnotation annotation, String memberName) throws JavaModelException {
        IMemberValuePair[] iMemberValuePairArray = annotation.getMemberValuePairs();
        int n = iMemberValuePairArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMemberValuePair pair = iMemberValuePairArray[n2];
            if (memberName.equals(pair.getMemberName())) {
                String memberValue;
                String string = memberValue = pair.getValue() != null ? pair.getValue().toString() : null;
                if (memberValue != null) {
                    switch (pair.getValueKind()) {
                        case 9: {
                            return memberValue;
                        }
                        case 13: {
                            String fieldValue;
                            IType type = (IType)annotation.getAncestor(7);
                            if (type != null && (fieldValue = AnnotationUtils.getFieldValue(type, memberValue)) != null) {
                                return fieldValue;
                            }
                            return memberValue;
                        }
                        case 12: {
                            IType type = (IType)annotation.getAncestor(7);
                            if (type != null) {
                                String fieldValue;
                                int index = memberValue.lastIndexOf(".");
                                String fieldName = memberValue.substring(index + 1);
                                String valueClass = memberValue.substring(0, index);
                                IType valueType = AnnotationUtils.getResolvedType(valueClass, type);
                                if (valueType != null && (fieldValue = AnnotationUtils.getFieldValue(valueType, fieldName)) != null) {
                                    return fieldValue;
                                }
                            }
                            return memberValue;
                        }
                    }
                    return memberValue;
                }
                return null;
            }
            ++n2;
        }
        return null;
    }

    private static IType getResolvedType(String valueClass, IType type) throws JavaModelException {
        String[][] resolvedTypes = type.resolveType(valueClass);
        if (resolvedTypes != null && resolvedTypes.length > 0) {
            valueClass = String.valueOf(resolvedTypes[0][0]) + "." + resolvedTypes[0][1];
        }
        return type.getJavaProject().findType(valueClass);
    }

    private static String getFieldValue(IType valueType, String fieldName) throws JavaModelException {
        IField valueField = valueType.getField(fieldName);
        if (valueField != null && valueField.exists()) {
            if (valueType.isEnum()) {
                return valueField.getElementName();
            }
            Object constantField = valueField.getConstant();
            if (constantField != null) {
                String constantValue = constantField.toString();
                if (constantValue.length() > 1 && constantValue.charAt(0) == '\"' && constantValue.charAt(constantValue.length() - 1) == '\"') {
                    constantValue = constantValue.substring(1, constantValue.length() - 1);
                }
                return constantValue;
            }
        }
        return null;
    }

    public static Expression getAnnotationMemberValueExpression(Annotation annotation, String memberName) throws JavaModelException {
        if (annotation instanceof NormalAnnotation) {
            NormalAnnotation normalAnnotation = (NormalAnnotation)annotation;
            for (Object pair : normalAnnotation.values()) {
                MemberValuePair castPair = (MemberValuePair)pair;
                if (!memberName.equals(castPair.getName().toString())) continue;
                return castPair.getValue();
            }
            return null;
        }
        if (annotation instanceof SingleMemberAnnotation) {
            SingleMemberAnnotation singleMemberAnnotation = (SingleMemberAnnotation)annotation;
            return ATTRIBUTE_VALUE.equals(memberName) || singleMemberAnnotation.getProperty(memberName) != null ? singleMemberAnnotation.getValue() : null;
        }
        return null;
    }

    public static AnnotationMemberInfo getAnnotationMemberAt(IAnnotation annotation, String[] annotationMemberNames, Position position, ITypeRoot typeRoot, IJDTUtils utils) throws JavaModelException {
        String annotationSource = annotation.getSource();
        ISourceRange r = annotation.getSourceRange();
        String annotationMemberValue = null;
        String[] stringArray = annotationMemberNames;
        int n = annotationMemberNames.length;
        int n2 = 0;
        while (n2 < n) {
            Pattern memberPattern;
            Matcher match;
            String annotationMemberName = stringArray[n2];
            annotationMemberValue = AnnotationUtils.getAnnotationMemberValue(annotation, annotationMemberName);
            if (annotationMemberValue != null && (match = (memberPattern = Pattern.compile(".*[^\"]\\s*(" + annotationMemberName + ")\\s*=.*", 32)).matcher(annotationSource)).matches()) {
                int offset = annotationSource.indexOf(annotationMemberValue, match.end(1));
                Range range = utils.toRange((IOpenable)typeRoot, r.getOffset() + offset, annotationMemberValue.length());
                if (!position.equals((Object)range.getEnd()) && Ranges.containsPosition((Range)range, (Position)position)) {
                    return new AnnotationMemberInfo(annotationMemberValue, range);
                }
            }
            ++n2;
        }
        return null;
    }
}

