/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.core.jaxrs.java;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.lsp4mp.commons.MicroProfileJavaCodeLensParams;
import org.eclipse.lsp4mp.jdt.core.BasePropertiesManagerTest;
import org.eclipse.lsp4mp.jdt.core.MicroProfileForJavaAssert;
import org.eclipse.lsp4mp.jdt.core.utils.IJDTUtils;
import org.junit.Test;

public class JaxRsCodeLensTest
extends BasePropertiesManagerTest {
    @Test
    public void urlCodeLensProperties() throws Exception {
        IJavaProject javaProject = JaxRsCodeLensTest.loadMavenProject(BasePropertiesManagerTest.MicroProfileMavenProjectName.hibernate_orm_resteasy);
        IJDTUtils utils = JDT_UTILS;
        MicroProfileJavaCodeLensParams params = new MicroProfileJavaCodeLensParams();
        params.setCheckServerAvailable(false);
        IFile javaFile = javaProject.getProject().getFile((IPath)new Path("src/main/java/org/acme/hibernate/orm/FruitResource.java"));
        params.setUri(javaFile.getLocation().toFile().toURI().toString());
        params.setUrlCodeLensEnabled(true);
        JaxRsCodeLensTest.assertCodeLenses(8080, params, utils);
    }

    @Test
    public void urlCodeLensYaml() throws Exception {
        IJavaProject javaProject = JaxRsCodeLensTest.loadMavenProject(BasePropertiesManagerTest.MicroProfileMavenProjectName.hibernate_orm_resteasy_yaml);
        IJDTUtils utils = JDT_UTILS;
        MicroProfileJavaCodeLensParams params = new MicroProfileJavaCodeLensParams();
        params.setCheckServerAvailable(false);
        IFile javaFile = javaProject.getProject().getFile((IPath)new Path("src/main/java/org/acme/hibernate/orm/FruitResource.java"));
        params.setUri(javaFile.getLocation().toFile().toURI().toString());
        params.setUrlCodeLensEnabled(true);
        JaxRsCodeLensTest.assertCodeLenses(8080, params, utils);
    }

    @Test
    public void customJaxRsInfoProvider() throws Exception {
        IJavaProject javaProject = JaxRsCodeLensTest.loadMavenProject(BasePropertiesManagerTest.MicroProfileMavenProjectName.hibernate_orm_resteasy);
        IJDTUtils utils = JDT_UTILS;
        MicroProfileJavaCodeLensParams params = new MicroProfileJavaCodeLensParams();
        params.setCheckServerAvailable(false);
        IFile javaFile = javaProject.getProject().getFile((IPath)new Path("src/main/java/org/acme/hibernate/orm/CustomJaxRsResolving.java"));
        params.setUri(javaFile.getLocation().toFile().toURI().toString());
        params.setUrlCodeLensEnabled(true);
        MicroProfileForJavaAssert.assertCodeLens(params, utils, MicroProfileForJavaAssert.cl("http://localhost:8080/myPath", "", MicroProfileForJavaAssert.r(7, 18, 26)));
    }

    private static void assertCodeLenses(int port, MicroProfileJavaCodeLensParams params, IJDTUtils utils) throws JavaModelException {
        MicroProfileForJavaAssert.assertCodeLens(params, utils, MicroProfileForJavaAssert.cl("http://localhost:" + port + "/fruits", "", MicroProfileForJavaAssert.r(31, 8, 8)), MicroProfileForJavaAssert.cl("http://localhost:" + port + "/fruits/{id}", "", MicroProfileForJavaAssert.r(38, 17, 17)), MicroProfileForJavaAssert.cl("http://localhost:" + port + "/fruits", "", MicroProfileForJavaAssert.r(48, 18, 18)), MicroProfileForJavaAssert.cl("http://localhost:" + port + "/fruits/{id}", "", MicroProfileForJavaAssert.r(60, 18, 18)), MicroProfileForJavaAssert.cl("http://localhost:" + port + "/fruits/{id}", "", MicroProfileForJavaAssert.r(79, 17, 17)), MicroProfileForJavaAssert.cl("http://localhost:" + port + "/fruits/path_with_java_constant", "", MicroProfileForJavaAssert.r(109, 15, 15)), MicroProfileForJavaAssert.cl("http://localhost:" + port + "/fruits/path_with_java_constant", "", MicroProfileForJavaAssert.r(119, 29, 29)));
    }
}

