/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.internal.core.java;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.lsp4mp.jdt.core.jaxrs.IJaxRsInfoProvider;
import org.eclipse.lsp4mp.jdt.internal.core.java.JaxRsInfoDefinition;
import org.eclipse.lsp4mp.jdt.internal.core.java.codeaction.JavaCodeActionDefinition;
import org.eclipse.lsp4mp.jdt.internal.core.java.codelens.JavaCodeLensDefinition;
import org.eclipse.lsp4mp.jdt.internal.core.java.completion.JavaCompletionDefinition;
import org.eclipse.lsp4mp.jdt.internal.core.java.definition.JavaDefinitionDefinition;
import org.eclipse.lsp4mp.jdt.internal.core.java.diagnostics.JavaDiagnosticsDefinition;
import org.eclipse.lsp4mp.jdt.internal.core.java.hover.JavaHoverDefinition;
import org.eclipse.lsp4mp.jdt.internal.core.java.symbols.JavaWorkspaceSymbolsDefinition;
import org.eclipse.lsp4mp.jdt.internal.jaxrs.java.DefaultJaxRsInfoProvider;

public class JavaFeaturesRegistry {
    private static final String EXTENSION_JAVA_FEATURE_PARTICIPANTS = "javaFeatureParticipants";
    private static final String CODEACTION_ELT = "codeAction";
    private static final String CODELENS_ELT = "codeLens";
    private static final String COMPLETION_ELT = "completion";
    private static final String DEFINITION_ELT = "definition";
    private static final String DIAGNOSTICS_ELT = "diagnostics";
    private static final String HOVER_ELT = "hover";
    private static final String WORKSPACE_SYMBOLS_ELT = "workspaceSymbols";
    private static final String JAXRS_ELT = "jaxrs";
    private static final Logger LOGGER = Logger.getLogger(JavaFeaturesRegistry.class.getName());
    private static final JavaFeaturesRegistry INSTANCE = new JavaFeaturesRegistry();
    private final List<JavaCodeActionDefinition> javaCodeActionDefinitions = new ArrayList<JavaCodeActionDefinition>();
    private final List<JavaCodeLensDefinition> javaCodeLensDefinitions = new ArrayList<JavaCodeLensDefinition>();
    private final List<JavaCompletionDefinition> javaCompletionDefinitions = new ArrayList<JavaCompletionDefinition>();
    private final List<JavaDefinitionDefinition> javaDefinitionDefinitions = new ArrayList<JavaDefinitionDefinition>();
    private final List<JavaDiagnosticsDefinition> javaDiagnosticsDefinitions = new ArrayList<JavaDiagnosticsDefinition>();
    private final List<JavaHoverDefinition> javaHoverDefinitions = new ArrayList<JavaHoverDefinition>();
    private final List<JavaWorkspaceSymbolsDefinition> javaWorkspaceSymbolsDefinitions = new ArrayList<JavaWorkspaceSymbolsDefinition>();
    private final List<IJaxRsInfoProvider> jaxRsInfoProviders = new ArrayList<IJaxRsInfoProvider>();
    private boolean javaFeatureDefinitionsLoaded = false;

    public static JavaFeaturesRegistry getInstance() {
        return INSTANCE;
    }

    public List<JavaCodeActionDefinition> getJavaCodeActionDefinitions(String codeActionKind) {
        this.loadJavaFeatureDefinitions();
        return this.javaCodeActionDefinitions.stream().filter(definition -> codeActionKind.startsWith(definition.getKind())).collect(Collectors.toList());
    }

    public List<JavaCodeLensDefinition> getJavaCodeLensDefinitions() {
        this.loadJavaFeatureDefinitions();
        return this.javaCodeLensDefinitions;
    }

    public List<JavaCompletionDefinition> getJavaCompletionDefinitions() {
        this.loadJavaFeatureDefinitions();
        return this.javaCompletionDefinitions;
    }

    public List<JavaDefinitionDefinition> getJavaDefinitionDefinitions() {
        this.loadJavaFeatureDefinitions();
        return this.javaDefinitionDefinitions;
    }

    public List<JavaDiagnosticsDefinition> getJavaDiagnosticsDefinitions() {
        this.loadJavaFeatureDefinitions();
        return this.javaDiagnosticsDefinitions;
    }

    public List<JavaHoverDefinition> getJavaHoverDefinitions() {
        this.loadJavaFeatureDefinitions();
        return this.javaHoverDefinitions;
    }

    public List<JavaWorkspaceSymbolsDefinition> getJavaWorkspaceSymbolsDefinitions() {
        this.loadJavaFeatureDefinitions();
        return this.javaWorkspaceSymbolsDefinitions;
    }

    public List<IJaxRsInfoProvider> getJaxRsInfoProviders() {
        this.loadJavaFeatureDefinitions();
        return this.jaxRsInfoProviders;
    }

    private synchronized void loadJavaFeatureDefinitions() {
        if (this.javaFeatureDefinitionsLoaded) {
            return;
        }
        this.javaFeatureDefinitionsLoaded = true;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = registry.getConfigurationElementsFor("org.eclipse.lsp4mp.jdt.core", EXTENSION_JAVA_FEATURE_PARTICIPANTS);
        this.addJavaFeatureDefinition(cf);
        this.jaxRsInfoProviders.add(new DefaultJaxRsInfoProvider());
    }

    private void addJavaFeatureDefinition(IConfigurationElement[] cf) {
        IConfigurationElement[] iConfigurationElementArray = cf;
        int n = cf.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ce = iConfigurationElementArray[n2];
            try {
                this.createAndAddDefinition(ce);
            }
            catch (Throwable t) {
                LOGGER.log(Level.SEVERE, "Error while collecting java features extension contributions", t);
            }
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createAndAddDefinition(IConfigurationElement ce) throws CoreException {
        switch (ce.getName()) {
            case "codeAction": {
                JavaCodeActionDefinition definition = new JavaCodeActionDefinition(ce);
                List<JavaCodeActionDefinition> list = this.javaCodeActionDefinitions;
                synchronized (list) {
                    this.javaCodeActionDefinitions.add(definition);
                    break;
                }
            }
            case "codeLens": {
                JavaCodeLensDefinition definition = new JavaCodeLensDefinition(ce);
                List<JavaCodeLensDefinition> list = this.javaCodeLensDefinitions;
                synchronized (list) {
                    this.javaCodeLensDefinitions.add(definition);
                    break;
                }
            }
            case "completion": {
                JavaCompletionDefinition definition = new JavaCompletionDefinition(ce);
                List<JavaCompletionDefinition> list = this.javaCompletionDefinitions;
                synchronized (list) {
                    this.javaCompletionDefinitions.add(definition);
                    break;
                }
            }
            case "diagnostics": {
                JavaDiagnosticsDefinition definition = new JavaDiagnosticsDefinition(ce);
                List<JavaDiagnosticsDefinition> list = this.javaDiagnosticsDefinitions;
                synchronized (list) {
                    this.javaDiagnosticsDefinitions.add(definition);
                    break;
                }
            }
            case "definition": {
                JavaDefinitionDefinition definition = new JavaDefinitionDefinition(ce);
                List<JavaDefinitionDefinition> list = this.javaDefinitionDefinitions;
                synchronized (list) {
                    this.javaDefinitionDefinitions.add(definition);
                    break;
                }
            }
            case "hover": {
                JavaHoverDefinition definition = new JavaHoverDefinition(ce);
                List<JavaHoverDefinition> list = this.javaHoverDefinitions;
                synchronized (list) {
                    this.javaHoverDefinitions.add(definition);
                    break;
                }
            }
            case "workspaceSymbols": {
                JavaWorkspaceSymbolsDefinition definition = new JavaWorkspaceSymbolsDefinition(ce);
                List<JavaWorkspaceSymbolsDefinition> list = this.javaWorkspaceSymbolsDefinitions;
                synchronized (list) {
                    this.javaWorkspaceSymbolsDefinitions.add(definition);
                    break;
                }
            }
            case "jaxrs": {
                JaxRsInfoDefinition definition = new JaxRsInfoDefinition(ce);
                List<IJaxRsInfoProvider> list = this.jaxRsInfoProviders;
                synchronized (list) {
                    this.jaxRsInfoProviders.add(definition);
                    break;
                }
            }
        }
    }
}

