/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.core;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.lsp4mp.commons.ProjectLabelInfoEntry;
import org.eclipse.lsp4mp.jdt.core.BasePropertiesManagerTest;
import org.eclipse.lsp4mp.jdt.core.ProjectLabelManager;
import org.eclipse.lsp4mp.jdt.core.utils.JDTMicroProfileUtils;
import org.junit.Assert;
import org.junit.Test;

public class ProjectLabelTest {
    @Test
    public void getProjectLabelInfoOnlyMaven() throws Exception {
        IJavaProject maven = BasePropertiesManagerTest.loadMavenProject(BasePropertiesManagerTest.MavenProjectName.empty_maven_project);
        List projectLabelEntries = ProjectLabelManager.getInstance().getProjectLabelInfo();
        ProjectLabelTest.assertProjectLabelInfoContainsProject(projectLabelEntries, maven);
        ProjectLabelTest.assertLabels(projectLabelEntries, maven, "maven");
    }

    @Test
    public void getProjectLabelInfoOnlyGradle() throws Exception {
        IJavaProject gradle = BasePropertiesManagerTest.loadGradleProject(BasePropertiesManagerTest.GradleProjectName.empty_gradle_project);
        List projectLabelEntries = ProjectLabelManager.getInstance().getProjectLabelInfo();
        ProjectLabelTest.assertProjectLabelInfoContainsProject(projectLabelEntries, gradle);
        ProjectLabelTest.assertLabels(projectLabelEntries, gradle, "gradle");
    }

    @Test
    public void getProjectLabelQuarkusMaven() throws Exception {
        IJavaProject quarkusMaven = BasePropertiesManagerTest.loadMavenProject(BasePropertiesManagerTest.MavenProjectName.using_vertx);
        List projectLabelEntries = ProjectLabelManager.getInstance().getProjectLabelInfo();
        ProjectLabelTest.assertProjectLabelInfoContainsProject(projectLabelEntries, quarkusMaven);
        ProjectLabelTest.assertLabels(projectLabelEntries, quarkusMaven, "microprofile", "maven");
    }

    @Test
    public void getProjectLabelQuarkusGradle() throws Exception {
        IJavaProject quarkusGradle = BasePropertiesManagerTest.loadGradleProject(BasePropertiesManagerTest.GradleProjectName.quarkus_gradle_project);
        List projectLabelEntries = ProjectLabelManager.getInstance().getProjectLabelInfo();
        ProjectLabelTest.assertProjectLabelInfoContainsProject(projectLabelEntries, quarkusGradle);
        ProjectLabelTest.assertLabels(projectLabelEntries, quarkusGradle, "microprofile", "gradle");
    }

    @Test
    public void getProjectLabelMultipleProjects() throws Exception {
        IJavaProject quarkusMaven = BasePropertiesManagerTest.loadMavenProject(BasePropertiesManagerTest.MavenProjectName.using_vertx);
        IJavaProject quarkusGradle = BasePropertiesManagerTest.loadGradleProject(BasePropertiesManagerTest.GradleProjectName.quarkus_gradle_project);
        IJavaProject maven = BasePropertiesManagerTest.loadMavenProject(BasePropertiesManagerTest.MavenProjectName.empty_maven_project);
        IJavaProject gradle = BasePropertiesManagerTest.loadGradleProject(BasePropertiesManagerTest.GradleProjectName.empty_gradle_project);
        List projectLabelEntries = ProjectLabelManager.getInstance().getProjectLabelInfo();
        ProjectLabelTest.assertProjectLabelInfoContainsProject(projectLabelEntries, quarkusMaven, quarkusGradle, maven, gradle);
        ProjectLabelTest.assertLabels(projectLabelEntries, quarkusMaven, "microprofile", "maven");
        ProjectLabelTest.assertLabels(projectLabelEntries, quarkusGradle, "microprofile", "gradle");
        ProjectLabelTest.assertLabels(projectLabelEntries, maven, "maven");
        ProjectLabelTest.assertLabels(projectLabelEntries, gradle, "gradle");
    }

    @Test
    public void projectNameMaven() throws Exception {
        IJavaProject quarkusMaven = BasePropertiesManagerTest.loadMavenProject(BasePropertiesManagerTest.MavenProjectName.using_vertx);
        IJavaProject maven = BasePropertiesManagerTest.loadMavenProject(BasePropertiesManagerTest.MavenProjectName.empty_maven_project);
        IJavaProject folderNameDifferent = BasePropertiesManagerTest.loadMavenProject(BasePropertiesManagerTest.MavenProjectName.folder_name_different_maven);
        List projectLabelEntries = ProjectLabelManager.getInstance().getProjectLabelInfo();
        ProjectLabelTest.assertName(projectLabelEntries, quarkusMaven, "using-vertx");
        ProjectLabelTest.assertName(projectLabelEntries, maven, "empty-maven-project");
        ProjectLabelTest.assertName(projectLabelEntries, folderNameDifferent, "mostly.empty");
    }

    @Test
    public void projectNameSameFolderName() throws Exception {
        IJavaProject empty1 = BasePropertiesManagerTest.loadMavenProject(BasePropertiesManagerTest.MavenProjectName.empty_maven_project);
        IJavaProject empty2 = BasePropertiesManagerTest.loadMavenProjectFromSubFolder(BasePropertiesManagerTest.MavenProjectName.other_empty_maven_project, "folder");
        List projectLabelEntries = ProjectLabelManager.getInstance().getProjectLabelInfo();
        ProjectLabelTest.assertName(projectLabelEntries, empty1, "empty-maven-project");
        ProjectLabelTest.assertName(projectLabelEntries, empty2, "other-empty-maven-project");
    }

    @Test
    public void projectNameGradle() throws Exception {
        IJavaProject quarkusGradle = BasePropertiesManagerTest.loadGradleProject(BasePropertiesManagerTest.GradleProjectName.quarkus_gradle_project);
        IJavaProject gradle = BasePropertiesManagerTest.loadGradleProject(BasePropertiesManagerTest.GradleProjectName.empty_gradle_project);
        IJavaProject renamedGradle = BasePropertiesManagerTest.loadGradleProject(BasePropertiesManagerTest.GradleProjectName.renamed_quarkus_gradle_project);
        List projectLabelEntries = ProjectLabelManager.getInstance().getProjectLabelInfo();
        ProjectLabelTest.assertName(projectLabelEntries, quarkusGradle, "quarkus-gradle-project");
        ProjectLabelTest.assertName(projectLabelEntries, gradle, "empty-gradle-project");
        ProjectLabelTest.assertName(projectLabelEntries, renamedGradle, "my-gradle-project");
    }

    private static void assertProjectLabelInfoContainsProject(List<ProjectLabelInfoEntry> projectLabelEntries, IJavaProject ... javaProjects) throws CoreException {
        List<String> actualProjectPaths = projectLabelEntries.stream().map(e -> e.getUri()).collect(Collectors.toList());
        IJavaProject[] iJavaProjectArray = javaProjects;
        int n = javaProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaProject javaProject = iJavaProjectArray[n2];
            ProjectLabelTest.assertContains(actualProjectPaths, JDTMicroProfileUtils.getProjectURI((IProject)javaProject.getProject()));
            ++n2;
        }
    }

    private static void assertLabels(List<ProjectLabelInfoEntry> projectLabelEntries, IJavaProject javaProject, String ... expectedLabels) throws CoreException {
        String javaProjectPath = JDTMicroProfileUtils.getProjectURI((IProject)javaProject.getProject());
        List<String> actualLabels = ProjectLabelTest.getLabelsFromProjectPath(projectLabelEntries, javaProjectPath);
        Assert.assertEquals((String)("Test project labels size for '" + javaProjectPath + "' with labels [" + actualLabels.stream().collect(Collectors.joining(",")) + "]"), (long)expectedLabels.length, (long)actualLabels.size());
        String[] stringArray = expectedLabels;
        int n = expectedLabels.length;
        int n2 = 0;
        while (n2 < n) {
            String expectedLabel = stringArray[n2];
            ProjectLabelTest.assertContains(actualLabels, expectedLabel);
            ++n2;
        }
    }

    private static void assertName(List<ProjectLabelInfoEntry> projectLabelEntries, IJavaProject javaProject, String expectedName) {
        String javaProjectPath = JDTMicroProfileUtils.getProjectURI((IProject)javaProject.getProject());
        String actualName = null;
        for (ProjectLabelInfoEntry entry : projectLabelEntries) {
            if (!entry.getUri().equals(javaProjectPath)) continue;
            actualName = entry.getName();
            break;
        }
        Assert.assertEquals((String)"Test project name in label", (Object)expectedName, actualName);
    }

    private static List<String> getLabelsFromProjectPath(List<ProjectLabelInfoEntry> projectLabelEntries, String projectPath) {
        for (ProjectLabelInfoEntry entry : projectLabelEntries) {
            if (!entry.getUri().equals(projectPath)) continue;
            return entry.getLabels();
        }
        return Collections.emptyList();
    }

    private static void assertContains(List<String> list, String strToFind) {
        for (String str : list) {
            if (!str.equals(strToFind)) continue;
            return;
        }
        Assert.fail((String)("Expected List to contain <\"" + strToFind + "\">."));
    }
}

