/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.internal.core.java;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionContext;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentEdit;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4mp.commons.MicroProfileJavaCodeActionParams;
import org.eclipse.lsp4mp.commons.MicroProfileJavaDiagnosticsParams;
import org.eclipse.lsp4mp.jdt.core.PropertiesManagerForJava;
import org.eclipse.lsp4mp.jdt.core.java.diagnostics.IJavaErrorCode;
import org.eclipse.lsp4mp.jdt.core.utils.IJDTUtils;
import org.junit.Assert;

public class MicroProfileForJavaAssert {
    public static MicroProfileJavaCodeActionParams createCodeActionParams(String uri, Diagnostic d) {
        TextDocumentIdentifier textDocument = new TextDocumentIdentifier(uri);
        Range range = d.getRange();
        CodeActionContext context = new CodeActionContext();
        context.setDiagnostics(Arrays.asList(d));
        MicroProfileJavaCodeActionParams codeActionParams = new MicroProfileJavaCodeActionParams(textDocument, range, context);
        codeActionParams.setResourceOperationSupported(true);
        return codeActionParams;
    }

    public static void assertJavaCodeAction(MicroProfileJavaCodeActionParams params, IJDTUtils utils, CodeAction ... expected) throws JavaModelException {
        List actual = PropertiesManagerForJava.getInstance().codeAction(params, utils, (IProgressMonitor)new NullProgressMonitor());
        MicroProfileForJavaAssert.assertCodeActions(actual != null && actual.size() > 0 ? actual : Collections.emptyList(), expected);
    }

    public static void assertCodeActions(List<? extends CodeAction> actual, CodeAction ... expected) {
        actual.stream().forEach(ca -> {
            ca.setCommand(null);
            ca.setKind(null);
            if (ca.getDiagnostics() != null) {
                ca.getDiagnostics().forEach(d -> {
                    d.setSeverity(null);
                    d.setMessage("");
                    d.setSource(null);
                });
            }
        });
        Assert.assertEquals((long)expected.length, (long)actual.size());
        int i = 0;
        while (i < expected.length) {
            Assert.assertEquals((String)("Assert title [" + i + "]"), (Object)expected[i].getTitle(), (Object)actual.get(i).getTitle());
            Assert.assertEquals((String)("Assert edit [" + i + "]"), (Object)expected[i].getEdit(), (Object)actual.get(i).getEdit());
            ++i;
        }
    }

    public static CodeAction ca(String uri, String title, Diagnostic d, TextEdit ... te) {
        CodeAction codeAction = new CodeAction();
        codeAction.setTitle(title);
        codeAction.setDiagnostics(Arrays.asList(d));
        VersionedTextDocumentIdentifier versionedTextDocumentIdentifier = new VersionedTextDocumentIdentifier(uri, Integer.valueOf(0));
        TextDocumentEdit textDocumentEdit = new TextDocumentEdit(versionedTextDocumentIdentifier, Arrays.asList(te));
        WorkspaceEdit workspaceEdit = new WorkspaceEdit(Arrays.asList(Either.forLeft((Object)textDocumentEdit)));
        workspaceEdit.setChanges(Collections.emptyMap());
        codeAction.setEdit(workspaceEdit);
        return codeAction;
    }

    public static TextEdit te(int startLine, int startCharacter, int endLine, int endCharacter, String newText) {
        TextEdit textEdit = new TextEdit();
        textEdit.setNewText(newText);
        textEdit.setRange(MicroProfileForJavaAssert.r(startLine, startCharacter, endLine, endCharacter));
        return textEdit;
    }

    public static Diagnostic d(int line, int startCharacter, int endCharacter, String message, DiagnosticSeverity severity, String source, IJavaErrorCode code) {
        return MicroProfileForJavaAssert.d(line, startCharacter, line, endCharacter, message, severity, source, code);
    }

    public static Diagnostic d(int startLine, int startCharacter, int endLine, int endCharacter, String message, DiagnosticSeverity severity, String source, IJavaErrorCode code) {
        return new Diagnostic(MicroProfileForJavaAssert.r(startLine, startCharacter, endLine, endCharacter), message, severity, source, code != null ? code.getCode() : null);
    }

    public static Range r(int startLine, int startCharacter, int endLine, int endCharacter) {
        return new Range(new Position(startLine, startCharacter), new Position(endLine, endCharacter));
    }

    public static void assertJavaDiagnostics(MicroProfileJavaDiagnosticsParams params, IJDTUtils utils, Diagnostic ... expected) throws JavaModelException {
        List actual = PropertiesManagerForJava.getInstance().diagnostics(params, utils, (IProgressMonitor)new NullProgressMonitor());
        MicroProfileForJavaAssert.assertDiagnostics(actual != null && actual.size() > 0 ? ((PublishDiagnosticsParams)actual.get(0)).getDiagnostics() : Collections.emptyList(), expected);
    }

    public static void assertDiagnostics(List<Diagnostic> actual, Diagnostic ... expected) {
        MicroProfileForJavaAssert.assertDiagnostics(actual, Arrays.asList(expected), false);
    }

    public static void assertDiagnostics(List<Diagnostic> actual, List<Diagnostic> expected, boolean filter) {
        List<Object> received = actual;
        boolean filterMessage = expected != null && !expected.isEmpty() && (expected.get(0).getMessage() == null || expected.get(0).getMessage().isEmpty());
        if (filter) {
            received = actual.stream().map(d -> {
                Diagnostic simpler = new Diagnostic(d.getRange(), "");
                simpler.setCode(d.getCode());
                if (filterMessage) {
                    simpler.setMessage(d.getMessage());
                }
                return simpler;
            }).collect(Collectors.toList());
        }
        Assert.assertEquals((String)("Unexpected diagnostics:\n" + actual), expected, received);
    }
}

