/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.internal.core;

import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import java.io.File;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.lsp4mp.commons.MicroProfilePropertiesChangeEvent;
import org.eclipse.lsp4mp.jdt.core.IMicroProfilePropertiesChangedListener;
import org.eclipse.lsp4mp.jdt.core.utils.JDTMicroProfileUtils;
import org.eclipse.lsp4mp.jdt.internal.core.JavaUtils;
import org.eclipse.lsp4mp.jdt.internal.core.JobHelpers;
import org.eclipse.lsp4mp.jdt.internal.core.MicroProfilePropertiesListenerManager;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class MicroProfilePropertiesListenerManagerTest {
    private static final String TEST_CLASSPATH_CHANGED_PROJECT = "test-classpath-changed";
    private static final String TEST_JAVA_SOURCES_CHANGED_PROJECT = "test-java-sources-changed";
    private ProjectTracker projectTracker;

    @Before
    public void init() {
        this.cleanWorkinkingDir();
        this.projectTracker = new ProjectTracker();
        MicroProfilePropertiesListenerManager manager = MicroProfilePropertiesListenerManager.getInstance();
        manager.addMicroProfilePropertiesChangedListener((IMicroProfilePropertiesChangedListener)this.projectTracker);
    }

    private void cleanWorkinkingDir() {
        try {
            IProject[] projects;
            IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                if (TEST_CLASSPATH_CHANGED_PROJECT.equals(project.getName()) || TEST_JAVA_SOURCES_CHANGED_PROJECT.equals(project.getName())) {
                    project.delete(true, null);
                }
                ++n2;
            }
            File dir = JavaUtils.getWorkingProjectDirectory();
            if (dir.exists()) {
                MoreFiles.deleteRecursively((Path)dir.toPath(), (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @After
    public void destroy() {
        MicroProfilePropertiesListenerManager manager = MicroProfilePropertiesListenerManager.getInstance();
        manager.removeMicroProfilePropertiesChangedListener((IMicroProfilePropertiesChangedListener)this.projectTracker);
        this.cleanWorkinkingDir();
    }

    @Ignore
    @Test
    public void classpathChanged() throws Exception {
        Assert.assertEquals((long)0L, (long)this.projectTracker.getProjects().size());
        IJavaProject project = JavaUtils.createJavaProject(TEST_CLASSPATH_CHANGED_PROJECT, new String[]{"/test.jar"});
        JobHelpers.waitForJobsToComplete();
        Assert.assertEquals((long)1L, (long)this.projectTracker.getProjects().size());
        Assert.assertEquals((Object)JDTMicroProfileUtils.getProjectURI((IJavaProject)project), (Object)this.projectTracker.getProjects().iterator().next());
        this.projectTracker.getProjects().clear();
        Assert.assertEquals((long)0L, (long)this.projectTracker.getProjects().size());
        project.setRawClasspath(new IClasspathEntry[0], (IProgressMonitor)new NullProgressMonitor());
        JobHelpers.waitForJobsToComplete();
        Assert.assertEquals((long)1L, (long)this.projectTracker.getProjects().size());
        Assert.assertEquals((Object)JDTMicroProfileUtils.getProjectURI((IJavaProject)project), (Object)this.projectTracker.getProjects().iterator().next());
    }

    @Ignore
    @Test
    public void javaSourcesChanged() throws Exception {
        Assert.assertEquals((long)0L, (long)this.projectTracker.getProjects().size());
        IJavaProject javaProject = JavaUtils.createJavaProject(TEST_JAVA_SOURCES_CHANGED_PROJECT, new String[0]);
        JobHelpers.waitForJobsToComplete();
        Assert.assertEquals((long)1L, (long)this.projectTracker.getProjects().size());
        Assert.assertEquals((Object)JDTMicroProfileUtils.getProjectURI((IJavaProject)javaProject), (Object)this.projectTracker.getProjects().iterator().next());
        this.projectTracker.getProjects().clear();
        Assert.assertEquals((long)0L, (long)this.projectTracker.getProjects().size());
        IFolder folder = javaProject.getProject().getFolder("src");
        Assert.assertEquals((long)0L, (long)this.projectTracker.getProjects().size());
        IPackageFragmentRoot srcFolder = javaProject.getPackageFragmentRoot((IResource)folder);
        Assert.assertEquals((long)0L, (long)this.projectTracker.getProjects().size());
        IPackageFragment fragment = srcFolder.createPackageFragment("org.acme.config", true, null);
        Assert.assertEquals((long)0L, (long)this.projectTracker.getProjects().size());
        String str = "package org.acme.config;\r\n\r\nimport java.util.Optional;\r\n\r\nimport javax.ws.rs.GET;\r\nimport javax.ws.rs.Path;\r\nimport javax.ws.rs.Produces;\r\nimport javax.ws.rs.core.MediaType;\r\n\r\nimport org.eclipse.microprofile.config.inject.ConfigProperty;\r\n     \r\n@Path(\"/greeting\") \r\npublic class GreetingResource {\r\n  \r\n    @ConfigProperty(name = \"greeting.message\")\r\n    String message;\r\n   \r\n    @ConfigProperty(name = \"greeting.suffix\" , \r\n                    defaultValue=\"!\")\r\n    String suffix;\r\n\r\n    @ConfigProperty(name = \"greeting.name\")\r\n    Optional<String> name;\r\n\r\n\r\n    @GET\r\n    @Produces(MediaType.TEXT_PLAIN)\r\n    public String hello() {\r\n        return message + //\" \" + //name.orElse(\"world\") + //suffix;\r\n    }\r\n}\r\n";
        ICompilationUnit cu = fragment.createCompilationUnit("GreetingResource.java", str, false, null);
        JobHelpers.waitForJobsToComplete();
        Assert.assertEquals((long)1L, (long)this.projectTracker.getProjects().size());
        Assert.assertEquals((Object)JDTMicroProfileUtils.getProjectURI((IJavaProject)javaProject), (Object)this.projectTracker.getProjects().iterator().next());
        this.projectTracker.getProjects().clear();
        IType type = cu.getType("Test");
        type.createField("private String age;", null, true, null);
        JobHelpers.waitForJobsToComplete();
        Assert.assertEquals((long)1L, (long)this.projectTracker.getProjects().size());
        Assert.assertEquals((Object)JDTMicroProfileUtils.getProjectURI((IJavaProject)javaProject), (Object)this.projectTracker.getProjects().iterator().next());
    }

    static class ProjectTracker
    implements IMicroProfilePropertiesChangedListener {
        final Set<String> projects = new HashSet<String>();

        ProjectTracker() {
        }

        public void propertiesChanged(MicroProfilePropertiesChangeEvent event) {
            this.projects.addAll(event.getProjectURIs());
        }

        public Set<String> getProjects() {
            return this.projects;
        }
    }
}

