/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.internal.core;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.lsp4mp.commons.MicroProfilePropertiesChangeEvent;
import org.eclipse.lsp4mp.commons.MicroProfilePropertiesScope;
import org.eclipse.lsp4mp.jdt.core.IMicroProfilePropertiesChangedListener;
import org.eclipse.lsp4mp.jdt.core.utils.JDTMicroProfileUtils;

public class MicroProfilePropertiesListenerManager {
    private static final Logger LOGGER = Logger.getLogger(MicroProfilePropertiesListenerManager.class.getName());
    private static final MicroProfilePropertiesListenerManager INSTANCE = new MicroProfilePropertiesListenerManager();
    private MicroProfileListener microprofileListener;
    private final Set<IMicroProfilePropertiesChangedListener> listeners = new HashSet<IMicroProfilePropertiesChangedListener>();

    public static MicroProfilePropertiesListenerManager getInstance() {
        return INSTANCE;
    }

    private MicroProfilePropertiesListenerManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMicroProfilePropertiesChangedListener(IMicroProfilePropertiesChangedListener listener) {
        Set<IMicroProfilePropertiesChangedListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMicroProfilePropertiesChangedListener(IMicroProfilePropertiesChangedListener listener) {
        Set<IMicroProfilePropertiesChangedListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(listener);
        }
    }

    public synchronized void initialize() {
        if (this.microprofileListener != null) {
            return;
        }
        this.microprofileListener = new MicroProfileListener();
        JavaCore.addElementChangedListener((IElementChangedListener)this.microprofileListener);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.microprofileListener, 1);
    }

    public synchronized void destroy() {
        if (this.microprofileListener != null) {
            JavaCore.removeElementChangedListener((IElementChangedListener)this.microprofileListener);
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.microprofileListener);
            this.microprofileListener = null;
        }
    }

    private class MicroProfileListener
    implements IElementChangedListener,
    IResourceChangeListener,
    IResourceDeltaVisitor {
        private static final String JAVA_FILE_EXTENSION = "java";

        private MicroProfileListener() {
        }

        public void elementChanged(ElementChangedEvent event) {
            if (MicroProfilePropertiesListenerManager.this.listeners.isEmpty()) {
                return;
            }
            MicroProfilePropertiesChangeEvent mpEvent = this.processDelta(event.getDelta(), null);
            if (mpEvent != null) {
                this.fireAsyncEvent(mpEvent);
            }
        }

        private MicroProfilePropertiesChangeEvent processDeltaChildren(IJavaElementDelta delta, MicroProfilePropertiesChangeEvent event) {
            IJavaElementDelta[] iJavaElementDeltaArray = delta.getAffectedChildren();
            int n = iJavaElementDeltaArray.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaElementDelta c = iJavaElementDeltaArray[n2];
                event = this.processDelta(c, event);
                ++n2;
            }
            return event;
        }

        private MicroProfilePropertiesChangeEvent processDelta(IJavaElementDelta delta, MicroProfilePropertiesChangeEvent event) {
            IJavaElement element = delta.getElement();
            switch (element.getElementType()) {
                case 1: {
                    event = this.processDeltaChildren(delta, event);
                    break;
                }
                case 2: {
                    if (!this.isCreatedOrDeleted(delta) && !this.isClasspathChanged(delta.getFlags())) break;
                    if (event == null) {
                        event = new MicroProfilePropertiesChangeEvent();
                        event.setType(MicroProfilePropertiesScope.SOURCES_AND_DEPENDENCIES);
                        event.setProjectURIs(new HashSet<String>());
                    }
                    IJavaProject project = (IJavaProject)element;
                    event.getProjectURIs().add(JDTMicroProfileUtils.getProjectURI(project));
                    break;
                }
            }
            return event;
        }

        private boolean isCreatedOrDeleted(IJavaElementDelta delta) {
            int kind = delta.getKind();
            return kind == 1 || kind == 2;
        }

        private boolean isClasspathChanged(int flags) {
            return (flags & 0x220600) != 0;
        }

        public void resourceChanged(IResourceChangeEvent event) {
            switch (event.getType()) {
                case 1: {
                    IResourceDelta resourceDelta = event.getDelta();
                    if (resourceDelta == null) break;
                    try {
                        resourceDelta.accept((IResourceDeltaVisitor)this);
                        break;
                    }
                    catch (CoreException e) {
                        if (!LOGGER.isLoggable(Level.SEVERE)) break;
                        LOGGER.log(Level.SEVERE, "Error while tracking save of Java file", e);
                    }
                }
            }
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource resource = delta.getResource();
            if (resource == null) {
                return false;
            }
            switch (resource.getType()) {
                case 2: 
                case 4: 
                case 8: {
                    return resource.isAccessible();
                }
                case 1: {
                    IFile file = (IFile)resource;
                    if (!this.isJavaFile(file) || !this.isFileContentChanged(delta)) break;
                    MicroProfilePropertiesChangeEvent event = new MicroProfilePropertiesChangeEvent();
                    event.setType(MicroProfilePropertiesScope.ONLY_SOURCES);
                    event.setProjectURIs(new HashSet<String>());
                    event.getProjectURIs().add(JDTMicroProfileUtils.getProjectURI(file.getProject()));
                    this.fireAsyncEvent(event);
                }
            }
            return false;
        }

        private void fireAsyncEvent(MicroProfilePropertiesChangeEvent event) {
            CompletableFuture.runAsync(() -> {
                for (IMicroProfilePropertiesChangedListener listener : MicroProfilePropertiesListenerManager.this.listeners) {
                    try {
                        listener.propertiesChanged(event);
                    }
                    catch (Exception e) {
                        if (!LOGGER.isLoggable(Level.SEVERE)) continue;
                        LOGGER.log(Level.SEVERE, "Error while sending LSP 'microprofile/propertiesChanged' notification", e);
                    }
                }
            });
        }

        private boolean isJavaFile(IFile file) {
            return JAVA_FILE_EXTENSION.equals(file.getFileExtension());
        }

        private boolean isFileContentChanged(IResourceDelta delta) {
            return delta.getKind() == 4 && (delta.getFlags() & 0x100) != 0;
        }
    }
}

