/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4jakarta.jdt.core.java.codeaction;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4jakarta.commons.codeaction.CodeActionResolveData;
import org.eclipse.lsp4jakarta.commons.codeaction.ICodeActionId;
import org.eclipse.lsp4jakarta.jdt.core.java.codeaction.ExtendedCodeAction;
import org.eclipse.lsp4jakarta.jdt.core.java.codeaction.IJavaCodeActionParticipant;
import org.eclipse.lsp4jakarta.jdt.core.java.codeaction.JavaCodeActionContext;
import org.eclipse.lsp4jakarta.jdt.core.java.codeaction.JavaCodeActionResolveContext;
import org.eclipse.lsp4jakarta.jdt.core.java.codeaction.RemoveAnnotationConflictQuickFix;
import org.eclipse.lsp4jakarta.jdt.core.java.corrections.proposal.ModifyModifiersProposal;
import org.eclipse.lsp4jakarta.jdt.internal.Messages;

public abstract class RemoveModifierConflictQuickFix
implements IJavaCodeActionParticipant {
    private static final Logger LOGGER = Logger.getLogger(RemoveAnnotationConflictQuickFix.class.getName());
    public static final String MODIFIERS_KEY = "modifiers";
    private final String[] modifiers;
    protected final boolean generateOnlyOneCodeAction;

    public RemoveModifierConflictQuickFix(String ... modifiers) {
        this(false, modifiers);
    }

    public RemoveModifierConflictQuickFix(boolean generateOnlyOneCodeAction, String ... modifiers) {
        this.generateOnlyOneCodeAction = generateOnlyOneCodeAction;
        this.modifiers = modifiers;
    }

    @Override
    public List<? extends CodeAction> getCodeActions(JavaCodeActionContext context, Diagnostic diagnostic, IProgressMonitor monitor) throws CoreException {
        ArrayList<CodeAction> codeActions = new ArrayList<CodeAction>();
        ASTNode node = context.getCoveredNode();
        IBinding parentType = this.getBinding(node);
        if (parentType != null) {
            this.createCodeActions(diagnostic, context, codeActions);
        }
        return codeActions;
    }

    @Override
    public CodeAction resolveCodeAction(JavaCodeActionResolveContext context) {
        CodeAction toResolve = context.getUnresolved();
        ASTNode coveredParentNode = context.getCoveredNode().getParent();
        IBinding parentType = this.getBinding(context.getCoveredNode());
        CodeActionResolveData data = (CodeActionResolveData)toResolve.getData();
        List modifiersToDeleteList = (List)data.getExtendedDataEntry(MODIFIERS_KEY);
        String[] modifiersToDelete = (String[])modifiersToDeleteList.toArray(String[]::new);
        String label = this.getLabel(modifiersToDelete);
        ModifyModifiersProposal proposal = new ModifyModifiersProposal(label, context.getCompilationUnit(), context.getASTRoot(), parentType, 0, coveredParentNode, new ArrayList<String>(), Arrays.asList(this.modifiers));
        try {
            toResolve.setEdit(context.convertToWorkspaceEdit(proposal));
        }
        catch (CoreException e) {
            LOGGER.log(Level.SEVERE, "Unable to resolve code action to remove annotation", e);
        }
        return toResolve;
    }

    protected void createCodeActions(Diagnostic diagnostic, JavaCodeActionContext context, List<CodeAction> codeActions) throws CoreException {
        if (this.generateOnlyOneCodeAction) {
            this.createCodeAction(diagnostic, context, codeActions, this.modifiers);
        } else {
            String[] stringArray = this.modifiers;
            int n = this.modifiers.length;
            int n2 = 0;
            while (n2 < n) {
                String modifier = stringArray[n2];
                this.createCodeAction(diagnostic, context, codeActions, modifier);
                ++n2;
            }
        }
    }

    protected void createCodeAction(Diagnostic diagnostic, JavaCodeActionContext context, List<CodeAction> codeActions, String ... modifiers) throws CoreException {
        String label = this.getLabel(modifiers);
        ExtendedCodeAction codeAction = new ExtendedCodeAction(label);
        codeAction.setRelevance(0);
        codeAction.setKind("quickfix");
        codeAction.setDiagnostics(Arrays.asList(diagnostic));
        HashMap<String, Object> extendedData = new HashMap<String, Object>();
        extendedData.put(MODIFIERS_KEY, Arrays.asList(modifiers));
        codeAction.setData(new CodeActionResolveData(context.getUri(), this.getParticipantId(), context.getParams().getRange(), extendedData, context.getParams().isResourceOperationSupported(), context.getParams().isCommandConfigurationUpdateSupported(), this.getCodeActionId()));
        codeActions.add(codeAction);
    }

    protected String getLabel(String ... modifier) {
        return Messages.getMessage("RemoveModifier", modifier[0]);
    }

    protected IBinding getBinding(ASTNode node) {
        if (node.getParent() instanceof VariableDeclarationFragment) {
            return ((VariableDeclarationFragment)node.getParent()).resolveBinding();
        }
        if (node.getParent() instanceof MethodDeclaration) {
            return ((MethodDeclaration)node.getParent()).resolveBinding();
        }
        return Bindings.getBindingOfParentType((ASTNode)node);
    }

    protected abstract ICodeActionId getCodeActionId();
}

