/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4jakarta.jdt.internal.di;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4jakarta.jdt.core.JakartaCorePlugin;
import org.eclipse.lsp4jakarta.jdt.core.java.diagnostics.IJavaDiagnosticsParticipant;
import org.eclipse.lsp4jakarta.jdt.core.java.diagnostics.JavaDiagnosticsContext;
import org.eclipse.lsp4jakarta.jdt.core.utils.IJDTUtils;
import org.eclipse.lsp4jakarta.jdt.core.utils.PositionUtils;
import org.eclipse.lsp4jakarta.jdt.internal.DiagnosticUtils;
import org.eclipse.lsp4jakarta.jdt.internal.Messages;
import org.eclipse.lsp4jakarta.jdt.internal.core.java.ManagedBean;
import org.eclipse.lsp4jakarta.jdt.internal.core.java.Primitive;
import org.eclipse.lsp4jakarta.jdt.internal.core.ls.JDTUtilsLSImpl;
import org.eclipse.lsp4jakarta.jdt.internal.di.ErrorCode;

public class DependencyInjectionDiagnosticsParticipant
implements IJavaDiagnosticsParticipant {
    @Override
    public List<Diagnostic> collectDiagnostics(JavaDiagnosticsContext context, IProgressMonitor monitor) throws CoreException {
        IType[] alltypes;
        String uri = context.getUri();
        IJDTUtils utils = JDTUtilsLSImpl.getInstance();
        ICompilationUnit unit = utils.resolveCompilationUnit(uri);
        ArrayList<Diagnostic> diagnostics = new ArrayList<Diagnostic>();
        if (unit == null) {
            return diagnostics;
        }
        IType[] iTypeArray = alltypes = unit.getAllTypes();
        int n = alltypes.length;
        int n2 = 0;
        while (n2 < n) {
            Range allMethods;
            Range range;
            IType type = iTypeArray[n2];
            IField[] allFields = type.getFields();
            IField[] iFieldArray = allFields;
            int n3 = allFields.length;
            int n4 = 0;
            while (n4 < n3) {
                IField field = iFieldArray[n4];
                if (Flags.isFinal((int)field.getFlags()) && this.containsAnnotation(type, field.getAnnotations(), "jakarta.inject.Inject")) {
                    String msg = Messages.getMessage("InjectNoFinalField", new Object[0]);
                    range = PositionUtils.toNameRange(field, context.getUtils());
                    diagnostics.add(context.createDiagnostic(uri, msg, range, "jakarta-di", ErrorCode.InvalidInjectAnnotationOnFinalField, DiagnosticSeverity.Error));
                }
                ++n4;
            }
            ArrayList<IMethod> injectedConstructors = new ArrayList<IMethod>();
            range = allMethods = type.getMethods();
            int msg = ((IMethod[])range).length;
            int n5 = 0;
            while (n5 < msg) {
                IMethod method = range[n5];
                Range range2 = PositionUtils.toNameRange(method, context.getUtils());
                int methodFlag = method.getFlags();
                if (this.containsAnnotation(type, method.getAnnotations(), "jakarta.inject.Inject")) {
                    String msg2;
                    if (DiagnosticUtils.isConstructorMethod(method)) {
                        injectedConstructors.add(method);
                    }
                    if (Flags.isFinal((int)methodFlag)) {
                        msg2 = Messages.getMessage("InjectNoFinalMethod", new Object[0]);
                        diagnostics.add(context.createDiagnostic(uri, msg2, range2, "jakarta-di", ErrorCode.InvalidInjectAnnotationOnFinalMethod, DiagnosticSeverity.Error));
                    }
                    if (Flags.isAbstract((int)methodFlag)) {
                        msg2 = Messages.getMessage("InjectNoAbstractMethod", new Object[0]);
                        diagnostics.add(context.createDiagnostic(uri, msg2, range2, "jakarta-di", ErrorCode.InvalidInjectAnnotationOnAbstractMethod, DiagnosticSeverity.Error));
                    }
                    if (Flags.isStatic((int)methodFlag)) {
                        msg2 = Messages.getMessage("InjectNoStaticMethod", new Object[0]);
                        diagnostics.add(context.createDiagnostic(uri, msg2, range2, "jakarta-di", ErrorCode.InvalidInjectAnnotationOnStaticMethod, DiagnosticSeverity.Error));
                    }
                    if (method.getTypeParameters().length != 0) {
                        msg2 = Messages.getMessage("InjectNoGenericMethod", new Object[0]);
                        diagnostics.add(context.createDiagnostic(uri, msg2, range2, "jakarta-di", ErrorCode.InvalidInjectAnnotationOnGenericMethod, DiagnosticSeverity.Error));
                    }
                }
                ++n5;
            }
            if (injectedConstructors.size() > 1) {
                String msg3 = Messages.getMessage("InjectMoreThanOneConstructor", new Object[0]);
                for (IMethod method : injectedConstructors) {
                    range = PositionUtils.toNameRange(method, context.getUtils());
                    diagnostics.add(context.createDiagnostic(uri, msg3, range, "jakarta-di", ErrorCode.InvalidInjectAnnotationOnMultipleConstructors, DiagnosticSeverity.Error));
                }
            }
            for (IMethod constructor : injectedConstructors) {
                if (constructor.getNumberOfParameters() <= 0) continue;
                ILocalVariable[] params = constructor.getParameters();
                int i = 0;
                while (i < params.length) {
                    ILocalVariable param = params[i];
                    this.getInjectionPointDiagnostics(diagnostics, context, uri, param);
                    ++i;
                }
            }
            ++n2;
        }
        return diagnostics;
    }

    private boolean containsAnnotation(IType type, IAnnotation[] annotations, String annotationFQName) {
        return Stream.of(annotations).anyMatch(annotation -> {
            try {
                return DiagnosticUtils.isMatchedJavaElement(type, annotation.getElementName(), annotationFQName);
            }
            catch (JavaModelException e) {
                JakartaCorePlugin.logException("Cannot validate annotations", e);
                return false;
            }
        });
    }

    private void getInjectionPointDiagnostics(List<Diagnostic> diagnostics, JavaDiagnosticsContext context, String uri, ILocalVariable variable) {
        try {
            String msg;
            Range range = PositionUtils.toNameRange(variable, context.getUtils());
            IType variableType = ManagedBean.variableSignatureToType(variable);
            if (Primitive.isPrimitive(variable)) {
                String msg2 = Messages.getMessage("InjectionPointInvalidPrimitiveBean", new Object[0]);
                diagnostics.add(context.createDiagnostic(uri, msg2, range, "jakarta-di", ErrorCode.InjectionPointInvalidPrimitiveBean, DiagnosticSeverity.Warning));
                return;
            }
            if (ManagedBean.isInnerClass(variableType)) {
                msg = Messages.getMessage("InjectionPointInvalidInnerClassBean", new Object[0]);
                diagnostics.add(context.createDiagnostic(uri, msg, range, "jakarta-di", ErrorCode.InjectionPointInvalidInnerClassBean, DiagnosticSeverity.Warning));
            }
            if (ManagedBean.isAbstractClass(variableType) && !ManagedBean.isAnnotatedClass(variableType, "jakarta.decorator.Decorator")) {
                msg = Messages.getMessage("InjectionPointInvalidAbstractClassBean", new Object[0]);
                diagnostics.add(context.createDiagnostic(uri, msg, range, "jakarta-di", ErrorCode.InjectionPointInvalidAbstractClassBean, DiagnosticSeverity.Warning));
            }
            if (ManagedBean.implementsExtends(variableType, "jakarta.enterprise.inject.spi.Extension")) {
                msg = Messages.getMessage("InjectionPointInvalidExtensionProviderBean", new Object[0]);
                diagnostics.add(context.createDiagnostic(uri, msg, range, "jakarta-di", ErrorCode.InjectionPointInvalidExtensionProviderBean, DiagnosticSeverity.Warning));
            }
            if (ManagedBean.isAnnotatedClass(variableType, "jakarta.enterprise.inject.Vetoed") || ManagedBean.isPackageMetadataAnnotated(variableType, "jakarta.enterprise.inject.Vetoed")) {
                msg = Messages.getMessage("InjectionPointInvalidVetoedClassBean", new Object[0]);
                diagnostics.add(context.createDiagnostic(uri, msg, range, "jakarta-di", ErrorCode.InjectionPointInvalidVetoedClassBean, DiagnosticSeverity.Warning));
            }
            if (!ManagedBean.containsValidConstructor(variableType)) {
                msg = Messages.getMessage("InjectionPointInvalidConstructorBean", new Object[0]);
                diagnostics.add(context.createDiagnostic(uri, msg, range, "jakarta-di", ErrorCode.InjectionPointInvalidConstructorBean, DiagnosticSeverity.Warning));
            }
        }
        catch (JavaModelException jme) {
            JakartaCorePlugin.logException("Cannot obtain injection point diagnostics for variable: " + variable + " in file: " + uri, jme);
        }
    }
}

