/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4jakarta.jdt.core.jsonb;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4jakarta.jdt.core.AbstractDiagnosticsCollector;
import org.eclipse.lsp4jakarta.jdt.core.JDTUtils;
import org.eclipse.lsp4jakarta.jdt.core.JakartaCorePlugin;
import org.eclipse.lsp4jakarta.jdt.core.jsonb.JsonbConstants;

public class JsonbDiagnosticsCollector
extends AbstractDiagnosticsCollector {
    @Override
    protected String getDiagnosticSource() {
        return "jakarta-jsonb";
    }

    @Override
    public void collectDiagnostics(ICompilationUnit unit, List<Diagnostic> diagnostics) {
        if (unit == null) {
            return;
        }
        try {
            IType[] types;
            IType[] iTypeArray = types = unit.getAllTypes();
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                IMethod method;
                IType type = iTypeArray[n2];
                IMethod[] methods = type.getMethods();
                ArrayList<IMethod> jonbMethods = new ArrayList<IMethod>();
                IMethod[] iMethodArray = type.getMethods();
                int n3 = iMethodArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    method = iMethodArray[n4];
                    if (JsonbDiagnosticsCollector.isConstructorMethod(method) || Flags.isStatic((int)method.getFlags())) {
                        IAnnotation[] allAnnotations;
                        IAnnotation[] iAnnotationArray = allAnnotations = method.getAnnotations();
                        int n5 = allAnnotations.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            IAnnotation annotation = iAnnotationArray[n6];
                            if (JsonbDiagnosticsCollector.isMatchedJavaElement(type, annotation.getElementName(), "jakarta.json.bind.annotation.JsonbCreator")) {
                                jonbMethods.add(method);
                            }
                            ++n6;
                        }
                    }
                    ++n4;
                }
                if (jonbMethods.size() > 1) {
                    iMethodArray = methods;
                    n3 = methods.length;
                    n4 = 0;
                    while (n4 < n3) {
                        method = iMethodArray[n4];
                        diagnostics.add(this.createDiagnostic((IJavaElement)method, unit, "Only one constructor or static factory method can be annotated with @JsonbCreator in a given class.", "MultipleJsonbCreatorAnnotations", null, DiagnosticSeverity.Error));
                        ++n4;
                    }
                }
                iMethodArray = type.getFields();
                n3 = iMethodArray.length;
                n4 = 0;
                while (n4 < n3) {
                    IMethod field = iMethodArray[n4];
                    this.collectJsonbTransientFieldDiagnostics(unit, type, diagnostics, (IField)field);
                    this.collectJsonbTransientAccessorDiagnostics(unit, type, diagnostics, (IField)field);
                    ++n4;
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            JakartaCorePlugin.logException("Cannot calculate jakarta-jsonb diagnostics", e);
        }
    }

    private void collectJsonbTransientFieldDiagnostics(ICompilationUnit unit, IType type, List<Diagnostic> diagnostics, IField field) throws JavaModelException {
        List<String> jsonbAnnotationsForField = this.getJsonbAnnotationNames(type, (IAnnotatable)field);
        if (jsonbAnnotationsForField.contains("jakarta.json.bind.annotation.JsonbTransient")) {
            boolean hasAccessorConflict = false;
            List<IMethod> accessors = JDTUtils.getFieldAccessors(unit, field);
            for (IMethod accessor : accessors) {
                List<String> jsonbAnnotationsForAccessor = this.getJsonbAnnotationNames(type, (IAnnotatable)accessor);
                if (!this.hasJsonbAnnotationOtherThanTransient(jsonbAnnotationsForAccessor)) continue;
                this.createJsonbTransientDiagnostic(unit, diagnostics, (IMember)accessor, jsonbAnnotationsForAccessor, "When a class field is annotated with @JsonbTransient, this field, getter or setter must not be annotated with other JSON Binding annotations.");
                hasAccessorConflict = true;
            }
            if (hasAccessorConflict || this.hasJsonbAnnotationOtherThanTransient(jsonbAnnotationsForField)) {
                this.createJsonbTransientDiagnostic(unit, diagnostics, (IMember)field, jsonbAnnotationsForField, "When a class field is annotated with @JsonbTransient, this field, getter or setter must not be annotated with other JSON Binding annotations.");
            }
        }
    }

    private void collectJsonbTransientAccessorDiagnostics(ICompilationUnit unit, IType type, List<Diagnostic> diagnostics, IField field) throws JavaModelException {
        boolean createDiagnosticForField = false;
        List<String> jsonbAnnotationsForField = this.getJsonbAnnotationNames(type, (IAnnotatable)field);
        List<IMethod> accessors = JDTUtils.getFieldAccessors(unit, field);
        for (IMethod accessor : accessors) {
            List<String> jsonbAnnotationsForAccessor = this.getJsonbAnnotationNames(type, (IAnnotatable)accessor);
            boolean hasFieldConflict = false;
            if (!jsonbAnnotationsForAccessor.contains("jakarta.json.bind.annotation.JsonbTransient")) continue;
            if (this.hasJsonbAnnotationOtherThanTransient(jsonbAnnotationsForField)) {
                createDiagnosticForField = true;
                hasFieldConflict = true;
            }
            if (!hasFieldConflict && !this.hasJsonbAnnotationOtherThanTransient(jsonbAnnotationsForAccessor)) continue;
            this.createJsonbTransientDiagnostic(unit, diagnostics, (IMember)accessor, jsonbAnnotationsForAccessor, "When an accessor is annotated with @JsonbTransient, its field or the accessor must not be annotated with other JSON Binding annotations.");
        }
        if (createDiagnosticForField) {
            this.createJsonbTransientDiagnostic(unit, diagnostics, (IMember)field, jsonbAnnotationsForField, "When an accessor is annotated with @JsonbTransient, its field or the accessor must not be annotated with other JSON Binding annotations.");
        }
    }

    private boolean createJsonbTransientDiagnostic(ICompilationUnit unit, List<Diagnostic> diagnostics, IMember member, List<String> jsonbAnnotations, String diagnosticErrorMessage) throws JavaModelException {
        String code = null;
        if (diagnosticErrorMessage.equals("When a class field is annotated with @JsonbTransient, this field, getter or setter must not be annotated with other JSON Binding annotations.")) {
            code = "NonmutualJsonbTransientAnnotation";
        } else if (diagnosticErrorMessage.equals("When an accessor is annotated with @JsonbTransient, its field or the accessor must not be annotated with other JSON Binding annotations.")) {
            code = "NonmutualJsonbTransientAnnotationOnAccessor";
        }
        List diagnosticData = jsonbAnnotations.stream().map(annotation -> JsonbDiagnosticsCollector.getSimpleName(annotation)).collect(Collectors.toList());
        diagnostics.add(this.createDiagnostic((IJavaElement)member, unit, diagnosticErrorMessage, code, (JsonArray)new Gson().toJsonTree(diagnosticData), DiagnosticSeverity.Error));
        return true;
    }

    private List<String> getJsonbAnnotationNames(IType type, IAnnotatable annotable) throws JavaModelException {
        IAnnotation[] annotations;
        ArrayList<String> jsonbAnnotationNames = new ArrayList<String>();
        IAnnotation[] iAnnotationArray = annotations = annotable.getAnnotations();
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            IAnnotation annotation = iAnnotationArray[n2];
            String matchedAnnotation = JsonbDiagnosticsCollector.getMatchedJavaElementName(type, annotation.getElementName(), (String[])JsonbConstants.JSONB_ANNOTATIONS.toArray(String[]::new));
            if (matchedAnnotation != null) {
                jsonbAnnotationNames.add(matchedAnnotation);
            }
            ++n2;
        }
        return jsonbAnnotationNames;
    }

    private boolean hasJsonbAnnotationOtherThanTransient(List<String> jsonbAnnotations) throws JavaModelException {
        for (String annotationName : jsonbAnnotations) {
            if (!JsonbConstants.JSONB_ANNOTATIONS.contains(annotationName) || annotationName.equals("jakarta.json.bind.annotation.JsonbTransient")) continue;
            return true;
        }
        return false;
    }
}

