/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4jakarta.jdt.codeAction.proposal.quickfix;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4jakarta.jdt.codeAction.JavaCodeActionContext;
import org.eclipse.lsp4jakarta.jdt.codeAction.proposal.quickfix.RemoveModifierConflictQuickFix;

public class RemoveParamAnnotationQuickFix
extends RemoveModifierConflictQuickFix {
    String[] annotations;

    public RemoveParamAnnotationQuickFix(String ... annotations) {
        super(annotations);
        this.annotations = annotations;
    }

    @Override
    public List<? extends CodeAction> getCodeActions(JavaCodeActionContext context, Diagnostic diagnostic, IProgressMonitor monitor) throws CoreException {
        ASTNode node = context.getCoveredNode();
        MethodDeclaration parentNode = (MethodDeclaration)node.getParent();
        IMethodBinding parentMethod = parentNode.resolveBinding();
        ArrayList<CodeAction> codeActions = new ArrayList<CodeAction>();
        List parameters = parentNode.parameters();
        for (SingleVariableDeclaration parameter : parameters) {
            List modifiers = (List)parameter.getStructuralProperty((StructuralPropertyDescriptor)SingleVariableDeclaration.MODIFIERS2_PROPERTY);
            ArrayList<String> annotationsToRemove = new ArrayList<String>();
            for (ASTNode modifier : modifiers) {
                Name markAnnotationTypeName = ((MarkerAnnotation)modifier).getTypeName();
                if (!Arrays.asList(this.annotations).stream().anyMatch(m -> m.equals(markAnnotationTypeName.toString()))) continue;
                annotationsToRemove.add(markAnnotationTypeName.toString());
            }
            StringBuilder sb = new StringBuilder("Remove the ");
            sb.append("'@").append((String)annotationsToRemove.get(0)).append("'");
            int i = 1;
            while (i < annotationsToRemove.size()) {
                sb.append(", '@").append((String)annotationsToRemove.get(i)).append("'");
                ++i;
            }
            sb.append(" modifier from parameter '").append(parameter.getName().toString()).append("'");
            this.removeModifier(diagnostic, context, (IBinding)parentMethod, codeActions, (ASTNode)parameter, sb.toString(), annotationsToRemove.toArray(new String[annotationsToRemove.size()]));
        }
        return codeActions;
    }
}

