/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4jakarta.jdt.core.websocket;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4jakarta.jdt.core.AbstractDiagnosticsCollector;
import org.eclipse.lsp4jakarta.jdt.core.JDTUtils;
import org.eclipse.lsp4jakarta.jdt.core.JakartaCorePlugin;
import org.eclipse.lsp4jakarta.jdt.core.TypeHierarchyUtils;
import org.eclipse.lsp4jakarta.jdt.core.websocket.WebSocketConstants;

public class WebSocketDiagnosticsCollector
extends AbstractDiagnosticsCollector {
    @Override
    protected String getDiagnosticSource() {
        return "jakarta-websocket";
    }

    @Override
    public void collectDiagnostics(ICompilationUnit unit, List<Diagnostic> diagnostics) {
        if (unit == null) {
            return;
        }
        HashMap<String, Boolean> checkWSEnd = null;
        try {
            IType[] alltypes;
            IType[] iTypeArray = alltypes = unit.getAllTypes();
            int n = alltypes.length;
            int n2 = 0;
            while (n2 < n) {
                IType type = iTypeArray[n2];
                checkWSEnd = this.isWSEndpoint(type);
                if (checkWSEnd.get("isAnnotation").booleanValue()) {
                    this.invalidParamsCheck(type, unit, diagnostics);
                    List<String> endpointPathVars = this.findAndProcessEndpointURI(type);
                    if (endpointPathVars != null) {
                        this.uriMismatchWarningCheck(type, endpointPathVars, diagnostics, unit);
                    }
                    this.onMessageWSMessageFormats(type, diagnostics, unit);
                    this.serverEndpointErrorCheck(type, diagnostics, unit);
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            JakartaCorePlugin.logException("Cannot calculate WebSocket diagnostics", e);
        }
    }

    private void invalidParamsCheck(IType type, ICompilationUnit unit, List<Diagnostic> diagnostics) throws JavaModelException {
        IMethod[] allMethods;
        IMethod[] iMethodArray = allMethods = type.getMethods();
        int n = allMethods.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod method = iMethodArray[n2];
            IAnnotation[] allAnnotations = method.getAnnotations();
            Set<String> specialParamTypes = null;
            Set<String> rawSpecialParamTypes = null;
            IAnnotation[] iAnnotationArray = allAnnotations;
            int n3 = allAnnotations.length;
            int n4 = 0;
            while (n4 < n3) {
                IAnnotation annotation = iAnnotationArray[n4];
                String annotationName = annotation.getElementName();
                String diagnosticCode = null;
                if (WebSocketDiagnosticsCollector.isMatchedJavaElement(type, annotationName, "jakarta.websocket.OnOpen")) {
                    specialParamTypes = WebSocketConstants.ON_OPEN_PARAM_OPT_TYPES;
                    rawSpecialParamTypes = WebSocketConstants.RAW_ON_OPEN_PARAM_OPT_TYPES;
                    diagnosticCode = "OnOpenChangeInvalidParam";
                } else if (WebSocketDiagnosticsCollector.isMatchedJavaElement(type, annotationName, "jakarta.websocket.OnClose")) {
                    specialParamTypes = WebSocketConstants.ON_CLOSE_PARAM_OPT_TYPES;
                    rawSpecialParamTypes = WebSocketConstants.RAW_ON_CLOSE_PARAM_OPT_TYPES;
                    diagnosticCode = "OnCloseChangeInvalidParam";
                }
                if (diagnosticCode != null) {
                    ILocalVariable[] allParams;
                    ILocalVariable[] iLocalVariableArray = allParams = method.getParameters();
                    int n5 = allParams.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        IAnnotation[] param_annotations;
                        boolean hasPathParamAnnot;
                        boolean isPrimWrapped;
                        boolean isSpecialType;
                        ILocalVariable param = iLocalVariableArray[n6];
                        String signature = param.getTypeSignature();
                        String formatSignature = signature.replace("/", ".");
                        String resolvedTypeName = JavaModelUtil.getResolvedTypeName((String)formatSignature, (IType)type);
                        boolean isPrimitive = JavaModelUtil.isPrimitive((String)formatSignature);
                        if (resolvedTypeName != null) {
                            isSpecialType = specialParamTypes.contains(resolvedTypeName);
                            isPrimWrapped = this.isWrapper(resolvedTypeName);
                        } else {
                            String simpleParamType = Signature.getSignatureSimpleName((String)signature);
                            isSpecialType = rawSpecialParamTypes.contains(simpleParamType);
                            isPrimWrapped = this.isWrapper(simpleParamType);
                        }
                        if (!(isSpecialType || isPrimWrapped || isPrimitive)) {
                            diagnostics.add(this.createDiagnostic((IJavaElement)param, unit, this.createParamTypeDiagMsg(specialParamTypes, annotationName), diagnosticCode, null, DiagnosticSeverity.Error));
                        } else if (!isSpecialType && !(hasPathParamAnnot = Arrays.asList(param_annotations = param.getAnnotations()).stream().anyMatch(annot -> {
                            try {
                                return WebSocketDiagnosticsCollector.isMatchedJavaElement(type, annot.getElementName(), "jakarta.websocket.server.PathParam");
                            }
                            catch (JavaModelException e) {
                                JakartaCorePlugin.logException("Failed to get matched annotation", e);
                                return false;
                            }
                        }))) {
                            diagnostics.add(this.createDiagnostic((IJavaElement)param, unit, "Parameters of type String, any Java primitive type, or boxed version thereof must be annotated with @PathParams.", "AddPathParamsAnnotation", null, DiagnosticSeverity.Error));
                        }
                        ++n6;
                    }
                }
                ++n4;
            }
            ++n2;
        }
    }

    private void uriMismatchWarningCheck(IType type, List<String> endpointPathVars, List<Diagnostic> diagnostics, ICompilationUnit unit) throws JavaModelException {
        IMethod[] typeMethods;
        IMethod[] iMethodArray = typeMethods = type.getMethods();
        int n = typeMethods.length;
        int n2 = 0;
        while (n2 < n) {
            ILocalVariable[] methodParams;
            IMethod method = iMethodArray[n2];
            ILocalVariable[] iLocalVariableArray = methodParams = method.getParameters();
            int n3 = methodParams.length;
            int n4 = 0;
            while (n4 < n3) {
                IAnnotation[] paramAnnotations;
                ILocalVariable param = iLocalVariableArray[n4];
                IAnnotation[] iAnnotationArray = paramAnnotations = param.getAnnotations();
                int n5 = paramAnnotations.length;
                int n6 = 0;
                while (n6 < n5) {
                    IAnnotation annotation = iAnnotationArray[n6];
                    if (WebSocketDiagnosticsCollector.isMatchedJavaElement(type, annotation.getElementName(), "jakarta.websocket.server.PathParam")) {
                        IMemberValuePair[] valuePairs;
                        IMemberValuePair[] iMemberValuePairArray = valuePairs = annotation.getMemberValuePairs();
                        int n7 = valuePairs.length;
                        int n8 = 0;
                        while (n8 < n7) {
                            String pathValue;
                            IMemberValuePair pair = iMemberValuePairArray[n8];
                            if (pair.getMemberName().equals("value") && pair.getValueKind() == 9 && !endpointPathVars.contains(pathValue = (String)pair.getValue())) {
                                diagnostics.add(this.createDiagnostic((IJavaElement)annotation, unit, "PathParam value does not match specified Endpoint URI", "ChangePathParamValue", null, DiagnosticSeverity.Warning));
                            }
                            ++n8;
                        }
                    }
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
    }

    private void onMessageWSMessageFormats(IType type, List<Diagnostic> diagnostics, ICompilationUnit unit) throws JavaModelException {
        IMethod[] typeMethods = type.getMethods();
        IAnnotation onMessageTextUsed = null;
        IAnnotation onMessageBinaryUsed = null;
        IAnnotation onMessagePongUsed = null;
        IMethod[] iMethodArray = typeMethods;
        int n = typeMethods.length;
        int n2 = 0;
        while (n2 < n) {
            IAnnotation[] allAnnotations;
            IMethod method = iMethodArray[n2];
            IAnnotation[] iAnnotationArray = allAnnotations = method.getAnnotations();
            int n3 = allAnnotations.length;
            int n4 = 0;
            while (n4 < n3) {
                IAnnotation annotation = iAnnotationArray[n4];
                if (WebSocketDiagnosticsCollector.isMatchedJavaElement(type, annotation.getElementName(), "jakarta.websocket.OnMessage")) {
                    ILocalVariable[] allParams;
                    ILocalVariable[] iLocalVariableArray = allParams = method.getParameters();
                    int n5 = allParams.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        ILocalVariable param = iLocalVariableArray[n6];
                        if (!this.isParamPath(type, param)) {
                            String signature = param.getTypeSignature();
                            String formatSignature = signature.replace("/", ".");
                            String resolvedTypeName = JavaModelUtil.getResolvedTypeName((String)formatSignature, (IType)type);
                            String typeName = null;
                            if (resolvedTypeName == null) {
                                typeName = Signature.getSignatureSimpleName((String)signature);
                            }
                            if (resolvedTypeName != null && WebSocketConstants.LONG_MESSAGE_CLASSES.contains(resolvedTypeName) || WebSocketConstants.SHORT_MESSAGE_CLASSES.contains(typeName)) {
                                WebSocketConstants.MESSAGE_FORMAT messageFormat = resolvedTypeName != null ? this.getMessageFormat(resolvedTypeName, true) : this.getMessageFormat(typeName, false);
                                switch (messageFormat) {
                                    case TEXT: {
                                        if (onMessageTextUsed != null) {
                                            diagnostics.add(this.createDiagnostic((IJavaElement)annotation, unit, "Classes annotated with @ServerEndpoint or @ClientEndpoint may only have one @OnMessage annotated method for each of the native WebSocket message formats: text, binary and pong.", "OnMessageDuplicateMethod", null, DiagnosticSeverity.Error));
                                            diagnostics.add(this.createDiagnostic((IJavaElement)onMessageTextUsed, unit, "Classes annotated with @ServerEndpoint or @ClientEndpoint may only have one @OnMessage annotated method for each of the native WebSocket message formats: text, binary and pong.", "OnMessageDuplicateMethod", null, DiagnosticSeverity.Error));
                                        }
                                        onMessageTextUsed = annotation;
                                        break;
                                    }
                                    case BINARY: {
                                        if (onMessageBinaryUsed != null) {
                                            diagnostics.add(this.createDiagnostic((IJavaElement)annotation, unit, "Classes annotated with @ServerEndpoint or @ClientEndpoint may only have one @OnMessage annotated method for each of the native WebSocket message formats: text, binary and pong.", "OnMessageDuplicateMethod", null, DiagnosticSeverity.Error));
                                            diagnostics.add(this.createDiagnostic((IJavaElement)onMessageBinaryUsed, unit, "Classes annotated with @ServerEndpoint or @ClientEndpoint may only have one @OnMessage annotated method for each of the native WebSocket message formats: text, binary and pong.", "OnMessageDuplicateMethod", null, DiagnosticSeverity.Error));
                                        }
                                        onMessageBinaryUsed = annotation;
                                        break;
                                    }
                                    case PONG: {
                                        if (onMessagePongUsed != null) {
                                            diagnostics.add(this.createDiagnostic((IJavaElement)annotation, unit, "Classes annotated with @ServerEndpoint or @ClientEndpoint may only have one @OnMessage annotated method for each of the native WebSocket message formats: text, binary and pong.", "OnMessageDuplicateMethod", null, DiagnosticSeverity.Error));
                                            diagnostics.add(this.createDiagnostic((IJavaElement)onMessagePongUsed, unit, "Classes annotated with @ServerEndpoint or @ClientEndpoint may only have one @OnMessage annotated method for each of the native WebSocket message formats: text, binary and pong.", "OnMessageDuplicateMethod", null, DiagnosticSeverity.Error));
                                        }
                                        onMessagePongUsed = annotation;
                                    }
                                }
                            }
                        }
                        ++n6;
                    }
                }
                ++n4;
            }
            ++n2;
        }
    }

    private void serverEndpointErrorCheck(IType type, List<Diagnostic> diagnostics, ICompilationUnit unit) throws JavaModelException {
        IAnnotation[] annotations;
        IAnnotation[] iAnnotationArray = annotations = type.getAnnotations();
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            IAnnotation annotation = iAnnotationArray[n2];
            if (WebSocketDiagnosticsCollector.isMatchedJavaElement(type, annotation.getElementName(), "jakarta.websocket.server.ServerEndpoint")) {
                IMemberValuePair[] iMemberValuePairArray = annotation.getMemberValuePairs();
                int n3 = iMemberValuePairArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IMemberValuePair annotationMemberValuePair = iMemberValuePairArray[n4];
                    if (annotationMemberValuePair.getMemberName().equals("value")) {
                        String path = annotationMemberValuePair.getValue().toString();
                        if (!JDTUtils.hasLeadingSlash(path)) {
                            diagnostics.add(this.createDiagnostic((IJavaElement)annotation, unit, "Server endpoint paths must start with a leading '/'.", "ChangeInvalidServerEndpoint", null, DiagnosticSeverity.Error));
                        }
                        if (this.hasRelativePathURIs(path)) {
                            diagnostics.add(this.createDiagnostic((IJavaElement)annotation, unit, "Server endpoint paths must not contain the sequences '/../', '/./' or '//'.", "ChangeInvalidServerEndpoint", null, DiagnosticSeverity.Error));
                        } else if (!JDTUtils.isValidLevel1URI(path)) {
                            diagnostics.add(this.createDiagnostic((IJavaElement)annotation, unit, "Server endpoint paths must be a URI-template (level-1) or a partial URI.", "ChangeInvalidServerEndpoint", null, DiagnosticSeverity.Error));
                        }
                        if (this.hasDuplicateURIVariables(path)) {
                            diagnostics.add(this.createDiagnostic((IJavaElement)annotation, unit, "Server endpoint paths must not use the same variable more than once in a path.", "ChangeInvalidServerEndpoint", null, DiagnosticSeverity.Error));
                        }
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    private List<String> findAndProcessEndpointURI(IType type) throws JavaModelException {
        String[] endpointParts;
        String endpointURI = null;
        IAnnotation[] typeAnnotations = type.getAnnotations();
        String[] targetAnnotations = new String[]{"jakarta.websocket.server.ServerEndpoint", "jakarta.websocket.ClientEndpoint"};
        IAnnotation[] iAnnotationArray = typeAnnotations;
        int n = typeAnnotations.length;
        int n2 = 0;
        while (n2 < n) {
            IAnnotation annotation = iAnnotationArray[n2];
            String matchedAnnotation = WebSocketDiagnosticsCollector.getMatchedJavaElementName(type, annotation.getElementName(), targetAnnotations);
            if (matchedAnnotation != null) {
                IMemberValuePair[] valuePairs;
                IMemberValuePair[] iMemberValuePairArray = valuePairs = annotation.getMemberValuePairs();
                int n3 = valuePairs.length;
                int n4 = 0;
                while (n4 < n3) {
                    IMemberValuePair pair = iMemberValuePairArray[n4];
                    if (pair.getMemberName().equals("value") && pair.getValueKind() == 9) {
                        endpointURI = (String)pair.getValue();
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        if (endpointURI == null) {
            return null;
        }
        ArrayList<String> endpointPathVars = new ArrayList<String>();
        String[] stringArray = endpointParts = endpointURI.split("/");
        int n5 = endpointParts.length;
        int n6 = 0;
        while (n6 < n5) {
            String part = stringArray[n6];
            if (part.startsWith("{") && part.endsWith("}")) {
                endpointPathVars.add(part.substring(1, part.length() - 1));
            }
            ++n6;
        }
        return endpointPathVars;
    }

    private boolean isWrapper(String valueClass) {
        return WebSocketConstants.WRAPPER_OBJS.contains(valueClass) || WebSocketConstants.RAW_WRAPPER_OBJS.contains(valueClass);
    }

    private HashMap<String, Boolean> isWSEndpoint(IType type) throws JavaModelException {
        HashMap<String, Boolean> wsEndpoint = new HashMap<String, Boolean>();
        if (!type.isClass()) {
            wsEndpoint.put("isAnnotation", false);
            wsEndpoint.put("isSuperclass", false);
            return wsEndpoint;
        }
        List<String> endpointAnnotations = WebSocketDiagnosticsCollector.getMatchedJavaElementNames(type, (String[])Stream.of(type.getAnnotations()).map(annotation -> annotation.getElementName()).toArray(String[]::new), WebSocketConstants.WS_ANNOTATION_CLASS);
        boolean useSuperclass = false;
        try {
            useSuperclass = TypeHierarchyUtils.doesITypeHaveSuperType(type, "Endpoint") >= 0;
        }
        catch (CoreException e) {
            JakartaCorePlugin.logException("Cannot calculate WebSocket diagnostics", e);
        }
        wsEndpoint.put("isAnnotation", endpointAnnotations.size() > 0);
        wsEndpoint.put("isSuperclass", useSuperclass);
        return wsEndpoint;
    }

    private boolean isParamPath(IType type, ILocalVariable param) throws JavaModelException {
        IAnnotation[] allVariableAnnotations;
        IAnnotation[] iAnnotationArray = allVariableAnnotations = param.getAnnotations();
        int n = allVariableAnnotations.length;
        int n2 = 0;
        while (n2 < n) {
            IAnnotation variableAnnotation = iAnnotationArray[n2];
            if (WebSocketDiagnosticsCollector.isMatchedJavaElement(type, variableAnnotation.getElementName(), "jakarta.websocket.server.PathParam")) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private WebSocketConstants.MESSAGE_FORMAT getMessageFormat(String typeName, boolean longName) {
        block38: {
            if (!longName) break block38;
            switch (typeName) {
                case "java.lang.String": {
                    return WebSocketConstants.MESSAGE_FORMAT.TEXT;
                }
                case "java.io.Reader": {
                    return WebSocketConstants.MESSAGE_FORMAT.TEXT;
                }
                case "java.nio.ByteBuffer": {
                    return WebSocketConstants.MESSAGE_FORMAT.BINARY;
                }
                case "java.io.InputStream": {
                    return WebSocketConstants.MESSAGE_FORMAT.BINARY;
                }
                case "jakarta.websocket.PongMessage": {
                    return WebSocketConstants.MESSAGE_FORMAT.PONG;
                }
            }
            throw new IllegalArgumentException("Invalid message format type");
        }
        switch (typeName) {
            case "String": {
                return WebSocketConstants.MESSAGE_FORMAT.TEXT;
            }
            case "Reader": {
                return WebSocketConstants.MESSAGE_FORMAT.TEXT;
            }
            case "ByteBuffer": {
                return WebSocketConstants.MESSAGE_FORMAT.BINARY;
            }
            case "InputStream": {
                return WebSocketConstants.MESSAGE_FORMAT.BINARY;
            }
            case "PongMessage": {
                return WebSocketConstants.MESSAGE_FORMAT.PONG;
            }
        }
        throw new IllegalArgumentException("Invalid message format type");
    }

    private String createParamTypeDiagMsg(Set<String> methodParamOptTypes, String methodAnnotTarget) {
        String paramMessage = String.join((CharSequence)"\n- ", methodParamOptTypes);
        return String.format("Invalid parameter type. When using %s, parameter must be of type: \n- %s\n- annotated with @PathParams and of type String or any Java primitive type or boxed version thereof", "@" + methodAnnotTarget, paramMessage);
    }

    private boolean hasRelativePathURIs(String uriString) {
        return uriString.matches(".*\\/\\.{0,2}\\/.*");
    }

    private boolean hasDuplicateURIVariables(String uriString) {
        HashSet<String> variables = new HashSet<String>();
        String[] stringArray = uriString.split("/");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String segment = stringArray[n2];
            if (segment.matches("\\{(\\w|-|%20|%21|%23|%24|%25|%26|%27|%28|%29|%2A|%2B|%2C|%2F|%3A|%3B|%3D|%3F|%40|%5B|%5D)+\\}")) {
                String variable = segment.substring(1, segment.length() - 1);
                if (variables.contains(variable)) {
                    return true;
                }
                variables.add(variable);
            }
            ++n2;
        }
        return false;
    }
}

