/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4jakarta.jdt.core.servlet;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4jakarta.jdt.core.AbstractDiagnosticsCollector;
import org.eclipse.lsp4jakarta.jdt.core.JakartaCorePlugin;
import org.eclipse.lsp4jakarta.jdt.core.TypeHierarchyUtils;

public class ServletDiagnosticsCollector
extends AbstractDiagnosticsCollector {
    @Override
    protected String getDiagnosticSource() {
        return "jakarta-servlet";
    }

    @Override
    public void collectDiagnostics(ICompilationUnit unit, List<Diagnostic> diagnostics) {
        if (unit != null) {
            try {
                IType[] alltypes;
                IType[] iTypeArray = alltypes = unit.getAllTypes();
                int n = alltypes.length;
                int n2 = 0;
                while (n2 < n) {
                    IType type = iTypeArray[n2];
                    IAnnotation[] allAnnotations = type.getAnnotations();
                    IAnnotation webServletAnnotation = null;
                    IAnnotation[] iAnnotationArray = allAnnotations;
                    int n3 = allAnnotations.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IAnnotation annotation = iAnnotationArray[n4];
                        if (ServletDiagnosticsCollector.isMatchedJavaElement(type, annotation.getElementName(), "jakarta.servlet.annotation.WebServlet")) {
                            webServletAnnotation = annotation;
                            break;
                        }
                        ++n4;
                    }
                    if (webServletAnnotation != null) {
                        try {
                            int r = TypeHierarchyUtils.doesITypeHaveSuperType(type, "HttpServlet");
                            if (r == -1) {
                                diagnostics.add(this.createDiagnostic((IJavaElement)type, unit, "Annotated classes with @WebServlet must extend the HttpServlet class.", "ExtendHttpServlet", null, DiagnosticSeverity.Error));
                            } else if (r == 0) {
                                diagnostics.add(this.createDiagnostic((IJavaElement)type, unit, "Annotated classes with @WebServlet should extend the HttpServlet class.", "ExtendHttpServlet", null, DiagnosticSeverity.Warning));
                            }
                        }
                        catch (CoreException e) {
                            JakartaCorePlugin.logException("Cannot check type hierarchy", e);
                        }
                        IMemberValuePair[] memberValues = webServletAnnotation.getMemberValuePairs();
                        boolean isUrlpatternSpecified = false;
                        boolean isValueSpecified = false;
                        IMemberValuePair[] iMemberValuePairArray = memberValues;
                        int n5 = memberValues.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            IMemberValuePair mv = iMemberValuePairArray[n6];
                            if (mv.getMemberName().equals("urlPatterns")) {
                                isUrlpatternSpecified = true;
                            } else if (mv.getMemberName().equals("value")) {
                                isValueSpecified = true;
                            }
                            ++n6;
                        }
                        if (!isUrlpatternSpecified && !isValueSpecified) {
                            diagnostics.add(this.createDiagnostic((IJavaElement)webServletAnnotation, unit, "The annotation @WebServlet must define the attribute 'urlPatterns' or 'value'.", "CompleteHttpServletAttributes", null, DiagnosticSeverity.Error));
                        }
                        if (isUrlpatternSpecified && isValueSpecified) {
                            diagnostics.add(this.createDiagnostic((IJavaElement)webServletAnnotation, unit, "The annotation @WebServlet cannot have both 'value' and 'urlPatterns' attributes specified at once.", "InvalidHttpServletAttribute", null, DiagnosticSeverity.Error));
                        }
                    }
                    ++n2;
                }
            }
            catch (JavaModelException e) {
                JakartaCorePlugin.logException("Cannot check type hierarchy", e);
            }
        }
    }
}

