/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4jakarta.jdt.core.jax_rs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4jakarta.jdt.core.AbstractDiagnosticsCollector;
import org.eclipse.lsp4jakarta.jdt.core.JakartaCorePlugin;
import org.eclipse.lsp4jakarta.jdt.core.jax_rs.Jax_RSConstants;

public class Jax_RSClassDiagnosticsCollector
extends AbstractDiagnosticsCollector {
    @Override
    protected String getDiagnosticSource() {
        return "jakarta-jax_rs";
    }

    @Override
    public void collectDiagnostics(ICompilationUnit unit, List<Diagnostic> diagnostics) {
        if (unit != null) {
            try {
                IType[] alltypes;
                IType[] iTypeArray = alltypes = unit.getAllTypes();
                int n = alltypes.length;
                int n2 = 0;
                while (n2 < n) {
                    IAnnotation[] annotationList;
                    IType type = iTypeArray[n2];
                    boolean isRootResource = false;
                    boolean isProviderResource = false;
                    IAnnotation[] iAnnotationArray = annotationList = type.getAnnotations();
                    int n3 = annotationList.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IAnnotation annotation = iAnnotationArray[n4];
                        String matchedAnnotation = Jax_RSClassDiagnosticsCollector.getMatchedJavaElementName(type, annotation.getElementName(), Jax_RSConstants.SET_OF_JAXRS_ANNOTATIONS1);
                        if (matchedAnnotation != null) {
                            if ("jakarta.ws.rs.Path".equals(matchedAnnotation)) {
                                isRootResource = true;
                            } else if ("jakarta.ws.rs.ext.Provider".equals(matchedAnnotation)) {
                                isProviderResource = true;
                            }
                        }
                        ++n4;
                    }
                    if (isRootResource || isProviderResource) {
                        IMethod[] methods;
                        ArrayList<IMethod> nonPublicConstructors = new ArrayList<IMethod>();
                        boolean hasPublicConstructor = false;
                        int maxParams = 0;
                        HashMap<IMethod, Integer> constructorParamsMap = new HashMap<IMethod, Integer>();
                        IMethod[] iMethodArray = methods = type.getMethods();
                        int n5 = methods.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            IMethod method = iMethodArray[n6];
                            if (Jax_RSClassDiagnosticsCollector.isConstructorMethod(method)) {
                                if (Flags.isPublic((int)method.getFlags())) {
                                    hasPublicConstructor = true;
                                    nonPublicConstructors.clear();
                                    if (isRootResource) {
                                        int numParams = method.getNumberOfParameters();
                                        if (numParams > maxParams) {
                                            maxParams = numParams;
                                        }
                                        constructorParamsMap.put(method, numParams);
                                    }
                                } else if (!hasPublicConstructor) {
                                    nonPublicConstructors.add(method);
                                }
                            }
                            ++n6;
                        }
                        if (nonPublicConstructors.size() > 0) {
                            String diagnosticMessage = isRootResource ? "Root resource classes are instantiated by the JAX-RS runtime and MUST have a public constructor" : "Provider classes are instantiated by the JAX-RS runtime and MUST have a public constructor";
                            for (IMethod constructor : nonPublicConstructors) {
                                diagnostics.add(this.createDiagnostic((IJavaElement)constructor, unit, diagnosticMessage, "NoPublicConstructors", null, DiagnosticSeverity.Error));
                            }
                        }
                        ArrayList<IMethod> equalMaxParamMethods = new ArrayList<IMethod>();
                        for (Map.Entry entry : constructorParamsMap.entrySet()) {
                            if ((Integer)entry.getValue() == maxParams) {
                                equalMaxParamMethods.add((IMethod)entry.getKey());
                                continue;
                            }
                            if ((Integer)entry.getValue() >= maxParams) continue;
                            IMethod method = (IMethod)entry.getKey();
                            diagnostics.add(this.createDiagnostic((IJavaElement)method, unit, "This constructor is unused, as root resource classes will only use the constructor with the most parameters.", "UnusedConstructor", null, DiagnosticSeverity.Warning));
                        }
                        if (equalMaxParamMethods.size() > 1) {
                            for (IMethod method : equalMaxParamMethods) {
                                diagnostics.add(this.createDiagnostic((IJavaElement)method, unit, "Multiple constructors have the same number of parameters, it may be ambiguous which constructor is used.", "AmbiguousConstructors", null, DiagnosticSeverity.Warning));
                            }
                        }
                    }
                    ++n2;
                }
            }
            catch (JavaModelException e) {
                JakartaCorePlugin.logException("Cannot calculate JAX-RS diagnostics", e);
            }
        }
    }
}

