/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4jakarta.jdt.internal.core.ls;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ls.core.internal.IDelegateCommandHandler;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionContext;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.jsonrpc.CompletableFutures;
import org.eclipse.lsp4jakarta.commons.JakartaJavaCodeActionParams;
import org.eclipse.lsp4jakarta.jdt.core.JDTServicesManager;
import org.eclipse.lsp4jakarta.jdt.core.JDTUtils;
import org.eclipse.lsp4jakarta.jdt.internal.core.ls.ArgumentUtils;

public class JakartaDelegateCommandHandlerForJava
implements IDelegateCommandHandler {
    private static final String JAVA_CODEACTION_COMMAND_ID = "jakarta/java/codeaction";
    private static final String JAVA_COMPLETION_COMMAND_ID = "jakarta/java/classpath";
    private static final String JAVA_DIAGNOSTICS_COMMAND_ID = "jakarta/java/diagnostics";

    public Object executeCommand(String commandId, List<Object> arguments, IProgressMonitor monitor) throws Exception {
        JavaLanguageServerPlugin.logInfo((String)String.format("Executing command '%s' in LSP4Jakarta JDT LS extension", commandId));
        switch (commandId) {
            case "jakarta/java/codeaction": {
                return this.getCodeActionForJava(arguments, commandId, monitor).get();
            }
            case "jakarta/java/classpath": {
                return this.getContextBasedFilter(arguments, commandId, monitor).get();
            }
            case "jakarta/java/diagnostics": {
                return this.getDiagnosticsForJava(arguments, commandId, monitor).get();
            }
        }
        throw new UnsupportedOperationException(String.format("Unsupported command '%s'!", commandId));
    }

    public CompletableFuture<Object> getContextBasedFilter(List<Object> arguments, String commandId, IProgressMonitor monitor) {
        Map<String, Object> obj = ArgumentUtils.getFirst(arguments);
        if (obj == null) {
            throw new UnsupportedOperationException(String.format("Command '%s' must be called with one JakartaClasspathParams argument", commandId));
        }
        String uri = ArgumentUtils.getString(obj, "uri");
        List<String> snippetCtx = ArgumentUtils.getStringList(obj, "snippetCtx");
        return CompletableFutures.computeAsync(cancelChecker -> JDTServicesManager.getInstance().getExistingContextsFromClassPath(uri, snippetCtx));
    }

    private CompletableFuture<List<PublishDiagnosticsParams>> getDiagnosticsForJava(List<Object> arguments, String commandId, IProgressMonitor monitor) {
        Map<String, Object> obj = ArgumentUtils.getFirst(arguments);
        if (obj == null) {
            throw new UnsupportedOperationException(String.format("Command '%s' must be called with one JakartaDiagnosticsParams argument", commandId));
        }
        List<String> uri = ArgumentUtils.getStringList(obj, "uris");
        return CompletableFutures.computeAsync(cancelChecker -> {
            List<Object> publishDiagnostics = new ArrayList();
            publishDiagnostics = JDTServicesManager.getInstance().getJavaDiagnostics(uri, monitor);
            return publishDiagnostics;
        });
    }

    private CompletableFuture<List<CodeAction>> getCodeActionForJava(List<Object> arguments, String commandId, IProgressMonitor monitor) {
        Map<String, Object> obj = ArgumentUtils.getFirst(arguments);
        if (obj == null) {
            throw new UnsupportedOperationException(String.format("Command '%s' must be called with one JakartaJavaCodeActionParams argument", commandId));
        }
        TextDocumentIdentifier textDocumentIdentifier = ArgumentUtils.getTextDocumentIdentifier(obj, "textDocument");
        if (textDocumentIdentifier == null) {
            throw new UnsupportedOperationException(String.format("Command '%s' must be called with required JakartaJavaCodeActionParams.texdDocumentIdentifier", commandId));
        }
        Range range = ArgumentUtils.getRange(obj, "range");
        CodeActionContext context = ArgumentUtils.getCodeActionContext(obj, "context");
        boolean resourceOperationSupported = ArgumentUtils.getBoolean(obj, "resourceOperationSupported");
        JakartaJavaCodeActionParams params = new JakartaJavaCodeActionParams();
        params.setTextDocument(textDocumentIdentifier);
        params.setRange(range);
        params.setContext(context);
        params.setResourceOperationSupported(resourceOperationSupported);
        JDTUtils utils = new JDTUtils();
        return CompletableFutures.computeAsync(cancelChecker -> {
            List<Object> codeActions = new ArrayList();
            try {
                codeActions = JDTServicesManager.getInstance().getCodeAction(params, utils, monitor);
            }
            catch (JavaModelException e) {
                JavaLanguageServerPlugin.logException((String)String.format("Command '%s' unable to gather code actions", commandId), (Throwable)e);
            }
            return codeActions;
        });
    }
}

