/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4jakarta.jdt.codeAction;

import java.util.Arrays;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4jakarta.commons.JakartaJavaCodeActionParams;
import org.eclipse.lsp4jakarta.jdt.codeAction.AbstractJavaContext;
import org.eclipse.lsp4jakarta.jdt.codeAction.IInvocationContext;
import org.eclipse.lsp4jakarta.jdt.codeAction.proposal.ChangeCorrectionProposal;
import org.eclipse.lsp4jakarta.jdt.core.ChangeUtil;
import org.eclipse.lsp4jakarta.jdt.core.JDTUtils;

public class JavaCodeActionContext
extends AbstractJavaContext
implements IInvocationContext {
    private final int selectionOffset;
    private final int selectionLength;
    private final JakartaJavaCodeActionParams params;
    private NodeFinder fNodeFinder;

    public JavaCodeActionContext(ITypeRoot typeRoot, int selectionOffset, int selectionLength, JDTUtils utils, JakartaJavaCodeActionParams params) {
        super(params.getUri(), typeRoot, utils);
        this.selectionOffset = selectionOffset;
        this.selectionLength = selectionLength;
        this.params = params;
    }

    public JakartaJavaCodeActionParams getParams() {
        return this.params;
    }

    @Override
    public ICompilationUnit getCompilationUnit() {
        return (ICompilationUnit)this.getTypeRoot();
    }

    @Override
    public int getSelectionLength() {
        return this.selectionLength;
    }

    @Override
    public int getSelectionOffset() {
        return this.selectionOffset;
    }

    @Override
    public ASTNode getCoveringNode() {
        if (this.fNodeFinder == null) {
            this.fNodeFinder = new NodeFinder((ASTNode)this.getASTRoot(), this.selectionOffset, this.selectionLength);
        }
        return this.fNodeFinder.getCoveringNode();
    }

    @Override
    public ASTNode getCoveredNode() {
        if (this.fNodeFinder == null) {
            this.fNodeFinder = new NodeFinder((ASTNode)this.getASTRoot(), this.selectionOffset, this.selectionLength);
        }
        return this.fNodeFinder.getCoveredNode();
    }

    public CodeAction convertToCodeAction(ChangeCorrectionProposal proposal, Diagnostic ... diagnostics) throws CoreException {
        String name = proposal.getName();
        WorkspaceEdit edit = ChangeUtil.convertToWorkspaceEdit(proposal.getChange(), this.getUri(), this.getUtils(), this.params.isResourceOperationSupported());
        if (!ChangeUtil.hasChanges(edit)) {
            return null;
        }
        CodeAction codeAction = new CodeAction();
        codeAction.setTitle(name);
        codeAction.setKind(proposal.getKind());
        codeAction.setEdit(edit);
        codeAction.setDiagnostics(Arrays.asList(diagnostics));
        return codeAction;
    }
}

