/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.completion;

import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.lsp4e.operations.completion.CompletionProposalTools;
import org.junit.Assert;
import org.junit.Test;

public class ScoreOfFilterMatchTest {
    private static final Random RANDOM = new Random();

    private static String generateRandomString(int maxLength) {
        int length = RANDOM.nextInt(maxLength + 1);
        if (length == 0) {
            return "";
        }
        Object chars = "abcdefghijklmnopqrstuvwxyz\u00e4\u00f6\u00fc\u00df";
        chars = "_" + (String)chars + ((String)chars).toUpperCase();
        StringBuilder sb = new StringBuilder(length);
        int i = 0;
        while (i < length) {
            sb.append(((String)chars).charAt(RANDOM.nextInt(((String)chars).length())));
            ++i;
        }
        return sb.toString();
    }

    @Test
    public void testCaseInsensitivity() {
        String documentFilter = "Example";
        String completionFilter = "eXaMpLe";
        boolean expectedScore = false;
        int actualScore = CompletionProposalTools.getScoreOfFilterMatch((String)"Example", (String)"eXaMpLe");
        Assert.assertEquals((String)"The score should be 0 for case-insensitive matches.", (long)0L, (long)actualScore);
    }

    @Test
    public void testEmptyCompletionFilter() {
        String documentFilter = "example";
        String completionFilter = "";
        int expectedScore = -1;
        int actualScore = CompletionProposalTools.getScoreOfFilterMatch((String)"example", (String)"");
        Assert.assertEquals((String)"The score should be -1 for an empty completionFilter.", (long)-1L, (long)actualScore);
    }

    @Test
    public void testEmptyDocumentFilter() {
        String documentFilter = "";
        String completionFilter = "example";
        boolean expectedScore = false;
        int actualScore = CompletionProposalTools.getScoreOfFilterMatch((String)"", (String)"example");
        Assert.assertEquals((String)"The score should be 0 for an empty documentFilter.", (long)0L, (long)actualScore);
    }

    @Test
    public void testRandomFilters() {
        int testCases = 50000;
        int timeoutMS = 3;
        ExecutorService executor = Executors.newSingleThreadExecutor();
        int i = 0;
        while (i < 50000) {
            String commonPrefix = ScoreOfFilterMatchTest.generateRandomString(2);
            String documentFilter = commonPrefix + ScoreOfFilterMatchTest.generateRandomString(5);
            String completionFilter = commonPrefix + ScoreOfFilterMatchTest.generateRandomString(15);
            Future<Integer> future = executor.submit(() -> CompletionProposalTools.getScoreOfFilterMatch((String)documentFilter, (String)completionFilter));
            try {
                future.get(3L, TimeUnit.SECONDS);
            }
            catch (TimeoutException e) {
                future.cancel(true);
                Assert.fail((String)("Possible infinite loop detected in getScoreOfFilterMatch with inputs: documentFilter='" + documentFilter + "', completionFilter='" + completionFilter + "'"));
            }
            catch (Exception e) {
                Assert.fail((String)("Unexpected exception: " + e.getMessage()));
            }
            ++i;
        }
        executor.shutdown();
    }

    @Test
    public void testExactMatch() {
        String documentFilter = "example";
        String completionFilter = "example";
        boolean expectedScore = false;
        int actualScore = CompletionProposalTools.getScoreOfFilterMatch((String)"example", (String)"example");
        Assert.assertEquals((String)"The score should be 0 for exact matches.", (long)0L, (long)actualScore);
    }

    @Test
    public void testNoMatch() {
        String documentFilter = "foo";
        String completionFilter = "example";
        int expectedScore = -1;
        int actualScore = CompletionProposalTools.getScoreOfFilterMatch((String)"foo", (String)"example");
        Assert.assertEquals((String)"The score should be -1 when there's no match.", (long)-1L, (long)actualScore);
    }

    @Test
    public void testPrefixMatch() {
        String documentFilter = "ex";
        String completionFilter = "example";
        boolean expectedScore = false;
        int actualScore = CompletionProposalTools.getScoreOfFilterMatch((String)"ex", (String)"example");
        Assert.assertEquals((String)"The score should be 0 when documentFilter is a prefix.", (long)0L, (long)actualScore);
    }

    @Test
    public void testScatteredMatch() {
        String documentFilter = "eap";
        String completionFilter = "example";
        int expectedScore = 6;
        int actualScore = CompletionProposalTools.getScoreOfFilterMatch((String)"eap", (String)"example");
        Assert.assertEquals((String)"The score should account for scattered characters.", (long)6L, (long)actualScore);
    }
}

