/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.symbols;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerWrapper;
import org.eclipse.lsp4e.LanguageServers;
import org.eclipse.lsp4e.internal.LSPDocumentAbstractHandler;
import org.eclipse.lsp4e.operations.symbols.LSPSymbolInFileDialog;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.texteditor.ITextEditor;

public class LSPSymbolInFileHandler
extends LSPDocumentAbstractHandler {
    @Override
    protected void execute(ExecutionEvent event, ITextEditor textEditor) {
        IDocument document = LSPEclipseUtils.getDocument(textEditor);
        if (document == null) {
            return;
        }
        Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        if (shell == null) {
            return;
        }
        ((LanguageServers.LanguageServerDocumentExecutor)LanguageServers.forDocument(document).withCapability(ServerCapabilities::getDocumentSymbolProvider)).computeFirst((w, ls) -> CompletableFuture.completedFuture(w)).thenAcceptAsync(oW -> oW.ifPresent(w -> {
            if (w != null) {
                new LSPSymbolInFileDialog(shell, textEditor, document, (LanguageServerWrapper)w).open();
            }
        }), (Executor)shell.getDisplay());
    }

    public void setEnabled(Object evaluationContext) {
        this.setEnabled(ServerCapabilities::getDocumentSymbolProvider, (ITextEditor x) -> true);
    }
}

