/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.typeHierarchy;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.IFileBuffer;
import org.eclipse.core.filebuffers.IFileBufferListener;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.viewers.DecoratingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DecorationContext;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServerWrapper;
import org.eclipse.lsp4e.LanguageServers;
import org.eclipse.lsp4e.internal.FileBufferListenerAdapter;
import org.eclipse.lsp4e.operations.typeHierarchy.TypeHierarchyItemLabelProvider;
import org.eclipse.lsp4e.operations.typeHierarchy.TypeHierarchyViewContentProvider;
import org.eclipse.lsp4e.operations.typeHierarchy.TypeMemberContentProvider;
import org.eclipse.lsp4e.outline.SymbolsLabelProvider;
import org.eclipse.lsp4e.outline.SymbolsModel;
import org.eclipse.lsp4e.ui.LSPImages;
import org.eclipse.lsp4e.ui.Messages;
import org.eclipse.lsp4e.ui.views.HierarchyViewInput;
import org.eclipse.lsp4j.DocumentSymbol;
import org.eclipse.lsp4j.DocumentSymbolParams;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.SymbolKind;
import org.eclipse.lsp4j.TypeHierarchyItem;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.ViewPart;

public class TypeHierarchyView
extends ViewPart {
    public static final String ID = "org.eclipse.lsp4e.operations.typeHierarchy.TypeHierarchyView";
    TypeHierarchyViewContentProvider contentProvider = new TypeHierarchyViewContentProvider();
    DecoratingStyledCellLabelProvider symbolsLabelProvider = new DecoratingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new SymbolsLabelProvider(), PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator(), DecorationContext.DEFAULT_CONTEXT);
    private PageBook pagebook;
    private SashForm splitter;
    private ViewForm memberViewForm;
    private CLabel memberLabel;
    private Label infoText;
    private TableViewer memberViewer;
    protected TreeViewer treeViewer;
    private HashMap<URI, SymbolsContainer> cachedSymbols = new HashMap();
    private IDocument document;
    private volatile String typeName;
    private final IFileBufferListener fileBufferListener = new FileBufferListenerAdapter(){

        @Override
        public void dirtyStateChanged(IFileBuffer buffer, boolean isDirty) {
            SymbolsContainer cachedSymbol;
            if (isDirty && (cachedSymbol = this.getSymbolsContainer(buffer)) != null) {
                cachedSymbol.isDirty = true;
            }
        }

        @Override
        public void underlyingFileMoved(IFileBuffer buffer, IPath path) {
            IFile file;
            SymbolsContainer symbolsContainer = this.getSymbolsContainer(buffer);
            if (symbolsContainer != null && (file = LSPEclipseUtils.getFile(path)) != null) {
                symbolsContainer.setFile(file);
                TypeHierarchyView.this.cachedSymbols.put(file.getLocationURI(), new SymbolsContainer(file));
            }
        }

        private SymbolsContainer getSymbolsContainer(IFileBuffer buffer) {
            if (buffer != null) {
                return TypeHierarchyView.this.cachedSymbols.get(LSPEclipseUtils.toUri(buffer));
            }
            return null;
        }
    };
    private final IDocumentListener documentListener = new IDocumentListener(){

        public void documentChanged(DocumentEvent event) {
            IDocument document = event.getDocument();
            if (document != null) {
                TypeHierarchyView.this.refreshMemberViewer(LSPEclipseUtils.getFile(document), TypeHierarchyView.this.typeName, true);
            }
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
        }
    };

    public void setFocus() {
        this.pagebook.setFocus();
    }

    public void createPartControl(Composite parent) {
        this.pagebook = new PageBook(parent, 0);
        this.splitter = new SashForm((Composite)this.pagebook, 512);
        this.splitter.setLayoutData((Object)new GridData(1808));
        this.splitter.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
                TypeHierarchyView.this.splitter.setOrientation(TypeHierarchyView.this.getBestOrientation());
                TypeHierarchyView.this.splitter.layout();
            }
        });
        this.treeViewer = this.getFilteredTree((Composite)this.splitter).getViewer();
        this.treeViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new TypeHierarchyItemLabelProvider());
        this.treeViewer.setUseHashlookup(true);
        this.treeViewer.getControl().setEnabled(false);
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            /*
             * WARNING - void declaration
             */
            public void doubleClick(DoubleClickEvent event) {
                Object selection = ((IStructuredSelection)event.getSelection()).getFirstElement();
                Object object = selection;
                if (object instanceof TypeHierarchyItem) {
                    TypeHierarchyItem typeHierarchyItem = (TypeHierarchyItem)object;
                    TypeHierarchyItem cfr_ignored_0 = (TypeHierarchyItem)object;
                    try {
                        void item;
                        SymbolsContainer symbolsContainer = TypeHierarchyView.this.cachedSymbols.get(new URI(item.getUri()));
                        if (symbolsContainer != null) {
                            LSPEclipseUtils.open(symbolsContainer.file.getLocationURI().toASCIIString(), item.getSelectionRange());
                        }
                    }
                    catch (URISyntaxException e) {
                        LanguageServerPlugin.logError(e);
                    }
                }
            }
        });
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TypeHierarchyView.this.onHierarchySelectionChanged(event);
            }
        });
        this.memberViewForm = new ViewForm((Composite)this.splitter, 0);
        Control memberControl = this.createMemberControl(this.memberViewForm);
        memberControl.setEnabled(false);
        this.memberViewForm.setContent(memberControl);
        this.memberLabel = new CLabel((Composite)this.memberViewForm, 0);
        this.memberViewForm.setTopLeft((Control)this.memberLabel);
        this.infoText = new Label((Composite)this.pagebook, 16576);
        this.infoText.setText(Messages.TH_diplay_hint);
        this.pagebook.showPage((Control)this.infoText);
        FileBuffers.getTextFileBufferManager().addFileBufferListener(this.fileBufferListener);
    }

    public void dispose() {
        FileBuffers.getTextFileBufferManager().removeFileBufferListener(this.fileBufferListener);
        this.cachedSymbols.forEach((uri, container) -> container.dispose());
        super.dispose();
    }

    public void initialize(IDocument document, int offset) {
        this.treeViewer.setInput((Object)new HierarchyViewInput(document, offset));
        this.pagebook.showPage((Control)this.splitter);
    }

    /*
     * WARNING - void declaration
     */
    private void onHierarchySelectionChanged(SelectionChangedEvent event) {
        Object element;
        Object object;
        ISelection selection = event.getSelection();
        if (selection instanceof TreeSelection && !selection.isEmpty() && (object = (element = ((TreeSelection)selection).getFirstElement())) instanceof TypeHierarchyItem) {
            void item;
            TypeHierarchyItem typeHierarchyItem = (TypeHierarchyItem)object;
            TypeHierarchyItem cfr_ignored_0 = (TypeHierarchyItem)object;
            this.typeName = item.getName();
            SymbolsContainer symbolsContainer = null;
            try {
                symbolsContainer = this.cachedSymbols.get(new URI(item.getUri()));
            }
            catch (URISyntaxException e) {
                LanguageServerPlugin.logError(e);
            }
            IFile file = null;
            file = symbolsContainer != null ? symbolsContainer.file : LSPEclipseUtils.getFileHandle(item.getUri());
            this.refreshMemberViewer(file, this.typeName, false);
        }
    }

    private void refreshMemberViewer(IFile file, String typeName, boolean documentModified) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
            if (file != null && file.exists()) {
                this.refreshSymbols(this.getSymbolsContainer(file), documentModified);
                SymbolsModel.DocumentSymbolWithURI symbol = this.getDocumentSymbol(typeName, file);
                this.memberViewer.setInput((Object)symbol);
                this.memberLabel.setText(typeName);
                if (symbol != null) {
                    this.memberViewer.getControl().setEnabled(true);
                    this.memberViewer.setSelection((ISelection)new StructuredSelection((Object)symbol));
                    this.memberLabel.setImage(this.symbolsLabelProvider.getImage((Object)symbol));
                }
            } else {
                this.memberViewer.setInput(null);
                String location = "";
                if (file != null) {
                    location = file.getLocation().toOSString();
                }
                this.memberLabel.setText(Messages.bind((String)Messages.TH_cannot_find_file, (Object)location));
                this.memberLabel.setImage(null);
            }
        });
    }

    private Control createMemberControl(ViewForm parent) {
        this.memberViewer = new TableViewer((Composite)parent, 2816);
        this.memberViewer.setContentProvider((IContentProvider)new TypeMemberContentProvider());
        this.memberViewer.setLabelProvider((IBaseLabelProvider)this.symbolsLabelProvider);
        this.memberViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                SymbolsModel.DocumentSymbolWithURI container = (SymbolsModel.DocumentSymbolWithURI)((IStructuredSelection)event.getSelection()).getFirstElement();
                SymbolsContainer symbolsContainer = TypeHierarchyView.this.cachedSymbols.get(container.uri);
                if (symbolsContainer != null) {
                    LSPEclipseUtils.open(symbolsContainer.file.getLocationURI().toASCIIString(), container.symbol.getRange());
                }
            }
        });
        return this.memberViewer.getControl();
    }

    private int getBestOrientation() {
        Point size = this.splitter.getSize();
        if (size.x != 0 && size.y != 0 && 3 * size.x < 2 * size.y) {
            return 512;
        }
        return 256;
    }

    private FilteredTree getFilteredTree(Composite parent) {
        return new FilteredTree(parent, 2048, new PatternFilter(), true, false){

            protected Composite createFilterControls(Composite parent) {
                Composite composite = new Composite(parent, 0);
                GridLayout layout = new GridLayout(2, false);
                layout.horizontalSpacing = 0;
                layout.marginWidth = 0;
                layout.marginHeight = 0;
                composite.setLayout((Layout)layout);
                Composite filterControls = super.createFilterControls(composite);
                filterControls.setLayoutData((Object)new GridData(4, 0, true, false));
                this.createToolBar(composite);
                return composite;
            }

            private void createToolBar(Composite composite) {
                ToolBar toolbar = new ToolBar(composite, 540676);
                final ToolItem hierchyModeItem = new ToolItem(toolbar, 8);
                this.updateHierarchyModeItem(hierchyModeItem, TypeHierarchyView.this.contentProvider.showSuperTypes);
                hierchyModeItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        (this).TypeHierarchyView.this.contentProvider.showSuperTypes = !(this).TypeHierarchyView.this.contentProvider.showSuperTypes;
                        this.updateHierarchyModeItem(hierchyModeItem, (this).TypeHierarchyView.this.contentProvider.showSuperTypes);
                        this.getViewer().refresh();
                    }
                });
            }

            private void updateHierarchyModeItem(ToolItem hierchyModeItem, boolean showSuperTypes) {
                hierchyModeItem.setImage(LSPImages.getImage(showSuperTypes ? "IMG_SUBTYPE" : "IMG_SUPERTYPE"));
                hierchyModeItem.setToolTipText(showSuperTypes ? Messages.typeHierarchy_show_subtypes : Messages.typeHierarchy_show_supertypes);
            }
        };
    }

    private SymbolsContainer getSymbolsContainer(IFile file) {
        return this.cachedSymbols.computeIfAbsent(file.getLocationURI(), uri -> new SymbolsContainer(file));
    }

    private synchronized void refreshSymbols(SymbolsContainer symbolsContainer, boolean documentModified) {
        block7: {
            if (symbolsContainer == null || !symbolsContainer.isDirty && !documentModified) {
                return;
            }
            IDocument document = symbolsContainer.getDocument();
            try {
                if (document != null) {
                    CompletableFuture<Object> symbols;
                    block6: {
                        DocumentSymbolParams params = new DocumentSymbolParams(LSPEclipseUtils.toTextDocumentIdentifier(document));
                        CompletableFuture languageServer = ((LanguageServers.LanguageServerDocumentExecutor)LanguageServers.forDocument(document).withCapability(ServerCapabilities::getDocumentSymbolProvider)).computeFirst((w, ls) -> CompletableFuture.completedFuture(w));
                        try {
                            symbols = languageServer.get(500L, TimeUnit.MILLISECONDS).filter(Objects::nonNull).filter(LanguageServerWrapper::isActive).map(s -> s.execute(ls -> ls.getTextDocumentService().documentSymbol(params))).orElse(CompletableFuture.completedFuture(null));
                        }
                        catch (InterruptedException | ExecutionException | TimeoutException e) {
                            LanguageServerPlugin.logError(e);
                            symbols = CompletableFuture.completedFuture(null);
                            if (!(e instanceof InterruptedException)) break block6;
                            Thread.currentThread().interrupt();
                        }
                    }
                    ((CompletableFuture)symbols.thenAcceptAsync(response -> {
                        symbolsContainer.symbolsModel.update((List<Either<SymbolInformation, DocumentSymbol>>)response);
                        symbolsContainer.isDirty = false;
                        if (!document.equals(this.document)) {
                            if (this.document != null) {
                                this.document.removeDocumentListener(this.documentListener);
                            }
                            this.document = document;
                            this.document.addDocumentListener(this.documentListener);
                        }
                    })).join();
                    break block7;
                }
                symbolsContainer.symbolsModel.update(null);
            }
            catch (Exception e) {
                LanguageServerPlugin.logError(e);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private SymbolsModel.DocumentSymbolWithURI getDocumentSymbol(String typeName, IFile file) {
        SymbolsContainer symbolsContainer = this.cachedSymbols.get(file.getLocationURI());
        if (symbolsContainer != null) {
            Object[] elements;
            Object[] objectArray = elements = symbolsContainer.symbolsModel.getElements();
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                Object object = element;
                if (object instanceof SymbolsModel.DocumentSymbolWithURI) {
                    void symbolContainer;
                    SymbolsModel.DocumentSymbolWithURI cfr_ignored_0 = (SymbolsModel.DocumentSymbolWithURI)object;
                    SymbolsModel.DocumentSymbolWithURI cfr_ignored_1 = (SymbolsModel.DocumentSymbolWithURI)object;
                    if (this.isClass(symbolContainer.symbol.getKind()) && symbolContainer.symbol.getName().equals(typeName)) {
                        return new SymbolsModel.DocumentSymbolWithURI(symbolContainer.symbol, symbolContainer.uri);
                    }
                    DocumentSymbol grandchild = this.searchInChildren(symbolContainer.symbol.getChildren(), typeName);
                    if (grandchild != null) {
                        return new SymbolsModel.DocumentSymbolWithURI(grandchild, symbolContainer.uri);
                    }
                }
                ++n2;
            }
        }
        return null;
    }

    private boolean isClass(SymbolKind kind) {
        return SymbolKind.Class.equals((Object)kind) || SymbolKind.Struct.equals((Object)kind);
    }

    private DocumentSymbol searchInChildren(List<DocumentSymbol> children, String typeName) {
        if (children == null) {
            return null;
        }
        for (DocumentSymbol child : children) {
            if (child.getName().equals(typeName) && this.isClass(child.getKind())) {
                return child;
            }
            DocumentSymbol grandchild = this.searchInChildren(child.getChildren(), typeName);
            if (grandchild == null) continue;
            return grandchild;
        }
        return null;
    }

    class SymbolsContainer {
        private final SymbolsModel symbolsModel = new SymbolsModel();
        private volatile boolean isDirty = true;
        private boolean temporaryLoadedDocument = false;
        private IFile file;

        SymbolsContainer(IFile file) {
            this.setFile(file);
        }

        public IDocument getDocument() {
            IDocument document = LSPEclipseUtils.getExistingDocument((IResource)this.file);
            if (document == null) {
                document = LSPEclipseUtils.getDocument((IResource)this.file);
                this.temporaryLoadedDocument = document != null;
            }
            return document;
        }

        public void setFile(IFile file) {
            this.file = file;
            this.symbolsModel.setUri(file.getLocationURI());
        }

        public void dispose() {
            if (this.temporaryLoadedDocument) {
                try {
                    FileBuffers.getTextFileBufferManager().disconnect(this.file.getFullPath(), LocationKind.IFILE, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    LanguageServerPlugin.logError(e);
                }
            }
        }
    }
}

