/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test;

import java.io.File;
import java.io.IOException;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServersRegistry;
import org.eclipse.lsp4e.LaunchConfigurationStreamProvider;
import org.eclipse.lsp4e.tests.mock.MockLanguageServer;
import org.eclipse.ui.IStartup;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;

public class CreateAndRegisterContentTypeLSPLaunchConfigMapping
implements IStartup {
    public void earlyStartup() {
        IContentTypeManager contentTypeManager = Platform.getContentTypeManager();
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType externalType = launchManager.getLaunchConfigurationType("org.eclipse.ui.externaltools.ProgramLaunchConfigurationType");
        LanguageServersRegistry registry = LanguageServersRegistry.getInstance();
        try {
            String externalProcessLaunchName = "Mock external LS";
            ILaunchConfiguration mockServerLauch = null;
            ILaunchConfiguration[] iLaunchConfigurationArray = launchManager.getLaunchConfigurations(externalType);
            int n = iLaunchConfigurationArray.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunchConfiguration launch = iLaunchConfigurationArray[n2];
                if (launch.getName().equals(externalProcessLaunchName)) {
                    mockServerLauch = launch;
                }
                ++n2;
            }
            if (mockServerLauch == null) {
                ILaunchConfigurationWorkingCopy workingCopy = externalType.newInstance(null, externalProcessLaunchName);
                workingCopy.setAttribute("org.eclipse.debug.ui.ATTR_LAUNCH_IN_BACKGROUND", true);
                workingCopy.setAttribute("org.eclipse.ui.externaltools.ATTR_BUILDER_ENABLED", false);
                workingCopy.setAttribute("org.eclipse.ui.externaltools.ATTR_SHOW_CONSOLE", false);
                workingCopy.setAttribute("org.eclipse.ui.externaltools.ATTR_LAUNCH_CONFIGURATION_BUILD_SCOPE", "${none}");
                workingCopy.setAttribute("org.eclipse.debug.core.capture_output", true);
                String exe = "";
                if ("win32".equals(Platform.getOS())) {
                    exe = ".exe";
                }
                workingCopy.setAttribute("org.eclipse.ui.externaltools.ATTR_LOCATION", new File(System.getProperty("java.home"), "bin/java" + exe).getAbsolutePath());
                workingCopy.setAttribute("org.eclipse.ui.externaltools.ATTR_TOOL_ARGUMENTS", "-cp " + this.getClassPath(MockLanguageServer.class) + " " + MockLanguageServer.class.getName());
                mockServerLauch = workingCopy.doSave();
                registry.registerAssociation(contentTypeManager.getContentType("org.eclipse.lsp4e.test.content-type2"), LaunchConfigurationStreamProvider.findLaunchConfiguration((String)"org.eclipse.ui.externaltools.ProgramLaunchConfigurationType", (String)mockServerLauch.getName()), Collections.singleton("run"));
            }
        }
        catch (CoreException e) {
            LanguageServerPlugin.logError((Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private String getClassPath(Class<?> clazz) {
        ClassLoader loader = clazz.getClassLoader();
        ClassLoader classLoader = loader;
        if (classLoader instanceof URLClassLoader) {
            void urlClassLoader;
            URLClassLoader uRLClassLoader = (URLClassLoader)classLoader;
            URLClassLoader cfr_ignored_0 = (URLClassLoader)classLoader;
            return Arrays.asList(urlClassLoader.getURLs()).stream().map(url -> url.getFile()).collect(Collectors.joining(System.getProperty("path.separator")));
        }
        LinkedList<Bundle> toProcess = new LinkedList<Bundle>();
        HashSet<Bundle> processed = new HashSet<Bundle>();
        Bundle current = FrameworkUtil.getBundle(clazz);
        if (current != null) {
            toProcess.add(current);
        }
        while (!toProcess.isEmpty()) {
            current = (Bundle)toProcess.pop();
            if (processed.contains(current)) continue;
            for (BundleWire dep : ((BundleWiring)current.adapt(BundleWiring.class)).getRequiredWires(null)) {
                toProcess.add(dep.getProvider().getBundle());
            }
            processed.add(current);
        }
        return processed.stream().filter(bundle -> bundle.getBundleId() != 0L).map(bundle -> {
            try {
                return FileLocator.getBundleFile((Bundle)bundle);
            }
            catch (IOException e) {
                return null;
            }
        }).flatMap(location -> {
            if (location.isFile()) {
                return Arrays.stream(new String[]{location.getAbsolutePath()});
            }
            return Arrays.stream(new String[]{location.getAbsolutePath(), new File((File)location, "bin").getAbsolutePath()});
        }).collect(Collectors.joining(System.getProperty("path.separator")));
    }
}

