/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.highlight;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.lsp4e.test.AllCleanRule;
import org.eclipse.lsp4e.test.TestUtils;
import org.eclipse.lsp4e.tests.mock.MockLanguageServer;
import org.eclipse.lsp4j.DocumentHighlight;
import org.eclipse.lsp4j.DocumentHighlightKind;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public class HighlightTest {
    @Rule
    public AllCleanRule clear = new AllCleanRule();
    private IProject project;

    @Before
    public void setUp() throws CoreException {
        this.project = TestUtils.createProject("HighlightTest" + System.currentTimeMillis());
    }

    @Test
    public void testHighlight() throws CoreException {
        Annotation annotation;
        this.checkGenericEditorVersion();
        ArrayList<DocumentHighlight> highlights = new ArrayList<DocumentHighlight>();
        highlights.add(new DocumentHighlight(new Range(new Position(0, 2), new Position(0, 6)), DocumentHighlightKind.Read));
        highlights.add(new DocumentHighlight(new Range(new Position(0, 7), new Position(0, 12)), DocumentHighlightKind.Write));
        highlights.add(new DocumentHighlight(new Range(new Position(0, 13), new Position(0, 17)), DocumentHighlightKind.Text));
        MockLanguageServer.INSTANCE.setDocumentHighlights(highlights);
        IFile testFile = TestUtils.createUniqueTestFile(this.project, "  READ WRITE TEXT");
        ITextViewer viewer = TestUtils.openTextViewer(testFile);
        viewer.getTextWidget().setCaretOffset(1);
        if (!(viewer instanceof ISourceViewer)) {
            Assert.fail();
        }
        ISourceViewer sourceViewer = (ISourceViewer)viewer;
        HashMap<org.eclipse.jface.text.Position, Annotation> annotations = new HashMap<org.eclipse.jface.text.Position, Annotation>();
        TestUtils.waitForAndAssertCondition(3000, () -> sourceViewer.getAnnotationModel().getAnnotationIterator().hasNext());
        IAnnotationModel model = sourceViewer.getAnnotationModel();
        Iterator iterator = model.getAnnotationIterator();
        while (iterator.hasNext()) {
            annotation = (Annotation)iterator.next();
            annotations.put(model.getPosition(annotation), annotation);
        }
        annotation = (Annotation)annotations.get(new org.eclipse.jface.text.Position(2, 4));
        Assert.assertNotNull((Object)annotation);
        Assert.assertEquals((Object)"org.eclipse.lsp4e.read", (Object)annotation.getType());
        annotation = (Annotation)annotations.get(new org.eclipse.jface.text.Position(7, 5));
        Assert.assertNotNull((Object)annotation);
        Assert.assertEquals((Object)"org.eclipse.lsp4e.write", (Object)annotation.getType());
        annotation = (Annotation)annotations.get(new org.eclipse.jface.text.Position(13, 4));
        Assert.assertNotNull((Object)annotation);
        Assert.assertEquals((Object)"org.eclipse.lsp4e.text", (Object)annotation.getType());
        Assert.assertEquals((Object)false, (Object)iterator.hasNext());
    }

    @Test
    public void testCheckIfOtherAnnotationsRemains() throws CoreException {
        this.checkGenericEditorVersion();
        IFile testFile = TestUtils.createUniqueTestFile(this.project, "  READ WRITE TEXT");
        ITextViewer viewer = TestUtils.openTextViewer(testFile);
        List<DocumentHighlight> highlights = Collections.singletonList(new DocumentHighlight(new Range(new Position(0, 2), new Position(0, 6)), DocumentHighlightKind.Read));
        MockLanguageServer.INSTANCE.setDocumentHighlights(highlights);
        if (!(viewer instanceof ISourceViewer)) {
            Assert.fail();
        }
        ISourceViewer sourceViewer = (ISourceViewer)viewer;
        IAnnotationModel model = sourceViewer.getAnnotationModel();
        String fakeAnnotationType = "FAKE_TYPE";
        Annotation fakeAnnotation = new Annotation(fakeAnnotationType, false, null);
        org.eclipse.jface.text.Position fakeAnnotationPosition = new org.eclipse.jface.text.Position(0, 10);
        model.addAnnotation(fakeAnnotation, fakeAnnotationPosition);
        viewer.getTextWidget().setCaretOffset(1);
        TestUtils.waitForAndAssertCondition(3000, () -> {
            IAnnotationModel annotationModel = sourceViewer.getAnnotationModel();
            HashMap annotations = new HashMap();
            annotationModel.getAnnotationIterator().forEachRemaining(ann -> {
                Annotation annotation = annotations.put(model.getPosition(ann), ann);
            });
            if (annotations.size() != 2) {
                return false;
            }
            Annotation annotation = (Annotation)annotations.get(new org.eclipse.jface.text.Position(2, 4));
            if (annotation == null || !"org.eclipse.lsp4e.read".equals(annotation.getType())) {
                return false;
            }
            annotation = (Annotation)annotations.get(fakeAnnotationPosition);
            return annotation != null && fakeAnnotationType.equals(annotation.getType());
        });
    }

    private void checkGenericEditorVersion() {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.ui.genericeditor");
        Assume.assumeTrue((bundle.getVersion().compareTo(new Version(1, 1, 0)) >= 0 ? 1 : 0) != 0);
    }
}

