/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.edit;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.tests.util.DisplayHelper;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4e.test.AllCleanRule;
import org.eclipse.lsp4e.test.TestUtils;
import org.eclipse.lsp4e.tests.mock.MockLanguageServer;
import org.eclipse.lsp4j.LinkedEditingRanges;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class DocumentEditAndUndoTest {
    @Rule
    public AllCleanRule clear = new AllCleanRule();
    private IProject project;
    private Shell shell;

    @Before
    public void setUp() throws CoreException {
        this.project = TestUtils.createProject(String.valueOf(this.getClass().getName()) + System.currentTimeMillis());
        this.shell = new Shell();
    }

    @Test
    public void testDocumentEditAndUndo() throws Exception {
        MockLanguageServer.INSTANCE.setLinkedEditingRanges(new LinkedEditingRanges(List.of(new Range(new Position(0, 1), new Position(0, 2)), new Range(new Position(0, 5), new Position(0, 6))), "[:A-Z_a-z\\u00C0-\\u00D6\\u00D8-\\u00F6\\u00F8-\\u02ff\\u0370-\\u037d\\u037f-\\u1fff\\u200c\\u200d\\u2070-\\u218f\\u2c00-\\u2fef\\u3001-\\udfff\\uf900-\\ufdcf\\ufdf0-\\ufffd\\u10000-\\uEFFFF][:A-Z_a-z\\u00C0-\\u00D6\\u00D8-\\u00F6\\u00F8-\\u02ff\\u0370-\\u037d\\u037f-\\u1fff\\u200c\\u200d\\u2070-\\u218f\\u2c00-\\u2fef\\u3001-\\udfff\\uf900-\\ufdcf\\ufdf0-\\ufffd\\u10000-\\uEFFFF\\-\\.0-9\\u00b7\\u0300-\\u036f\\u203f-\\u2040]*"));
        IFile testFile = TestUtils.createUniqueTestFile(this.project, "<a></a>");
        IEditorPart editor = TestUtils.openEditor(testFile);
        ITextViewer viewer = LSPEclipseUtils.getTextViewer((IEditorPart)editor);
        LanguageServiceAccessor.getLanguageServers((IDocument)LSPEclipseUtils.getDocument((IResource)testFile), capabilites -> Boolean.TRUE);
        System.out.println("Document initial:\t[" + viewer.getDocument().get() + "]");
        viewer.getTextWidget().setCaretOffset(2);
        ((TextViewer)viewer).setSelection((ISelection)new TextSelection(viewer.getDocument(), 2, 0), true);
        System.out.println("Document viewer.setSelection(2, 2)");
        Display display = this.shell.getDisplay();
        StyledText control = viewer.getTextWidget();
        DisplayHelper.sleep((Display)display, (long)2000L);
        display.asyncExec(new Runnable((Control)control, display){
            private final /* synthetic */ Control val$control;
            private final /* synthetic */ Display val$display;
            {
                this.val$control = control;
                this.val$display = display;
            }

            @Override
            public void run() {
                this.type(this.val$control, 'b');
                this.type(this.val$control, 'c');
            }

            private void type(Control control, char c) {
                control.forceFocus();
                Event keyEvent = new Event();
                keyEvent.widget = control;
                keyEvent.type = 1;
                keyEvent.character = c;
                keyEvent.keyCode = c;
                this.val$display.post(keyEvent);
                keyEvent.type = 2;
                this.val$display.post(keyEvent);
            }
        });
        TestUtils.waitForCondition(3000, () -> viewer.getDocument().get().equals("<abc></abc>"));
        Assert.assertEquals((String)"Document isn't correctly changed", (Object)"<abc></abc>", (Object)viewer.getDocument().get());
        ITextOperationTarget fOperationTarget = (ITextOperationTarget)editor.getAdapter(ITextOperationTarget.class);
        BusyIndicator.showWhile((Display)viewer.getTextWidget().getDisplay(), () -> fOperationTarget.doOperation(1));
        TestUtils.waitForCondition(3000, () -> viewer.getDocument().get().equals("<a></a>"));
        Assert.assertEquals((String)"Document isn't correctly restored", (Object)"<a></a>", (Object)viewer.getDocument().get());
    }
}

