/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.lsp4e.ContentTypeToLanguageServerDefinition;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4e.test.AllCleanRule;
import org.eclipse.lsp4e.test.LSDisplayHelper;
import org.eclipse.lsp4e.test.TestUtils;
import org.eclipse.lsp4e.tests.mock.MockLanguageServer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class RunningLanguageServerTest {
    private IProject project;
    @Rule
    public AllCleanRule clear = new AllCleanRule();

    @Before
    public void setUp() throws CoreException {
        this.project = TestUtils.createProject("StartStopServerTest" + System.currentTimeMillis());
    }

    @Test
    public void testOpenCloseLanguageServer() throws Exception {
        IFile testFile = TestUtils.createUniqueTestFile(this.project, "");
        Display display = Display.getCurrent();
        int i = 0;
        while (i < 10) {
            IEditorPart editor = TestUtils.openEditor(testFile);
            LanguageServiceAccessor.getInitializedLanguageServers((IFile)testFile, capabilities -> Boolean.TRUE).iterator().next();
            Assert.assertTrue((String)("language server is started for iteration #" + i), (boolean)new LSDisplayHelper(() -> MockLanguageServer.INSTANCE.isRunning()).waitForCondition(display, 5000L));
            ((AbstractTextEditor)editor).close(false);
            Assert.assertTrue((String)("language server is closed for iteration #" + i), (boolean)new LSDisplayHelper(() -> !MockLanguageServer.INSTANCE.isRunning()).waitForCondition(display, 5000L));
            ++i;
        }
    }

    @Test
    public void testDisabledLanguageServer() throws Exception {
        IFile testFile = TestUtils.createUniqueTestFile(this.project, "lspt-disabled", "");
        Display display = Display.getCurrent();
        ContentTypeToLanguageServerDefinition lsDefinition = TestUtils.getDisabledLS();
        lsDefinition.setUserEnabled(false);
        LanguageServiceAccessor.disableLanguageServerContentType((ContentTypeToLanguageServerDefinition)lsDefinition);
        TestUtils.openEditor(testFile);
        List initializedLanguageServers = LanguageServiceAccessor.getInitializedLanguageServers((IFile)testFile, capabilities -> Boolean.TRUE);
        Assert.assertNotNull((Object)initializedLanguageServers);
        Assert.assertEquals((String)"language server should not be started because it is disabled", (long)0L, (long)initializedLanguageServers.size());
        lsDefinition.setUserEnabled(true);
        LanguageServiceAccessor.enableLanguageServerContentType((ContentTypeToLanguageServerDefinition)lsDefinition, (IEditorReference[])TestUtils.getEditors());
        Assert.assertTrue((String)"language server should be started", (boolean)new LSDisplayHelper(() -> MockLanguageServer.INSTANCE.isRunning()).waitForCondition(display, 5000L));
    }

    @Test
    public void testBug535887DisabledWithMultipleOpenFiles() throws CoreException, InvocationTargetException {
        ContentTypeToLanguageServerDefinition lsDefinition = TestUtils.getDisabledLS();
        lsDefinition.setUserEnabled(true);
        LanguageServiceAccessor.enableLanguageServerContentType((ContentTypeToLanguageServerDefinition)lsDefinition, (IEditorReference[])TestUtils.getEditors());
        IFile testFile1 = TestUtils.createUniqueTestFile(this.project, "lspt-disabled", "");
        IFile testFile2 = TestUtils.createUniqueTestFile(this.project, "lspt-disabled", "");
        TestUtils.openEditor(testFile1);
        TestUtils.openEditor(testFile2);
        lsDefinition.setUserEnabled(false);
        LanguageServiceAccessor.disableLanguageServerContentType((ContentTypeToLanguageServerDefinition)lsDefinition);
    }

    @Test
    public void testDelayedStopDoesntCauseFreeze() throws Exception {
        IFile testFile = TestUtils.createUniqueTestFile(this.project, "");
        IEditorPart editor = TestUtils.openEditor(testFile);
        IWorkbenchPage page = editor.getSite().getPage();
        MockLanguageServer.INSTANCE.setTimeToProceedQueries(10000L);
        long before = System.currentTimeMillis();
        page.closeEditor(editor, false);
        Assert.assertTrue((System.currentTimeMillis() - before < 1000L ? 1 : 0) != 0);
    }
}

