/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.completion;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.operations.completion.CompletionProposalTools;
import org.eclipse.lsp4e.operations.completion.LSIncompleteCompletionProposal;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.InsertReplaceEdit;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.services.LanguageServer;

public class LSCompletionProposal
extends LSIncompleteCompletionProposal
implements ICompletionProposalExtension,
ICompletionProposalExtension2 {
    public LSCompletionProposal(IDocument document, int offset, @NonNull CompletionItem item, LanguageServer languageServer) {
        super(document, offset, item, languageServer);
    }

    public boolean isValidFor(IDocument document, int offset) {
        return this.validate(document, offset, null);
    }

    public void selected(ITextViewer viewer, boolean smartToggle) {
        this.viewer = viewer;
    }

    public void unselected(ITextViewer viewer) {
    }

    public boolean validate(IDocument document, int offset, DocumentEvent event) {
        if (this.item.getLabel() == null || this.item.getLabel().isEmpty()) {
            return false;
        }
        if (offset < this.bestOffset) {
            return false;
        }
        try {
            String documentFilter = this.getDocumentFilter(offset);
            if (!documentFilter.isEmpty()) {
                return CompletionProposalTools.isSubstringFoundOrderedInString(documentFilter, this.getFilterString());
            }
            if (this.item.getTextEdit() != null) {
                if (this.item.getTextEdit().isLeft()) {
                    return offset == LSPEclipseUtils.toOffset(((TextEdit)this.item.getTextEdit().getLeft()).getRange().getStart(), document);
                }
                return offset == LSPEclipseUtils.toOffset(((InsertReplaceEdit)this.item.getTextEdit().getRight()).getInsert().getStart(), document);
            }
        }
        catch (BadLocationException e) {
            LanguageServerPlugin.logError(e);
        }
        return true;
    }

    public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
        this.viewer = viewer;
        this.apply(viewer.getDocument(), trigger, stateMask, offset);
    }

    public void apply(IDocument document, char trigger, int offset) {
        this.apply(document, trigger, 0, offset);
    }

    @Override
    public void apply(IDocument document) {
        this.apply(document, '\u0000', 0, this.bestOffset);
    }

    public char[] getTriggerCharacters() {
        return null;
    }

    public int getContextInformationPosition() {
        return 131072;
    }
}

