/*
 * Decompiled with CFR 0.152.
 */
package distributions;

import distributions.CalculationMode;
import distributions.Distribution;
import org.apache.commons.math3.random.RandomGenerator;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;

public class DistributionsAdapter
extends AdapterImpl {
    private CalculationMode calculationMode;
    private RandomGenerator randomGenerator;
    private final ResourceSet resourceSet;

    public DistributionsAdapter(ResourceSet resourceSet) {
        this.resourceSet = resourceSet;
    }

    public CalculationMode getCalculationMode() {
        return this.calculationMode;
    }

    public void setCalculationMode(CalculationMode mode) {
        if (mode != this.calculationMode) {
            if (mode != null) {
                this.resetDistributions();
            }
            this.calculationMode = mode;
        }
    }

    private void resetDistributions() {
        DistributionsAdapter.resetDistributions(this.resourceSet);
    }

    public RandomGenerator getRandomGenerator() {
        return this.randomGenerator;
    }

    public void setRandomGenerator(RandomGenerator randomGenerator) {
        if (randomGenerator != this.randomGenerator) {
            this.resetDistributions();
            this.randomGenerator = randomGenerator;
        }
    }

    public static DistributionsAdapter getAdapter(EObject context) {
        if (context == null || context.eResource() == null || context.eResource().getResourceSet() == null) {
            return null;
        }
        ResourceSet resourceSet = context.eResource().getResourceSet();
        return DistributionsAdapter.getAdapter(resourceSet);
    }

    public static DistributionsAdapter getAdapter(ResourceSet resourceSet) {
        Object adapter2;
        if (resourceSet == null) {
            return null;
        }
        for (Object adapter2 : resourceSet.eAdapters()) {
            if (!(adapter2 instanceof DistributionsAdapter)) continue;
            return (DistributionsAdapter)((Object)adapter2);
        }
        adapter2 = new DistributionsAdapter(resourceSet);
        resourceSet.eAdapters().add(adapter2);
        return adapter2;
    }

    public static void resetDistributions(ResourceSet root) {
        TreeIterator iterator = root.getAllContents();
        while (iterator.hasNext()) {
            Notifier instance = (Notifier)iterator.next();
            if (!(instance instanceof Distribution)) continue;
            Distribution dist = (Distribution)instance;
            dist.setModeDistributionInstance(null);
        }
    }
}

