# coding: utf-8

"""
    LSAT API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.5.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from lsat_client.models.lsat_base import LsatBase
from pydantic import ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from lsat_client.models.action_base import ActionBase
from lsat_client.models.scheduling_type import SchedulingType
from typing import Optional, Set
from typing_extensions import Self

class Move(ActionBase):
    """
    Move
    """ # noqa: E501
    name: Optional[StrictStr] = None
    scheduling_type: Optional[SchedulingType] = Field(default=None, alias="schedulingType")
    profile: Optional[StrictStr] = None
    source_position: Optional[Dict[str, StrictStr]] = Field(default=None, alias="sourcePosition")
    target_position: Optional[Dict[str, StrictStr]] = Field(default=None, alias="targetPosition")
    predecessor_move: object = Field(default=None, repr=False)
    predecessor_move_id: Optional[StrictStr] = Field(default=None, alias="predecessorMoveId")
    successor_move: object = Field(default=None, repr=False)
    successor_move_id: Optional[StrictStr] = Field(default=None, alias="successorMoveId")
    distance: Optional[StrictStr] = None
    stop_at_target: Optional[StrictBool] = Field(default=None, alias="stopAtTarget")
    position_move: Optional[StrictBool] = Field(default=None, alias="positionMove")
    resource: object = Field(default=None, repr=False)
    resource_id: Optional[StrictStr] = Field(default=None, alias="resourceId")
    peripheral: object = Field(default=None, repr=False)
    peripheral_id: Optional[StrictStr] = Field(default=None, alias="peripheralId")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["actionType", "tracePointStart", "tracePointEnd", "name", "schedulingType", "profile", "sourcePosition", "targetPosition", "predecessorMoveId", "successorMoveId", "distance", "stopAtTarget", "positionMove", "resourceId", "peripheralId"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Move from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Move from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "actionType": obj.get("actionType"),
            "tracePointStart": obj.get("tracePointStart"),
            "tracePointEnd": obj.get("tracePointEnd"),
            "name": obj.get("name"),
            "schedulingType": obj.get("schedulingType"),
            "profile": obj.get("profile"),
            "sourcePosition": obj.get("sourcePosition"),
            "targetPosition": obj.get("targetPosition"),
            "predecessorMoveId": obj.get("predecessorMoveId"),
            "successorMoveId": obj.get("successorMoveId"),
            "distance": obj.get("distance"),
            "stopAtTarget": obj.get("stopAtTarget"),
            "positionMove": obj.get("positionMove"),
            "resourceId": obj.get("resourceId"),
            "peripheralId": obj.get("peripheralId")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


