/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.analysis.stl;

import org.eclipse.trace4cps.analysis.stl.StlFormula;
import org.eclipse.trace4cps.analysis.stl.impl.StlBinBool;
import org.eclipse.trace4cps.analysis.stl.impl.StlEq;
import org.eclipse.trace4cps.analysis.stl.impl.StlGeq;
import org.eclipse.trace4cps.analysis.stl.impl.StlLeq;
import org.eclipse.trace4cps.analysis.stl.impl.StlNeg;
import org.eclipse.trace4cps.analysis.stl.impl.StlTrue;
import org.eclipse.trace4cps.analysis.stl.impl.StlUntil;
import org.eclipse.trace4cps.core.IPsop;

public class StlBuilder {
    private static final StlFormula T = new StlTrue();

    private StlBuilder() {
    }

    public static StlFormula EQ(IPsop p, double c) {
        return new StlEq(p, c);
    }

    public static StlFormula GEQ(IPsop p, double c) {
        return new StlGeq(p, c);
    }

    public static StlFormula LEQ(IPsop p, double c) {
        return new StlLeq(p, c);
    }

    public static StlFormula NOT(StlFormula f) {
        if (f instanceof StlNeg) {
            return ((StlNeg)f).getFormula();
        }
        return new StlNeg(f);
    }

    public static StlFormula AND(StlFormula f1, StlFormula f2) {
        return new StlBinBool(f1, StlBinBool.BinOp.AND, f2);
    }

    public static StlFormula OR(StlFormula f1, StlFormula f2) {
        return new StlBinBool(f1, StlBinBool.BinOp.OR, f2);
    }

    public static StlFormula IMPLY(StlFormula f1, StlFormula f2) {
        return new StlBinBool(f1, StlBinBool.BinOp.IMPLY, f2);
    }

    public static StlFormula TRUE() {
        return T;
    }

    public static StlFormula F(StlFormula f) {
        return new StlUntil(T, f, 0.0, Double.POSITIVE_INFINITY);
    }

    public static StlFormula F(StlFormula f, double a, double b) {
        return new StlUntil(T, f, a, b);
    }

    public static StlFormula G(StlFormula f) {
        return StlBuilder.NOT(StlBuilder.F(StlBuilder.NOT(f), 0.0, Double.POSITIVE_INFINITY));
    }

    public static StlFormula G(StlFormula f, double a, double b) {
        return StlBuilder.NOT(StlBuilder.F(StlBuilder.NOT(f), a, b));
    }

    public static StlFormula U(StlFormula f1, StlFormula f2) {
        return new StlUntil(f1, f2, 0.0, Double.POSITIVE_INFINITY);
    }

    public static StlFormula U(StlFormula f1, StlFormula f2, double a, double b) {
        return new StlUntil(f1, f2, a, b);
    }
}

