/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.filetransfer.util;

import java.net.URI;
import java.net.URL;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.ecf.core.util.Proxy;
import org.eclipse.ecf.core.util.ProxyAddress;
import org.eclipse.ecf.internal.provider.filetransfer.Activator;

public class ProxySetupHelper {
    public static Proxy getProxy(String url) {
        Proxy proxy = null;
        try {
            IProxyService proxyService = Activator.getDefault().getProxyService();
            if (proxyService != null && proxyService.isProxiesEnabled()) {
                URI uri = new URI(url);
                IProxyData[] proxies = proxyService.select(uri);
                IProxyData selectedProxy = ProxySetupHelper.selectProxyFromProxies(uri.getScheme(), proxies);
                if (selectedProxy != null) {
                    proxy = new Proxy(selectedProxy.getType().equalsIgnoreCase("SOCKS") ? Proxy.Type.SOCKS : Proxy.Type.HTTP, new ProxyAddress(selectedProxy.getHost(), selectedProxy.getPort()), selectedProxy.getUserId(), selectedProxy.getPassword());
                }
            }
        }
        catch (Exception e) {
            Activator.logNoProxyWarning(e);
        }
        catch (NoClassDefFoundError e) {
            Activator.logNoProxyWarning(e);
        }
        return proxy;
    }

    public static Proxy getSocksProxy(URL url) {
        String host = url.getHost();
        int port = url.getPort();
        String strURL = "SOCKS://" + host;
        if (port != -1) {
            strURL = strURL + ":" + port;
        }
        return ProxySetupHelper.getProxy(strURL);
    }

    public static IProxyData selectProxyFromProxies(String protocol, IProxyData[] proxies) {
        block7: {
            block6: {
                if (proxies == null || proxies.length == 0) {
                    return null;
                }
                if (proxies.length == 1) {
                    return proxies[0];
                }
                if (!protocol.equalsIgnoreCase("http")) break block6;
                IProxyData[] iProxyDataArray = proxies;
                int n = proxies.length;
                int n2 = 0;
                while (n2 < n) {
                    IProxyData proxie = iProxyDataArray[n2];
                    if (proxie.getType().equals("HTTP")) {
                        return proxie;
                    }
                    ++n2;
                }
                break block7;
            }
            if (!protocol.equalsIgnoreCase("https")) break block7;
            IProxyData[] iProxyDataArray = proxies;
            int n = proxies.length;
            int n3 = 0;
            while (n3 < n) {
                IProxyData proxie = iProxyDataArray[n3];
                if (proxie.getType().equals("HTTPS")) {
                    return proxie;
                }
                ++n3;
            }
        }
        return proxies[0];
    }
}

