/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import java.util.HashMap;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.gdip.Gdip;

public class Transform
extends Resource {
    private int initialZoom;
    private HashMap<Integer, Long> zoomLevelToHandle = new HashMap();

    public Transform(Device device) {
        this(device, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
    }

    public Transform(Device device, float[] elements) {
        this(device, Transform.checkTransform(elements)[0], elements[1], elements[2], elements[3], elements[4], elements[5]);
    }

    public Transform(Device device, float m11, float m12, float m21, float m22, float dx, float dy) {
        super(device);
        this.initialZoom = DPIUtil.getDeviceZoom();
        this.device.checkGDIP();
        long handle = Gdip.Matrix_new(m11, m12, m21, m22, DPIUtil.scaleUp((Drawable)this.device, dx, this.initialZoom), DPIUtil.scaleUp((Drawable)this.device, dy, this.initialZoom));
        if (handle == 0L) {
            SWT.error(2);
        }
        this.zoomLevelToHandle.put(this.initialZoom, handle);
        this.init();
    }

    static float[] checkTransform(float[] elements) {
        if (elements == null) {
            SWT.error(4);
        }
        if (elements.length < 6) {
            SWT.error(5);
        }
        return elements;
    }

    @Override
    void destroy() {
        this.zoomLevelToHandle.values().forEach(Gdip::Matrix_delete);
        this.zoomLevelToHandle.clear();
    }

    public void getElements(float[] elements) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (elements == null) {
            SWT.error(4);
        }
        if (elements.length < 6) {
            SWT.error(5);
        }
        Gdip.Matrix_GetElements(this.getHandle(this.initialZoom), elements);
        Device drawable = this.getDevice();
        elements[4] = DPIUtil.scaleDown((Drawable)drawable, elements[4], this.initialZoom);
        elements[5] = DPIUtil.scaleDown((Drawable)drawable, elements[5], this.initialZoom);
    }

    public void identity() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        Gdip.Matrix_SetElements(this.getHandle(this.initialZoom), 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
    }

    public void invert() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (Gdip.Matrix_Invert(this.getHandle(this.initialZoom)) != 0) {
            SWT.error(10);
        }
    }

    @Override
    public boolean isDisposed() {
        return this.zoomLevelToHandle.isEmpty();
    }

    public boolean isIdentity() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return Gdip.Matrix_IsIdentity(this.getHandle(this.initialZoom));
    }

    public void multiply(Transform matrix) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (matrix == null) {
            SWT.error(4);
        }
        if (matrix.isDisposed()) {
            SWT.error(5);
        }
        Gdip.Matrix_Multiply(this.getHandle(this.initialZoom), matrix.getHandle(this.initialZoom), 0);
    }

    public void rotate(float angle) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        Gdip.Matrix_Rotate(this.getHandle(this.initialZoom), angle, 0);
    }

    public void scale(float scaleX, float scaleY) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        Gdip.Matrix_Scale(this.getHandle(this.initialZoom), scaleX, scaleY, 0);
    }

    public void setElements(float m11, float m12, float m21, float m22, float dx, float dy) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        Device drawable = this.getDevice();
        Gdip.Matrix_SetElements(this.getHandle(this.initialZoom), m11, m12, m21, m22, DPIUtil.scaleUp((Drawable)drawable, dx, this.initialZoom), DPIUtil.scaleUp((Drawable)drawable, dy, this.initialZoom));
    }

    public void shear(float shearX, float shearY) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        Gdip.Matrix_Shear(this.getHandle(this.initialZoom), shearX, shearY, 0);
    }

    public void transform(float[] pointArray) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (pointArray == null) {
            SWT.error(4);
        }
        int length = pointArray.length;
        Device drawable = this.getDevice();
        int i = 0;
        while (i < length) {
            pointArray[i] = DPIUtil.scaleUp((Drawable)drawable, pointArray[i], this.initialZoom);
            ++i;
        }
        Gdip.Matrix_TransformPoints(this.getHandle(this.initialZoom), pointArray, length / 2);
        i = 0;
        while (i < length) {
            pointArray[i] = DPIUtil.scaleDown((Drawable)drawable, pointArray[i], this.initialZoom);
            ++i;
        }
    }

    public void translate(float offsetX, float offsetY) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        Device drawable = this.getDevice();
        Gdip.Matrix_Translate(this.getHandle(this.initialZoom), DPIUtil.scaleUp((Drawable)drawable, offsetX, this.initialZoom), DPIUtil.scaleUp((Drawable)drawable, offsetY, this.initialZoom), 0);
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Transform {*DISPOSED*}";
        }
        float[] elements = new float[6];
        this.getElements(elements);
        return "Transform {" + elements[0] + "," + elements[1] + "," + elements[2] + "," + elements[3] + "," + elements[4] + "," + elements[5] + "}";
    }

    long getHandle(int zoomLevel) {
        if (this.zoomLevelToHandle.get(zoomLevel) == null) {
            float[] elements = new float[6];
            this.getElements(elements);
            elements[4] = DPIUtil.scaleUp((Drawable)this.device, DPIUtil.scaleDown((Drawable)this.device, elements[4], this.initialZoom), zoomLevel);
            elements[5] = DPIUtil.scaleUp((Drawable)this.device, DPIUtil.scaleDown((Drawable)this.device, elements[5], this.initialZoom), zoomLevel);
            this.zoomLevelToHandle.put(zoomLevel, Gdip.Matrix_new(elements[0], elements[1], elements[2], elements[3], elements[4], elements[5]));
        }
        return this.zoomLevelToHandle.get(zoomLevel);
    }
}

