/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile;

import java.awt.Graphics2D;
import java.io.IOException;
import org.apache.batik.transcoder.TranscoderException;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.DeviceContext;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.GdiFont;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.IEmf2SvgConverter;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.IWmf2SvgConverter;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.Record;

public class CreateFontIndirect
implements IEmf2SvgConverter,
IWmf2SvgConverter {
    private static final int EMF_ID_OFFSET = 0;
    private static final int EMF_HEIGHT_OFFSET = 4;
    private static final int EMF_ESCAPEMENT_OFFSET = 12;
    private static final int EMF_WEIGHT_OFFSET = 20;
    private static final int EMF_ITALIC_OFFSET = 24;
    private static final int EMF_UNDERLINE_OFFSET = 25;
    private static final int EMF_STRIKEOUT_OFFSET = 26;
    private static final int EMF_FACE_OFFSET = 32;
    private static final int EMF_LF_FACESIZE = 32;
    private static final int WMF_HEIGHT_OFFSET = 0;
    private static final int WMF_WEIGHT_OFFSET = 8;
    private static final int WMF_ITALIC_OFFSET = 10;
    private static final int WMF_UNDERLINE_OFFSET = 11;
    private static final int WMF_STRIKEOUT_OFFSET = 12;
    private static final int WMF_FACE_OFFSET = 18;
    private static final int WMF_LF_FACESIZE = 32;
    private int m_id = -1;
    private int m_height = 10;
    private int m_escapement = 0;
    private boolean m_bItalic = false;
    private boolean m_bUnderlined = false;
    private boolean m_bStrikeout = false;
    private int m_weight = 400;
    private String m_faceName = "SanSerif";

    @Override
    public void readWMFRecord(Record rec) throws IOException {
        this.m_height = Math.abs(rec.getShortAt(0));
        this.m_bItalic = rec.getByteAt(10) != 0;
        this.m_bUnderlined = rec.getByteAt(11) != 0;
        this.m_bStrikeout = rec.getByteAt(12) != 0;
        this.m_weight = rec.getShortAt(8);
        this.m_escapement = rec.getShortAt(12);
        byte[] facename = rec.getBytesAt(18, 32);
        int index = 0;
        index = 0;
        while (index < facename.length) {
            if (facename[index] == 0) break;
            ++index;
        }
        this.m_faceName = new String(facename, 0, index);
    }

    @Override
    public void readEMFRecord(Record rec) throws IOException {
        this.m_id = (int)rec.getDWORDAt(0);
        this.m_height = Math.abs(rec.getIntAt(4));
        this.m_bItalic = rec.getByteAt(24) != 0;
        this.m_bUnderlined = rec.getByteAt(25) != 0;
        this.m_bStrikeout = rec.getByteAt(26) != 0;
        this.m_weight = rec.getIntAt(20);
        this.m_escapement = rec.getIntAt(12);
        char[] facename = rec.getCharsAt(32, 32);
        int index = 0;
        index = 0;
        while (index < facename.length) {
            if (facename[index] == '\u0000') break;
            ++index;
        }
        this.m_faceName = new String(facename, 0, index);
    }

    @Override
    public void render(Graphics2D g, DeviceContext context) throws TranscoderException {
        if (this.m_id == -1) {
            this.m_id = context.getNextObjectId();
        }
        int height = context.scaleY(this.m_height);
        context.addGDI(this.m_id, new GdiFont(height, this.m_bItalic, this.m_bUnderlined, this.m_bStrikeout, this.m_weight > 400, this.m_faceName, this.m_escapement));
    }
}

