/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eef.ide.ui.internal.widgets;

import java.util.Optional;
import org.eclipse.eef.EEFWidgetAction;
import org.eclipse.eef.common.ui.api.EEFWidgetFactory;
import org.eclipse.eef.core.api.utils.EvalFactory;
import org.eclipse.eef.ide.ui.internal.EEFImageUtils;
import org.eclipse.sirius.common.interpreter.api.IInterpreter;
import org.eclipse.sirius.common.interpreter.api.IVariableManager;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ActionButton {
    private static final int MINIMUM_BUTTON_WIDTH = 80;
    private Button button;
    private SelectionListener selectionListener;
    private EEFWidgetAction action;

    public ActionButton(EEFWidgetAction action, Composite parent, EEFWidgetFactory widgetFactory, IInterpreter interpreter, IVariableManager variableManager) {
        this.action = action;
        this.button = widgetFactory.createButton(parent, "", 0);
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.minimumWidth = 80;
        this.button.setLayoutData((Object)gridData);
        String imageExpression = Optional.ofNullable(action.getImageExpression()).orElse("");
        Object buttonImage = EvalFactory.of((IInterpreter)interpreter, (IVariableManager)variableManager).logIfInvalidType(Object.class).evaluate(imageExpression);
        Optional.ofNullable(buttonImage).filter(String.class::isInstance).map(String.class::cast).flatMap(EEFImageUtils::getImage).ifPresent(arg_0 -> ((Button)this.button).setImage(arg_0));
        boolean labelDefaultValue = true;
        if (!imageExpression.isEmpty()) {
            labelDefaultValue = false;
        }
        String labelExpression = action.getLabelExpression();
        EvalFactory.Eval eval = EvalFactory.of((IInterpreter)interpreter, (IVariableManager)variableManager).logIfInvalidType(String.class);
        if (labelDefaultValue) {
            eval = eval.defaultValue((Object)"...");
        }
        String buttonLabel = (String)eval.evaluate(labelExpression);
        this.button.setText(Optional.ofNullable(buttonLabel).orElse(""));
    }

    public void setEnabled(boolean isEnabled) {
        this.button.setEnabled(isEnabled);
    }

    public void addSelectionListener(SelectionListener listener) {
        if (!this.button.isDisposed()) {
            this.selectionListener = listener;
            this.button.addSelectionListener(this.selectionListener);
        }
    }

    public void removeSelectionListener() {
        if (!this.button.isDisposed()) {
            this.button.removeSelectionListener(this.selectionListener);
        }
    }

    public EEFWidgetAction getAction() {
        return this.action;
    }

    public Control getButton() {
        return this.button;
    }
}

