/**
 */
package distributions.util;

import distributions.*;

import expressions.AbstractElement;
import expressions.Expression;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;

import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc -->
 * The <b>Adapter Factory</b> for the model.
 * It provides an adapter <code>createXXX</code> method for each class of the model.
 * <!-- end-user-doc -->
 * @see distributions.DistributionsPackage
 * @generated
 */
public class DistributionsAdapterFactory extends AdapterFactoryImpl
{
    /**
     * The cached model package.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected static DistributionsPackage modelPackage;

    /**
     * Creates an instance of the adapter factory.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public DistributionsAdapterFactory()
    {
        if (modelPackage == null)
        {
            modelPackage = DistributionsPackage.eINSTANCE;
        }
    }

    /**
     * Returns whether this factory is applicable for the type of the object.
     * <!-- begin-user-doc -->
     * This implementation returns <code>true</code> if the object is either the model's package or is an instance object of the model.
     * <!-- end-user-doc -->
     * @return whether this factory is applicable for the type of the object.
     * @generated
     */
    @Override
    public boolean isFactoryForType(Object object)
    {
        if (object == modelPackage)
        {
            return true;
        }
        if (object instanceof EObject)
        {
            return ((EObject)object).eClass().getEPackage() == modelPackage;
        }
        return false;
    }

    /**
     * The switch that delegates to the <code>createXXX</code> methods.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected DistributionsSwitch<Adapter> modelSwitch =
        new DistributionsSwitch<Adapter>()
        {
            @Override
            public Adapter caseDistribution(Distribution object)
            {
                return createDistributionAdapter();
            }
            @Override
            public Adapter caseTriangularDistribution(TriangularDistribution object)
            {
                return createTriangularDistributionAdapter();
            }
            @Override
            public Adapter casePertDistribution(PertDistribution object)
            {
                return createPertDistributionAdapter();
            }
            @Override
            public Adapter caseNormalDistribution(NormalDistribution object)
            {
                return createNormalDistributionAdapter();
            }
            @Override
            public Adapter caseEnumeratedDistribution(EnumeratedDistribution object)
            {
                return createEnumeratedDistributionAdapter();
            }
            @Override
            public Adapter caseGammaDistribution(GammaDistribution object)
            {
                return createGammaDistributionAdapter();
            }
            @Override
            public Adapter casePoissonDistribution(PoissonDistribution object)
            {
                return createPoissonDistributionAdapter();
            }
            @Override
            public Adapter caseLogNormalDistribution(LogNormalDistribution object)
            {
                return createLogNormalDistributionAdapter();
            }
            @Override
            public Adapter caseAbstractElement(AbstractElement object)
            {
                return createAbstractElementAdapter();
            }
            @Override
            public Adapter caseExpression(Expression object)
            {
                return createExpressionAdapter();
            }
            @Override
            public Adapter defaultCase(EObject object)
            {
                return createEObjectAdapter();
            }
        };

    /**
     * Creates an adapter for the <code>target</code>.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @param target the object to adapt.
     * @return the adapter for the <code>target</code>.
     * @generated
     */
    @Override
    public Adapter createAdapter(Notifier target)
    {
        return modelSwitch.doSwitch((EObject)target);
    }


    /**
     * Creates a new adapter for an object of class '{@link distributions.Distribution <em>Distribution</em>}'.
     * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @see distributions.Distribution
     * @generated
     */
    public Adapter createDistributionAdapter()
    {
        return null;
    }

    /**
     * Creates a new adapter for an object of class '{@link distributions.TriangularDistribution <em>Triangular Distribution</em>}'.
     * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @see distributions.TriangularDistribution
     * @generated
     */
    public Adapter createTriangularDistributionAdapter()
    {
        return null;
    }

    /**
     * Creates a new adapter for an object of class '{@link distributions.PertDistribution <em>Pert Distribution</em>}'.
     * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @see distributions.PertDistribution
     * @generated
     */
    public Adapter createPertDistributionAdapter()
    {
        return null;
    }

    /**
     * Creates a new adapter for an object of class '{@link distributions.NormalDistribution <em>Normal Distribution</em>}'.
     * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @see distributions.NormalDistribution
     * @generated
     */
    public Adapter createNormalDistributionAdapter()
    {
        return null;
    }

    /**
     * Creates a new adapter for an object of class '{@link distributions.EnumeratedDistribution <em>Enumerated Distribution</em>}'.
     * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @see distributions.EnumeratedDistribution
     * @generated
     */
    public Adapter createEnumeratedDistributionAdapter()
    {
        return null;
    }

    /**
     * Creates a new adapter for an object of class '{@link distributions.GammaDistribution <em>Gamma Distribution</em>}'.
     * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @see distributions.GammaDistribution
     * @generated
     */
    public Adapter createGammaDistributionAdapter()
    {
        return null;
    }

    /**
     * Creates a new adapter for an object of class '{@link distributions.PoissonDistribution <em>Poisson Distribution</em>}'.
     * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @see distributions.PoissonDistribution
     * @generated
     */
    public Adapter createPoissonDistributionAdapter()
    {
        return null;
    }

    /**
     * Creates a new adapter for an object of class '{@link distributions.LogNormalDistribution <em>Log Normal Distribution</em>}'.
     * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @see distributions.LogNormalDistribution
     * @generated
     */
    public Adapter createLogNormalDistributionAdapter()
    {
        return null;
    }

    /**
     * Creates a new adapter for an object of class '{@link expressions.AbstractElement <em>Abstract Element</em>}'.
     * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @see expressions.AbstractElement
     * @generated
     */
    public Adapter createAbstractElementAdapter()
    {
        return null;
    }

    /**
     * Creates a new adapter for an object of class '{@link expressions.Expression <em>Expression</em>}'.
     * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @see expressions.Expression
     * @generated
     */
    public Adapter createExpressionAdapter()
    {
        return null;
    }

    /**
     * Creates a new adapter for the default case.
     * <!-- begin-user-doc -->
     * This default implementation returns null.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @generated
     */
    public Adapter createEObjectAdapter()
    {
        return null;
    }

} //DistributionsAdapterFactory
