/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.timing.view;

import distributions.Distribution;
import distributions.ModeDistributionsFactory;
import distributions.math.ModeDistribution;
import distributions.math.ModeNotSupportedException;
import expressions.Declaration;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.math3.distribution.NormalDistribution;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.BasicEMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.lsat.timing.view.XYPlotData;
import org.eclipse.lsat.timing.view.XYPlotView;
import org.eclipse.xtext.EcoreUtil2;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.ui.RectangleAnchor;
import org.jfree.chart.ui.TextAnchor;
import org.jfree.data.Range;
import org.jfree.data.xy.XYBarDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import setting.PhysicalSettings;
import setting.impl.TimingSettingsMapEntryImpl;

public class DistributionViewJob
extends Job {
    private final Distribution distribution;

    public DistributionViewJob(Distribution distribution) {
        super("Plot " + DistributionViewJob.getName(distribution));
        this.distribution = distribution;
    }

    private static String getName(Distribution distribution) {
        EObject container = distribution.eContainer();
        while (container != null && !(container instanceof BasicEMap.Entry)) {
            container = container.eContainer();
        }
        if (container instanceof TimingSettingsMapEntryImpl) {
            TimingSettingsMapEntryImpl tsmei = (TimingSettingsMapEntryImpl)container;
            PhysicalSettings psmei = (PhysicalSettings)EcoreUtil2.getContainerOfType((EObject)tsmei, PhysicalSettings.class);
            return psmei.fqn() + "." + tsmei.getKey().getName();
        }
        if (container instanceof BasicEMap.Entry) {
            BasicEMap.Entry mapEntry = (BasicEMap.Entry)container;
            return mapEntry.getKey().toString();
        }
        container = distribution.eContainer();
        if (container instanceof Declaration) {
            Declaration decl = (Declaration)container;
            return "Declaration: " + decl.getName();
        }
        return distribution.eClass().getName();
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            String name = DistributionViewJob.getName(this.distribution);
            monitor.beginTask("Rendering plot " + name, -1);
            ModeDistribution modeDistribution = ModeDistributionsFactory.createDistribution((Distribution)this.distribution);
            double mean = modeDistribution.getNumericalMean();
            Range range = this.getDistributionRange(modeDistribution);
            double step = Math.max(range.getLength() / 1000.0, 1.0E-6);
            XYSeries series = new XYSeries((Comparable)((Object)name));
            double x = range.getLowerBound();
            while (x < range.getUpperBound() + step) {
                series.add(x, modeDistribution.density(x));
                x += step;
            }
            XYSeriesCollection dataset = new XYSeriesCollection(series);
            JFreeChart jfreechart = ChartFactory.createXYLineChart((String)"Probability Density Function", (String)"Time", (String)"Density", (XYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
            ValueMarker meanMarker = new ValueMarker(mean, (Paint)Color.BLACK, (Stroke)new BasicStroke(1.0f));
            meanMarker.setLabel(String.format("mean = %.6f", mean));
            meanMarker.setLabelAnchor(RectangleAnchor.BOTTOM_LEFT);
            meanMarker.setLabelTextAnchor(TextAnchor.BOTTOM_RIGHT);
            jfreechart.getXYPlot().addDomainMarker((Marker)meanMarker);
            boolean showDebugInfo = Platform.getPreferencesService().getBoolean("org.eclipse.lsat.timing", "org.eclipse.lsat.timing.view.debug", false, null);
            if (showDebugInfo) {
                this.addSampledDataset(jfreechart, modeDistribution, 1);
                try {
                    ValueMarker modeMarker = new ValueMarker(modeDistribution.getMode(), (Paint)Color.GRAY, (Stroke)new BasicStroke(1.0f));
                    modeMarker.setLabel(String.format("mode = %.6f", modeDistribution.getMode()));
                    modeMarker.setLabelAnchor(RectangleAnchor.TOP_LEFT);
                    modeMarker.setLabelTextAnchor(TextAnchor.TOP_RIGHT);
                    jfreechart.getXYPlot().addDomainMarker((Marker)modeMarker);
                }
                catch (ModeNotSupportedException modeMarker) {
                    // empty catch block
                }
            }
            ArrayList<XYPlotData> plotData = new ArrayList<XYPlotData>();
            plotData.add(new XYPlotData(jfreechart.getTitle().getText(), jfreechart));
            XYPlotView.showPlots(plotData);
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        catch (Exception e) {
            Status status = new Status(4, "org.eclipse.lsat.timing", e.getMessage(), (Throwable)e);
            return status;
        }
        finally {
            monitor.done();
        }
    }

    private Range getDistributionRange(ModeDistribution distribution) {
        double lower = distribution.getLowerBound();
        double upper = distribution.getUpperBound();
        if (distribution instanceof NormalDistribution) {
            double mean = distribution.getNumericalMean();
            double sd = ((NormalDistribution)distribution).getStandardDeviation();
            lower = mean - 4.0 * sd;
            upper = mean + 4.0 * sd;
        }
        return new Range(Math.max(lower, 0.0), Math.min(upper, 60.0));
    }

    private void addSampledDataset(JFreeChart jfreechart, ModeDistribution realDistribution, int index) {
        double[] samples = realDistribution.nextSamples(1000);
        double sampleSize = this.getDistributionRange(realDistribution).getLength() / 15.0;
        HashMap<Double, Integer> data = new HashMap<Double, Integer>();
        int i = 0;
        while (i < samples.length) {
            double sample = Math.floor(samples[i] / sampleSize);
            int count = data.containsKey(sample) ? (Integer)data.get(sample) : 0;
            data.put(sample, ++count);
            ++i;
        }
        XYSeries series = new XYSeries((Comparable)((Object)("sampled (" + samples.length + "x)")));
        for (Map.Entry entry : data.entrySet()) {
            series.add((Double)entry.getKey() * sampleSize + sampleSize / 2.0, (Number)entry.getValue());
        }
        XYPlot xyplot = jfreechart.getXYPlot();
        NumberAxis numberaxis = new NumberAxis("number of samples");
        xyplot.setRangeAxis(index, (ValueAxis)numberaxis);
        xyplot.setDataset(index, (XYDataset)new XYBarDataset((XYDataset)new XYSeriesCollection(series), sampleSize));
        xyplot.mapDatasetToRangeAxis(index, index);
        xyplot.setRenderer(index, (XYItemRenderer)new XYBarRenderer());
    }
}

