/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.timing.util;

import activity.Move;
import activity.SimpleAction;
import com.google.common.collect.Iterables;
import distributions.CalculationMode;
import distributions.Distribution;
import distributions.DistributionsAdapter;
import expressions.BigDecimalConstant;
import expressions.Expression;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import machine.ActionType;
import machine.IResource;
import machine.Peripheral;
import machine.Profile;
import machine.SetPoint;
import org.apache.commons.math3.random.JDKRandomGenerator;
import org.apache.commons.math3.random.RandomGenerator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.lsat.common.graph.directed.editable.Node;
import org.eclipse.lsat.common.util.IterableUtil;
import org.eclipse.lsat.motioncalculator.MotionException;
import org.eclipse.lsat.motioncalculator.MotionProfile;
import org.eclipse.lsat.motioncalculator.MotionSegment;
import org.eclipse.lsat.motioncalculator.PositionInfo;
import org.eclipse.lsat.motioncalculator.util.MotionSegmentUtilities;
import org.eclipse.lsat.timing.calculator.MotionCalculatorExtension;
import org.eclipse.lsat.timing.util.ITimingCalculator;
import org.eclipse.lsat.timing.util.MotionCalculatorHelper;
import org.eclipse.lsat.timing.util.MotionData;
import org.eclipse.lsat.timing.util.SpecificationException;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.MapExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;
import setting.MoveAdjustments;
import setting.PhysicalSettings;
import setting.Settings;
import timing.Array;
import timing.Scalar;

public class TimingCalculator
implements ITimingCalculator {
    private static final MathContext MICRO_SECONDS = new MathContext(6, RoundingMode.HALF_UP);
    private static final double HALF_MICRO_SECOND = 0.5 * Math.pow(10.0, -MICRO_SECONDS.getPrecision());
    private final Map<Array, Integer> _IntermediateProperty_pointer = new WeakHashMap<Array, Integer>();
    private final RandomGenerator distributionRandom = new JDKRandomGenerator(1618033989);
    private final MotionCalculatorHelper motionCalculatorHelper;
    private final CalculationMode mode;
    private final boolean synchronizeAxes;
    private final Map<Node, BigDecimal> nodeTimes;
    private final Map<Move, Map<SetPoint, BigDecimal>> motionTimes;
    private final DistributionsAdapter distributions;
    private final Map<Node, Map<String, MotionData>> motionData;
    private static final Integer _DEFAULT_ARRAY_POINTER = -1;

    public TimingCalculator(Settings settings, MotionCalculatorExtension motionCalculator) {
        this(settings, motionCalculator, CalculationMode.MEAN, true, true);
    }

    public TimingCalculator(Settings settings, MotionCalculatorExtension motionCalculator, CalculationMode mode) {
        this(settings, motionCalculator, mode, true, true);
    }

    public TimingCalculator(Settings settings, MotionCalculatorExtension motionCalculator, CalculationMode mode, boolean synchronizeAxes, boolean useCache) {
        MotionCalculatorHelper _motionCalculatorHelper;
        this.motionCalculatorHelper = _motionCalculatorHelper = new MotionCalculatorHelper(settings, motionCalculator);
        this.mode = mode;
        this.synchronizeAxes = synchronizeAxes;
        IdentityHashMap _xifexpression = null;
        if (useCache && Objects.equals(mode, CalculationMode.MEAN)) {
            _xifexpression = new IdentityHashMap();
        }
        this.nodeTimes = _xifexpression;
        IdentityHashMap _xifexpression_1 = null;
        if (useCache) {
            _xifexpression_1 = new IdentityHashMap();
        }
        this.motionTimes = _xifexpression_1;
        this.distributions = DistributionsAdapter.getAdapter((EObject)settings);
        IdentityHashMap _xifexpression_2 = null;
        if (useCache) {
            _xifexpression_2 = new IdentityHashMap();
        }
        this.motionData = _xifexpression_2;
        this.distributions.setCalculationMode(mode);
        this.distributions.setRandomGenerator(this.distributionRandom);
    }

    public Settings getSettings() {
        return this.motionCalculatorHelper.getSettings();
    }

    public MotionCalculatorExtension getMotionCalculator() {
        return this.motionCalculatorHelper.getMotionCalculator();
    }

    @Override
    public void reset() {
        this._IntermediateProperty_pointer.clear();
        if (this.nodeTimes != null) {
            this.nodeTimes.clear();
        }
        if (this.motionTimes != null) {
            this.motionTimes.clear();
        }
        Resource _eResource = this.getSettings().eResource();
        ResourceSet _resourceSet = null;
        if (_eResource != null) {
            _resourceSet = _eResource.getResourceSet();
        }
        DistributionsAdapter.resetDistributions(_resourceSet);
        if (this.motionData != null) {
            this.motionData.clear();
        }
    }

    @Override
    public BigDecimal calculateDuration(Node node) throws MotionException {
        BigDecimal _xifexpression = null;
        if (this.nodeTimes == null) {
            _xifexpression = this.doCalculateDuration(node);
        } else {
            Function<Node, BigDecimal> _function = it -> this.doCalculateDuration((Node)it);
            _xifexpression = this.nodeTimes.computeIfAbsent(node, _function);
        }
        return _xifexpression;
    }

    protected BigDecimal _doCalculateDuration(Node node) {
        return BigDecimal.ZERO;
    }

    protected BigDecimal _doCalculateDuration(SimpleAction action) {
        return this.doCalculateValue(action.getType(), action.getResource(), action.getPeripheral());
    }

    protected BigDecimal doCalculateValue(ActionType actionType, IResource resource, Peripheral peripheral) {
        try {
            return this.doCalculateValue((EObject)this.getPhysicalSettings(resource, peripheral).getTimingSettings().get((Object)actionType));
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected BigDecimal _doCalculateValue(Scalar scalar) {
        return this.doCalculateValue((EObject)scalar.getValueExp());
    }

    protected BigDecimal _doCalculateValue(Array array) {
        BigDecimal _switchResult = null;
        CalculationMode mode = this.mode;
        if (mode != null) {
            switch (mode) {
                case LINEAIR: {
                    BigDecimal _xblockexpression = null;
                    Integer _pointer = this.getPointer(array);
                    int _plus = _pointer + 1;
                    int _size = array.getValues().size();
                    int _modulo = _plus % _size;
                    this.setPointer(array, _modulo);
                    _switchResult = _xblockexpression = this.doCalculateValue((EObject)array.getValuesExp().get(this.getPointer(array).intValue()));
                    break;
                }
                default: {
                    Functions.Function1 _function = it -> this.doCalculateValue((EObject)it);
                    _switchResult = TimingCalculator.getAverage(ListExtensions.map((List)array.getValuesExp(), (Functions.Function1)_function));
                    break;
                }
            }
        } else {
            Functions.Function1 _function = it -> this.doCalculateValue((EObject)it);
            _switchResult = TimingCalculator.getAverage(ListExtensions.map((List)array.getValuesExp(), (Functions.Function1)_function));
        }
        return _switchResult;
    }

    protected BigDecimal _doCalculateValue(Distribution distribution) {
        return TimingCalculator.normalize(distribution.evaluate());
    }

    protected BigDecimal _doCalculateValue(Expression expression) {
        return expression.evaluate();
    }

    protected BigDecimal _doCalculateDuration(Move move) {
        try {
            return (BigDecimal)IterableUtil.max(this.calculateMotionTime(move).values(), (Comparable)BigDecimal.ZERO);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    @Override
    public Map<SetPoint, BigDecimal> calculateMotionTime(Move move) throws MotionException {
        Map<SetPoint, BigDecimal> motionTime = null;
        if (this.motionTimes == null) {
            motionTime = this.doCalculateMotionTimes(move).get(move);
        } else {
            boolean _not;
            boolean _containsKey = this.motionTimes.containsKey(move);
            boolean bl = _not = !_containsKey;
            if (_not) {
                this.motionTimes.putAll(this.doCalculateMotionTimes(move));
            }
            motionTime = this.motionTimes.get(move);
        }
        String profileName = move.getProfile().getName();
        LinkedHashMap motionTimeCopy = CollectionLiterals.newLinkedHashMap();
        PhysicalSettings physicalSettings = this.motionCalculatorHelper.getSettings().getPhysicalSettings(move.getResource(), move.getPeripheral());
        Functions.Function1 _function = it -> it.getProfile() != null && Objects.equals(it.getProfile().getName(), profileName);
        MoveAdjustments adjustments = (MoveAdjustments)IterableExtensions.findFirst((Iterable)physicalSettings.getMoveAdjustments(), (Functions.Function1)_function);
        if (adjustments == null) {
            Functions.Function1 _function_1 = it -> {
                Profile _profile = it.getProfile();
                return _profile == null;
            };
            adjustments = (MoveAdjustments)IterableExtensions.findFirst((Iterable)physicalSettings.getMoveAdjustments(), (Functions.Function1)_function_1);
        }
        if (adjustments != null) {
            Expression _expression = adjustments.getTimeDeclaration().getExpression();
            BigDecimalConstant bdConst = (BigDecimalConstant)_expression;
            try {
                Set<Map.Entry<SetPoint, BigDecimal>> _entrySet = motionTime.entrySet();
                for (Map.Entry<SetPoint, BigDecimal> element : _entrySet) {
                    bdConst.setValue(element.getValue());
                    motionTimeCopy.put(element.getKey(), adjustments.getAdjustExpression().evaluate());
                }
            }
            finally {
                bdConst.setValue(BigDecimal.ZERO);
            }
            return motionTimeCopy;
        }
        return motionTime;
    }

    @Override
    public Map<String, MotionData> calculateMotionData(Node node) throws MotionException {
        boolean _not;
        if (this.motionData == null) {
            return this.doCalculateMotionData(node).get(node);
        }
        boolean _containsKey = this.motionData.containsKey(node);
        boolean bl = _not = !_containsKey;
        if (_not) {
            this.motionData.putAll(this.doCalculateMotionData(node));
        }
        return this.motionData.get(node);
    }

    protected Map<Move, ? extends Map<SetPoint, BigDecimal>> doCalculateMotionTimes(Move move) {
        try {
            Map _xifexpression = null;
            if (this.synchronizeAxes) {
                EList _axes = move.getPeripheral().getType().getAxes();
                EList _setPoints = move.getPeripheral().getType().getSetPoints();
                Pair _mappedTo = Pair.of((Object)_axes, (Object)_setPoints);
                _xifexpression = CollectionLiterals.newHashMap((Pair[])new Pair[]{_mappedTo});
            } else {
                Functions.Function1 _function = it -> it.getAxes();
                _xifexpression = IterableExtensions.groupBy((Iterable)move.getPeripheral().getType().getSetPoints(), (Functions.Function1)_function);
            }
            Map axesAndSetPoints = _xifexpression;
            List<Move> concatenatedMove = this.motionCalculatorHelper.getConcatenatedMove(move);
            int _size = concatenatedMove.size();
            IdentityHashMap<Move, IdentityHashMap> result = new IdentityHashMap<Move, IdentityHashMap>(_size);
            Set _entrySet = axesAndSetPoints.entrySet();
            for (Map.Entry e : _entrySet) {
                List<MotionSegment> motionSegments = this.motionCalculatorHelper.createMotionSegments(concatenatedMove, (Collection)e.getKey());
                List<Double> motionTimes = this.motionCalculatorHelper.getMotionCalculator().calculateTimes(motionSegments);
                BigDecimal startTime = BigDecimal.ZERO;
                int i = 0;
                while (i < motionTimes.size()) {
                    BigDecimal endTime = TimingCalculator.normalize(motionTimes.get(i));
                    Function<Move, IdentityHashMap> _function_1 = it -> {
                        int _size_1 = move.getPeripheral().getType().getSetPoints().size();
                        return new IdentityHashMap(_size_1);
                    };
                    TimingCalculator.fill(result.computeIfAbsent(concatenatedMove.get(i), _function_1), (Collection)e.getValue(), endTime.subtract(startTime));
                    startTime = endTime;
                    ++i;
                }
            }
            return result;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected Map<? extends Node, ? extends Map<String, MotionData>> _doCalculateMotionData(Node node) {
        IdentityHashMap result = new IdentityHashMap();
        IdentityHashMap _identityHashMap = new IdentityHashMap();
        result.put(node, _identityHashMap);
        return result;
    }

    protected Map<? extends Node, ? extends Map<String, MotionData>> _doCalculateMotionData(Move move) {
        try {
            Map _xifexpression = null;
            if (this.synchronizeAxes) {
                EList _axes = move.getPeripheral().getType().getAxes();
                EList _setPoints = move.getPeripheral().getType().getSetPoints();
                Pair _mappedTo = Pair.of((Object)_axes, (Object)_setPoints);
                _xifexpression = CollectionLiterals.newHashMap((Pair[])new Pair[]{_mappedTo});
            } else {
                Functions.Function1 _function = it -> it.getAxes();
                _xifexpression = IterableExtensions.groupBy((Iterable)move.getPeripheral().getType().getSetPoints(), (Functions.Function1)_function);
            }
            Map axesAndSetPoints = _xifexpression;
            List<Move> concatenatedMove = this.motionCalculatorHelper.getConcatenatedMove(move);
            IdentityHashMap<Move, IdentityHashMap> result = new IdentityHashMap<Move, IdentityHashMap>();
            Set _entrySet = axesAndSetPoints.entrySet();
            for (Map.Entry e : _entrySet) {
                List<MotionSegment> motionSegments = this.motionCalculatorHelper.createMotionSegments(concatenatedMove, (Collection)e.getKey());
                MotionProfile motionProfile = (MotionProfile)MotionSegmentUtilities.getMotionProfiles(motionSegments).iterator().next();
                Functions.Function1 _function_1 = it -> it.getName();
                List parameterNames = IterableExtensions.toList((Iterable)IterableExtensions.map((Iterable)motionProfile.getParameters(), (Functions.Function1)_function_1));
                Collection<PositionInfo> _positionInfo = this.motionCalculatorHelper.getMotionCalculator().getPositionInfo(motionSegments);
                for (PositionInfo positionInfo : _positionInfo) {
                    List allData = positionInfo.getAllData();
                    BigDecimal startTime = BigDecimal.ZERO;
                    for (Move moveSegment : concatenatedMove) {
                        double startTimeD = startTime.doubleValue();
                        Functions.Function2 _function_2 = (key, value) -> {
                            String _name = key.getName();
                            String _setPointId = positionInfo.getSetPointId();
                            return Objects.equals(_name, _setPointId);
                        };
                        BigDecimal _get = ((BigDecimal[])Conversions.unwrapArray(MapExtensions.filter(this.calculateMotionTime(moveSegment), (Functions.Function2)_function_2).values(), BigDecimal.class))[0];
                        double endTimeD = startTime.add(_get).doubleValue();
                        Functions.Function1 _function_3 = array -> array[0] >= startTimeD - HALF_MICRO_SECOND && array[0] <= endTimeD + HALF_MICRO_SECOND;
                        Functions.Function1 _function_4 = array -> {
                            double _minus;
                            double[] _xblockexpression = null;
                            double _get_1 = array[0];
                            array[0] = _minus = _get_1 - startTimeD;
                            _xblockexpression = array;
                            return _xblockexpression;
                        };
                        List filteredData = IterableExtensions.toList((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)allData, (Functions.Function1)_function_3), (Functions.Function1)_function_4));
                        MotionData motionData = new MotionData();
                        motionData.setTimeData(filteredData);
                        List _asList = IterableUtil.asList((Object[])new String[]{"Time", "Position"});
                        motionData.setParameterNames(IterableExtensions.toList((Iterable)Iterables.concat((Iterable)_asList, (Iterable)parameterNames)));
                        Function<Move, IdentityHashMap> _function_5 = it -> new IdentityHashMap();
                        result.computeIfAbsent(moveSegment, _function_5).put(positionInfo.getSetPointId(), motionData);
                        BigDecimal _startTime = startTime;
                        Functions.Function2 _function_6 = (key, value) -> {
                            String _name = key.getName();
                            String _setPointId = positionInfo.getSetPointId();
                            return Objects.equals(_name, _setPointId);
                        };
                        BigDecimal _get_1 = ((BigDecimal[])Conversions.unwrapArray(MapExtensions.filter(this.calculateMotionTime(moveSegment), (Functions.Function2)_function_6).values(), BigDecimal.class))[0];
                        startTime = _startTime.add(_get_1);
                    }
                }
            }
            return result;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected PhysicalSettings getPhysicalSettings(IResource resource, Peripheral peripheral) throws SpecificationException {
        PhysicalSettings physicalSettings = this.getSettings().getPhysicalSettings(resource, peripheral);
        if (physicalSettings == null) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Physical settings not specified for peripheral: ");
            String _fqn = peripheral.fqn();
            _builder.append(_fqn);
            Settings _settings = this.getSettings();
            throw new SpecificationException(_builder.toString(), new EObject[]{_settings});
        }
        return physicalSettings;
    }

    public static <K, V> void fill(Map<K, V> map, Collection<? extends K> keys, V value) {
        Consumer<Object> _function = it -> map.put(it, value);
        keys.forEach(_function);
    }

    public static BigDecimal getAverage(Collection<BigDecimal> values) {
        BigDecimal sum = (BigDecimal)IterableExtensions.head(values);
        Iterable _tail = IterableExtensions.tail(values);
        for (BigDecimal value : _tail) {
            BigDecimal _sum = sum;
            sum = _sum.add(value);
        }
        int _size = values.size();
        BigDecimal _bigDecimal = new BigDecimal(_size);
        return sum.divide(_bigDecimal, MICRO_SECONDS);
    }

    public static BigDecimal normalize(Number number) {
        BigDecimal result = BigDecimal.valueOf(number.doubleValue());
        return result.max(BigDecimal.ZERO).setScale(MICRO_SECONDS.getPrecision(), MICRO_SECONDS.getRoundingMode());
    }

    @XbaseGenerated
    protected BigDecimal doCalculateDuration(Node move) {
        if (move instanceof Move) {
            return this._doCalculateDuration((Move)move);
        }
        if (move instanceof SimpleAction) {
            return this._doCalculateDuration((SimpleAction)move);
        }
        if (move != null) {
            return this._doCalculateDuration(move);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(move).toString());
    }

    @XbaseGenerated
    protected BigDecimal doCalculateValue(EObject distribution) {
        if (distribution instanceof Distribution) {
            return this._doCalculateValue((Distribution)distribution);
        }
        if (distribution instanceof Expression) {
            return this._doCalculateValue((Expression)distribution);
        }
        if (distribution instanceof Array) {
            return this._doCalculateValue((Array)distribution);
        }
        if (distribution instanceof Scalar) {
            return this._doCalculateValue((Scalar)distribution);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(distribution).toString());
    }

    @XbaseGenerated
    protected Map<? extends Node, ? extends Map<String, MotionData>> doCalculateMotionData(Node move) {
        if (move instanceof Move) {
            return this._doCalculateMotionData((Move)move);
        }
        if (move != null) {
            return this._doCalculateMotionData(move);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(move).toString());
    }

    private Integer getPointer(Array owner) {
        Integer value = this._IntermediateProperty_pointer.get(owner);
        return value == null ? _DEFAULT_ARRAY_POINTER : value;
    }

    private void setPointer(Array owner, Integer value) {
        if (value == _DEFAULT_ARRAY_POINTER) {
            this._IntermediateProperty_pointer.remove(owner);
        } else {
            this._IntermediateProperty_pointer.put(owner, value);
        }
    }

    private void disposePointer() {
        this._IntermediateProperty_pointer.clear();
    }
}

