/**
 */
package lsat_graph.impl;

import org.eclipse.lsat.common.graph.directed.DirectedGraphPackage;
import org.eclipse.lsat.common.graph.directed.Edge;
import org.eclipse.lsat.common.graph.directed.Node;

import org.eclipse.lsat.common.graph.directed.impl.AspectImpl;

import org.eclipse.lsat.common.scheduler.graph.Task;

import org.eclipse.lsat.common.scheduler.schedule.ScheduledDependency;
import org.eclipse.lsat.common.scheduler.schedule.ScheduledTask;

import java.math.BigDecimal;

import lsat_graph.Bounds;
import org.eclipse.emf.common.notify.Notification;

import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;

import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.emf.ecore.util.EObjectWithInverseResolvingEList;

import lsat_graph.StochasticAnnotation;
import lsat_graph.lsat_graphPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Stochastic Annotation</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link lsat_graph.impl.StochasticAnnotationImpl#getCriticality <em>Criticality</em>}</li>
 *   <li>{@link lsat_graph.impl.StochasticAnnotationImpl#getConfidenceInterval <em>Confidence Interval</em>}</li>
 *   <li>{@link lsat_graph.impl.StochasticAnnotationImpl#getStandardDeviation <em>Standard Deviation</em>}</li>
 *   <li>{@link lsat_graph.impl.StochasticAnnotationImpl#getSkewness <em>Skewness</em>}</li>
 *   <li>{@link lsat_graph.impl.StochasticAnnotationImpl#getMax <em>Max</em>}</li>
 *   <li>{@link lsat_graph.impl.StochasticAnnotationImpl#getMin <em>Min</em>}</li>
 *   <li>{@link lsat_graph.impl.StochasticAnnotationImpl#getMean <em>Mean</em>}</li>
 * </ul>
 *
 * @generated
 */
public class StochasticAnnotationImpl extends AspectImpl<ScheduledTask<Task>, ScheduledDependency> implements StochasticAnnotation {
	/**
     * The default value of the '{@link #getCriticality() <em>Criticality</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getCriticality()
     * @generated
     * @ordered
     */
    protected static final BigDecimal CRITICALITY_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getCriticality() <em>Criticality</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getCriticality()
     * @generated
     * @ordered
     */
    protected BigDecimal criticality = CRITICALITY_EDEFAULT;

    /**
     * The cached value of the '{@link #getConfidenceInterval() <em>Confidence Interval</em>}' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getConfidenceInterval()
     * @generated
     * @ordered
     */
    protected Bounds confidenceInterval;

    /**
     * The default value of the '{@link #getStandardDeviation() <em>Standard Deviation</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getStandardDeviation()
     * @generated
     * @ordered
     */
    protected static final BigDecimal STANDARD_DEVIATION_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getStandardDeviation() <em>Standard Deviation</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getStandardDeviation()
     * @generated
     * @ordered
     */
    protected BigDecimal standardDeviation = STANDARD_DEVIATION_EDEFAULT;

    /**
     * The default value of the '{@link #getSkewness() <em>Skewness</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getSkewness()
     * @generated
     * @ordered
     */
    protected static final BigDecimal SKEWNESS_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getSkewness() <em>Skewness</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getSkewness()
     * @generated
     * @ordered
     */
    protected BigDecimal skewness = SKEWNESS_EDEFAULT;

    /**
     * The default value of the '{@link #getMax() <em>Max</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getMax()
     * @generated
     * @ordered
     */
    protected static final BigDecimal MAX_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getMax() <em>Max</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getMax()
     * @generated
     * @ordered
     */
    protected BigDecimal max = MAX_EDEFAULT;

    /**
     * The default value of the '{@link #getMin() <em>Min</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getMin()
     * @generated
     * @ordered
     */
    protected static final BigDecimal MIN_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getMin() <em>Min</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getMin()
     * @generated
     * @ordered
     */
    protected BigDecimal min = MIN_EDEFAULT;

    /**
     * The default value of the '{@link #getMean() <em>Mean</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getMean()
     * @generated
     * @ordered
     */
    protected static final BigDecimal MEAN_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getMean() <em>Mean</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getMean()
     * @generated
     * @ordered
     */
    protected BigDecimal mean = MEAN_EDEFAULT;

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected StochasticAnnotationImpl() {
        super();
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	protected EClass eStaticClass() {
        return lsat_graphPackage.Literals.STOCHASTIC_ANNOTATION;
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * This is specialized for the more specific element type known in this context.
     * @generated
     */
	@Override
	public EList<ScheduledDependency> getEdges() {
        if (edges == null)
        {
            edges = new EObjectWithInverseResolvingEList.ManyInverse<ScheduledDependency>(ScheduledDependency.class, this, lsat_graphPackage.STOCHASTIC_ANNOTATION__EDGES, DirectedGraphPackage.EDGE__ASPECTS) { private static final long serialVersionUID = 1L; @Override public Class<?> getInverseFeatureClass() { return Edge.class; } };
        }
        return edges;
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * This is specialized for the more specific element type known in this context.
     * @generated
     */
	@Override
	public EList<ScheduledTask<Task>> getNodes() {
        if (nodes == null)
        {
            nodes = new EObjectWithInverseResolvingEList.ManyInverse<ScheduledTask<Task>>(ScheduledTask.class, this, lsat_graphPackage.STOCHASTIC_ANNOTATION__NODES, DirectedGraphPackage.NODE__ASPECTS) { private static final long serialVersionUID = 1L; @Override public Class<?> getInverseFeatureClass() { return Node.class; } };
        }
        return nodes;
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public BigDecimal getCriticality() {
        return criticality;
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public void setCriticality(BigDecimal newCriticality) {
        BigDecimal oldCriticality = criticality;
        criticality = newCriticality;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, lsat_graphPackage.STOCHASTIC_ANNOTATION__CRITICALITY, oldCriticality, criticality));
    }

	/**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Bounds getConfidenceInterval()
    {
        return confidenceInterval;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public NotificationChain basicSetConfidenceInterval(Bounds newConfidenceInterval, NotificationChain msgs)
    {
        Bounds oldConfidenceInterval = confidenceInterval;
        confidenceInterval = newConfidenceInterval;
        if (eNotificationRequired())
        {
            ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, lsat_graphPackage.STOCHASTIC_ANNOTATION__CONFIDENCE_INTERVAL, oldConfidenceInterval, newConfidenceInterval);
            if (msgs == null) msgs = notification; else msgs.add(notification);
        }
        return msgs;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public void setConfidenceInterval(Bounds newConfidenceInterval)
    {
        if (newConfidenceInterval != confidenceInterval)
        {
            NotificationChain msgs = null;
            if (confidenceInterval != null)
                msgs = ((InternalEObject)confidenceInterval).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - lsat_graphPackage.STOCHASTIC_ANNOTATION__CONFIDENCE_INTERVAL, null, msgs);
            if (newConfidenceInterval != null)
                msgs = ((InternalEObject)newConfidenceInterval).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - lsat_graphPackage.STOCHASTIC_ANNOTATION__CONFIDENCE_INTERVAL, null, msgs);
            msgs = basicSetConfidenceInterval(newConfidenceInterval, msgs);
            if (msgs != null) msgs.dispatch();
        }
        else if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, lsat_graphPackage.STOCHASTIC_ANNOTATION__CONFIDENCE_INTERVAL, newConfidenceInterval, newConfidenceInterval));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public BigDecimal getStandardDeviation()
    {
        return standardDeviation;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public void setStandardDeviation(BigDecimal newStandardDeviation)
    {
        BigDecimal oldStandardDeviation = standardDeviation;
        standardDeviation = newStandardDeviation;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, lsat_graphPackage.STOCHASTIC_ANNOTATION__STANDARD_DEVIATION, oldStandardDeviation, standardDeviation));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public BigDecimal getSkewness()
    {
        return skewness;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public void setSkewness(BigDecimal newSkewness)
    {
        BigDecimal oldSkewness = skewness;
        skewness = newSkewness;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, lsat_graphPackage.STOCHASTIC_ANNOTATION__SKEWNESS, oldSkewness, skewness));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public BigDecimal getMax()
    {
        return max;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public void setMax(BigDecimal newMax)
    {
        BigDecimal oldMax = max;
        max = newMax;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, lsat_graphPackage.STOCHASTIC_ANNOTATION__MAX, oldMax, max));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public BigDecimal getMin()
    {
        return min;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public void setMin(BigDecimal newMin)
    {
        BigDecimal oldMin = min;
        min = newMin;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, lsat_graphPackage.STOCHASTIC_ANNOTATION__MIN, oldMin, min));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public BigDecimal getMean()
    {
        return mean;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public void setMean(BigDecimal newMean)
    {
        BigDecimal oldMean = mean;
        mean = newMean;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, lsat_graphPackage.STOCHASTIC_ANNOTATION__MEAN, oldMean, mean));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs)
    {
        switch (featureID)
        {
            case lsat_graphPackage.STOCHASTIC_ANNOTATION__CONFIDENCE_INTERVAL:
                return basicSetConfidenceInterval(null, msgs);
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID)
        {
            case lsat_graphPackage.STOCHASTIC_ANNOTATION__CRITICALITY:
                return getCriticality();
            case lsat_graphPackage.STOCHASTIC_ANNOTATION__CONFIDENCE_INTERVAL:
                return getConfidenceInterval();
            case lsat_graphPackage.STOCHASTIC_ANNOTATION__STANDARD_DEVIATION:
                return getStandardDeviation();
            case lsat_graphPackage.STOCHASTIC_ANNOTATION__SKEWNESS:
                return getSkewness();
            case lsat_graphPackage.STOCHASTIC_ANNOTATION__MAX:
                return getMax();
            case lsat_graphPackage.STOCHASTIC_ANNOTATION__MIN:
                return getMin();
            case lsat_graphPackage.STOCHASTIC_ANNOTATION__MEAN:
                return getMean();
        }
        return super.eGet(featureID, resolve, coreType);
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public void eSet(int featureID, Object newValue) {
        switch (featureID)
        {
            case lsat_graphPackage.STOCHASTIC_ANNOTATION__CRITICALITY:
                setCriticality((BigDecimal)newValue);
                return;
            case lsat_graphPackage.STOCHASTIC_ANNOTATION__CONFIDENCE_INTERVAL:
                setConfidenceInterval((Bounds)newValue);
                return;
            case lsat_graphPackage.STOCHASTIC_ANNOTATION__STANDARD_DEVIATION:
                setStandardDeviation((BigDecimal)newValue);
                return;
            case lsat_graphPackage.STOCHASTIC_ANNOTATION__SKEWNESS:
                setSkewness((BigDecimal)newValue);
                return;
            case lsat_graphPackage.STOCHASTIC_ANNOTATION__MAX:
                setMax((BigDecimal)newValue);
                return;
            case lsat_graphPackage.STOCHASTIC_ANNOTATION__MIN:
                setMin((BigDecimal)newValue);
                return;
            case lsat_graphPackage.STOCHASTIC_ANNOTATION__MEAN:
                setMean((BigDecimal)newValue);
                return;
        }
        super.eSet(featureID, newValue);
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public void eUnset(int featureID) {
        switch (featureID)
        {
            case lsat_graphPackage.STOCHASTIC_ANNOTATION__CRITICALITY:
                setCriticality(CRITICALITY_EDEFAULT);
                return;
            case lsat_graphPackage.STOCHASTIC_ANNOTATION__CONFIDENCE_INTERVAL:
                setConfidenceInterval((Bounds)null);
                return;
            case lsat_graphPackage.STOCHASTIC_ANNOTATION__STANDARD_DEVIATION:
                setStandardDeviation(STANDARD_DEVIATION_EDEFAULT);
                return;
            case lsat_graphPackage.STOCHASTIC_ANNOTATION__SKEWNESS:
                setSkewness(SKEWNESS_EDEFAULT);
                return;
            case lsat_graphPackage.STOCHASTIC_ANNOTATION__MAX:
                setMax(MAX_EDEFAULT);
                return;
            case lsat_graphPackage.STOCHASTIC_ANNOTATION__MIN:
                setMin(MIN_EDEFAULT);
                return;
            case lsat_graphPackage.STOCHASTIC_ANNOTATION__MEAN:
                setMean(MEAN_EDEFAULT);
                return;
        }
        super.eUnset(featureID);
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public boolean eIsSet(int featureID) {
        switch (featureID)
        {
            case lsat_graphPackage.STOCHASTIC_ANNOTATION__CRITICALITY:
                return CRITICALITY_EDEFAULT == null ? criticality != null : !CRITICALITY_EDEFAULT.equals(criticality);
            case lsat_graphPackage.STOCHASTIC_ANNOTATION__CONFIDENCE_INTERVAL:
                return confidenceInterval != null;
            case lsat_graphPackage.STOCHASTIC_ANNOTATION__STANDARD_DEVIATION:
                return STANDARD_DEVIATION_EDEFAULT == null ? standardDeviation != null : !STANDARD_DEVIATION_EDEFAULT.equals(standardDeviation);
            case lsat_graphPackage.STOCHASTIC_ANNOTATION__SKEWNESS:
                return SKEWNESS_EDEFAULT == null ? skewness != null : !SKEWNESS_EDEFAULT.equals(skewness);
            case lsat_graphPackage.STOCHASTIC_ANNOTATION__MAX:
                return MAX_EDEFAULT == null ? max != null : !MAX_EDEFAULT.equals(max);
            case lsat_graphPackage.STOCHASTIC_ANNOTATION__MIN:
                return MIN_EDEFAULT == null ? min != null : !MIN_EDEFAULT.equals(min);
            case lsat_graphPackage.STOCHASTIC_ANNOTATION__MEAN:
                return MEAN_EDEFAULT == null ? mean != null : !MEAN_EDEFAULT.equals(mean);
        }
        return super.eIsSet(featureID);
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public String toString() {
        if (eIsProxy()) return super.toString();

        StringBuilder result = new StringBuilder(super.toString());
        result.append(" (criticality: ");
        result.append(criticality);
        result.append(", standardDeviation: ");
        result.append(standardDeviation);
        result.append(", skewness: ");
        result.append(skewness);
        result.append(", max: ");
        result.append(max);
        result.append(", min: ");
        result.append(min);
        result.append(", mean: ");
        result.append(mean);
        result.append(')');
        return result.toString();
    }

} //StochasticAnnotationImpl
