/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.scheduler.product;

import activity.Move;
import activity.PeripheralAction;
import java.lang.runtime.SwitchBootstraps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lsat_graph.PeripheralActionTask;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.eclipse.lsat.common.graph.directed.Node;
import org.eclipse.lsat.common.graph.directed.editable.EditableDirectedGraph;
import org.eclipse.lsat.common.scheduler.graph.Task;
import org.eclipse.lsat.common.scheduler.schedule.Schedule;
import org.eclipse.lsat.common.scheduler.schedule.ScheduledTask;
import org.eclipse.lsat.product.productdata.Action;
import org.eclipse.lsat.product.productdata.EntryEvent;
import org.eclipse.lsat.product.productdata.ExitEvent;
import org.eclipse.lsat.product.productdata.LocationInformation;
import org.eclipse.lsat.product.productdata.ProductInstance;
import org.eclipse.lsat.product.productdata.TransferEvent;
import org.eclipse.lsat.scheduler.product.ProductChange;
import org.eclipse.lsat.scheduler.product.ProductOwner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProductUtil {
    private static final String SEPARATOR = System.lineSeparator() + "=".repeat(80);
    private static final Logger LOGGER = LoggerFactory.getLogger(ProductUtil.class);

    private ProductUtil() {
    }

    public static List<ProductChange> createProductChanges(Schedule<Task> schedule) {
        ArrayList<ProductChange> products = new ArrayList<ProductChange>();
        List<ImmutablePair> peripheralActions = schedule.allNodesInTopologicalOrder().stream().map(s -> ImmutablePair.of((Object)s, (Object)ProductUtil.getAction((Node)s))).filter(e -> e.right != null).toList();
        int numDigits = String.valueOf(peripheralActions.stream().map(ImmutablePair::getRight).distinct().count() - 1L).length();
        Map<PeripheralAction, Action> actionDataMap = peripheralActions.stream().map(ImmutablePair::getRight).distinct().collect(Collectors.toMap(a -> a, ProductUtil::createActionData));
        LinkedHashMap<String, Integer> nameCount = new LinkedHashMap<String, Integer>();
        for (ImmutablePair entry : peripheralActions) {
            ScheduledTask scheduledTask = (ScheduledTask)entry.left;
            PeripheralAction peripheralAction = (PeripheralAction)entry.right;
            Action peripheralActionData = actionDataMap.get(peripheralAction);
            BigDecimal startTime = scheduledTask.getStartTime();
            BigDecimal endTime = scheduledTask.getEndTime();
            PeripheralAction taskAction = ProductUtil.getAction((Node)scheduledTask);
            Integer index = nameCount.computeIfAbsent(scheduledTask.getName(), v -> 0);
            nameCount.put(scheduledTask.getName(), index + 1);
            String actionName = taskAction.getGraph().getName() + "." + scheduledTask.getName();
            String actionId = String.format("%0" + numDigits + "d%s%s", index, "#", actionName);
            org.eclipse.lsat.product.productdata.Task taskData = new org.eclipse.lsat.product.productdata.Task(scheduledTask, actionId, startTime, endTime, peripheralActionData);
            if (!peripheralAction.getProductChanges().isEmpty()) {
                for (activity.ProductChange productChange : peripheralAction.getProductChanges()) {
                    ProductChange productContext = new ProductChange((ScheduledTask<Task>)scheduledTask, taskData, productChange);
                    products.add(productContext);
                }
                continue;
            }
            ProductChange productContext = new ProductChange((ScheduledTask<Task>)scheduledTask, taskData, null);
            products.add(productContext);
        }
        return products;
    }

    public static PeripheralAction getAction(Node node) {
        PeripheralActionTask pTask;
        PeripheralAction peripheralAction;
        if (node instanceof ScheduledTask) {
            ScheduledTask scheduledTask = (ScheduledTask)node;
            node = scheduledTask.getTask();
        }
        if (node instanceof PeripheralActionTask && (peripheralAction = (PeripheralAction)(pTask = (PeripheralActionTask)node).getAction()) instanceof PeripheralAction) {
            PeripheralAction pAction = peripheralAction;
            return pAction;
        }
        return null;
    }

    public static String getSymbolicLocation(ScheduledTask<Task> initialScheduledTask, Schedule<Task> schedule) {
        List orderedMoveList = schedule.allNodesInTopologicalOrder().stream().filter(scheduledTask -> scheduledTask.getTask() instanceof PeripheralActionTask).filter(scheduledTask -> ((PeripheralActionTask)scheduledTask.getTask()).getAction() instanceof Move).collect(Collectors.toList());
        Optional<ScheduledTask> scheduledTaskMove = orderedMoveList.stream().filter(scheduledTask2 -> ((PeripheralAction)((PeripheralActionTask)scheduledTask2.getTask()).getAction()).fqn().equals(((PeripheralAction)((PeripheralActionTask)initialScheduledTask.getTask()).getAction()).fqn())).filter(scheduledTask2 -> scheduledTask2.getStartTime().doubleValue() > initialScheduledTask.getStartTime().doubleValue()).findFirst();
        if (scheduledTaskMove.isEmpty()) {
            return "N/A";
        }
        Move move = (Move)((PeripheralActionTask)scheduledTaskMove.get().getTask()).getAction();
        return move.getSourcePosition().getName();
    }

    public static <T extends Node> boolean isSuccessor(T start, T target) {
        if (start == null || target == null) {
            return false;
        }
        return ProductUtil.isSuccessor(start, target, new LinkedHashSet());
    }

    private static <T extends Node> boolean isSuccessor(T current, T target, Set<T> visited) {
        if (current.equals(target)) {
            return true;
        }
        if (visited.add(current)) {
            List<Node> successors = current.getOutgoingEdges().stream().map(e -> e.getTargetNode()).toList();
            for (Node successor : successors) {
                if (!ProductUtil.isSuccessor(successor, target, visited)) continue;
                return true;
            }
        }
        return false;
    }

    public static void logProductLocations(Map<ProductInstance, ProductChange> activeProducts) {
        if (activeProducts.isEmpty()) {
            return;
        }
        LOGGER.info(SEPARATOR + System.lineSeparator() + ProductUtil.getProductLocationsString(activeProducts) + SEPARATOR);
    }

    public static void logProductFlow(Collection<ProductInstance> instances) {
        LOGGER.info(SEPARATOR + System.lineSeparator() + ProductUtil.getProductFlowString(instances) + SEPARATOR);
    }

    public static String getProductLocationsString(Map<ProductInstance, ProductChange> activeProducts) {
        if (activeProducts.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("%-20s, %s", "ProductId", "Owner")).append(System.lineSeparator());
        sb.append(activeProducts.entrySet().stream().map(e -> String.format("%-20s, %s%s", ((ProductInstance)e.getKey()).getProductID(), ((ProductChange)e.getValue()).getProductOwner().getPeripheral(), ((ProductChange)e.getValue()).getSlot().isEmpty() ? "" : "." + ((ProductChange)e.getValue()).getSlot())).collect(Collectors.joining(System.lineSeparator())));
        return sb.toString();
    }

    public static String getProductFlowString(Collection<ProductInstance> instances) {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("%-9s, %-7s, %s", "ProductId", "Ready", "Flow"));
        for (ProductInstance instance : instances) {
            List<String> locs = instance.getLifeCycle().stream().map(ProductUtil::getLocationInformation).map(lis -> {
                String slot = lis.stream().map(LocationInformation::getSlot).distinct().collect(Collectors.joining(","));
                return lis.stream().map(li -> li.getTask().getAction().getPeripheral()).collect(Collectors.joining(" -" + slot + "-> ", "[", "]"));
            }).toList();
            sb.append(System.lineSeparator());
            sb.append(String.format("%9s, %-7s, %s", instance.getProductID(), instance.getLifeCycle().getLast() instanceof ExitEvent ? "yes" : "no", String.join((CharSequence)"->", locs)));
        }
        return sb.toString();
    }

    public static ProductInstance getProductInstanceThatHasNotPassedSlot(Map<ProductInstance, ProductChange> activeProducts, ProductOwner productOwner, String slot) {
        ProductInstance result = activeProducts.entrySet().stream().filter(e -> ((ProductChange)e.getValue()).getProductOwner().equals(productOwner)).map(Map.Entry::getKey).filter(pi -> slot.isEmpty() || !pi.getLifeCycle().stream().map(ProductUtil::getLocationInformation).flatMap(Collection::stream).anyMatch(l -> l.getSlot().equals(slot))).findFirst().orElse(null);
        if (result == null) {
            PeripheralAction action = productOwner.getAction();
            EditableDirectedGraph activity = action.getGraph();
            throw new IllegalArgumentException("Action: '" + activity.getName() + "." + action.getName() + "' cannot find an existing product owner for " + String.valueOf(productOwner) + " using slot: '" + slot + "'");
        }
        return result;
    }

    public static ProductInstance getProductInstanceForSlot(Map<ProductInstance, ProductChange> activeProducts, ProductOwner owner, String slot) {
        ProductInstance productInstance = activeProducts.entrySet().stream().filter(e -> ((ProductChange)e.getValue()).getProductOwner().equals(owner)).filter(e -> slot == null || slot.isEmpty() || ((ProductChange)e.getValue()).getSlot().equals(slot)).map(Map.Entry::getKey).reduce((a, b) -> b).orElse(null);
        return productInstance;
    }

    private static Action createActionData(PeripheralAction peripheralAction) {
        String activityName = peripheralAction.getGraph().getName();
        String actionName = peripheralAction.getName();
        return new Action(activityName, actionName, peripheralAction.fqn());
    }

    public static List<LocationInformation> getLocationInformation(Object event) {
        Object object = event;
        Objects.requireNonNull(object);
        Object object2 = object;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{EntryEvent.class, ExitEvent.class, TransferEvent.class}, (Object)object2, 0)) {
            case 0 -> {
                EntryEvent entry = (EntryEvent)object2;
                yield List.of(entry.getEntry());
            }
            case 1 -> {
                ExitEvent exit = (ExitEvent)object2;
                yield List.of(exit.getExit());
            }
            case 2 -> {
                TransferEvent transfer = (TransferEvent)object2;
                yield List.of(transfer.getTransfer().getOut(), transfer.getTransfer().getIn());
            }
            default -> List.of();
        };
    }
}

