/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.conversion;

import org.eclipse.core.databinding.conversion.IConverter;

public class StringToCharacterConverter
implements IConverter<Object, Character> {
    private final boolean primitiveTarget;

    public StringToCharacterConverter(boolean primitiveTarget) {
        this.primitiveTarget = primitiveTarget;
    }

    @Override
    public Character convert(Object source) {
        Character result;
        if (source != null && !(source instanceof String)) {
            throw new IllegalArgumentException("String2Character: Expected type String, got type [" + source.getClass().getName() + "]");
        }
        String s = (String)source;
        if (source == null || s.isEmpty()) {
            if (this.primitiveTarget) {
                throw new IllegalArgumentException("String2Character: cannot convert null/empty string to character primitive");
            }
            return null;
        }
        if (s.length() > 1) {
            throw new IllegalArgumentException("String2Character: string too long: " + s);
        }
        try {
            result = Character.valueOf(s.charAt(0));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("String2Character: " + e.getMessage() + ": " + s);
        }
        return result;
    }

    @Override
    public Object getFromType() {
        return String.class;
    }

    @Override
    public Object getToType() {
        return this.primitiveTarget ? Character.TYPE : Character.class;
    }

    public static StringToCharacterConverter toCharacter(boolean primitive) {
        return new StringToCharacterConverter(primitive);
    }
}

