/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate;

import java.util.List;
import org.eclipse.elk.alg.layered.ILayoutProcessor;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LGraphAdapters;
import org.eclipse.elk.alg.layered.graph.LMargin;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.Layer;
import org.eclipse.elk.alg.layered.properties.InternalProperties;
import org.eclipse.elk.alg.layered.properties.LayeredOptions;
import org.eclipse.elk.core.math.ElkMargin;
import org.eclipse.elk.core.util.IElkProgressMonitor;
import org.eclipse.elk.core.util.adapters.GraphAdapters;
import org.eclipse.elk.core.util.nodespacing.NodeDimensionCalculation;

public final class NodeMarginCalculator
implements ILayoutProcessor {
    @Override
    public void process(LGraph layeredGraph, IElkProgressMonitor monitor) {
        monitor.begin("Node margin calculation", 1.0f);
        NodeDimensionCalculation.calculateNodeMargins((GraphAdapters.GraphAdapter)LGraphAdapters.adapt(layeredGraph, true));
        double spacing = (Double)layeredGraph.getProperty(LayeredOptions.SPACING_NODE_NODE);
        for (Layer layer : layeredGraph) {
            for (LNode node : layer) {
                this.processComments(node, spacing);
                this.processSelfLoops(node);
            }
        }
        monitor.done();
    }

    private void processComments(LNode node, double spacing) {
        double maxCommentWidth;
        LMargin margin = node.getMargin();
        List topBoxes = (List)node.getProperty(InternalProperties.TOP_COMMENTS);
        double topWidth = 0.0;
        if (topBoxes != null) {
            double maxHeight = 0.0;
            for (LNode commentBox : topBoxes) {
                maxHeight = Math.max(maxHeight, commentBox.getSize().y);
                topWidth += commentBox.getSize().x;
            }
            topWidth += spacing / 2.0 * (double)(topBoxes.size() - 1);
            margin.top += maxHeight + spacing;
        }
        List bottomBoxes = (List)node.getProperty(InternalProperties.BOTTOM_COMMENTS);
        double bottomWidth = 0.0;
        if (bottomBoxes != null) {
            double maxHeight = 0.0;
            for (LNode commentBox : bottomBoxes) {
                maxHeight = Math.max(maxHeight, commentBox.getSize().y);
                bottomWidth += commentBox.getSize().x;
            }
            bottomWidth += spacing / 2.0 * (double)(bottomBoxes.size() - 1);
            margin.bottom += maxHeight + spacing;
        }
        if ((maxCommentWidth = Math.max(topWidth, bottomWidth)) > node.getSize().x) {
            double protrusion = (maxCommentWidth - node.getSize().x) / 2.0;
            margin.left = Math.max(margin.left, protrusion);
            margin.right = Math.max(margin.right, protrusion);
        }
    }

    private void processSelfLoops(LNode node) {
        LMargin nodeMargin = node.getMargin();
        ElkMargin selfLoopMargin = (ElkMargin)node.getProperty(InternalProperties.SPLINE_SELF_LOOP_MARGINS);
        nodeMargin.left = Math.max(nodeMargin.left, selfLoopMargin.left);
        nodeMargin.right = Math.max(nodeMargin.right, selfLoopMargin.right);
        nodeMargin.bottom = Math.max(nodeMargin.bottom, selfLoopMargin.bottom);
        nodeMargin.top = Math.max(nodeMargin.top, selfLoopMargin.top);
    }
}

