/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.codegen.c99;

import org.eclipse.escet.cif.codegen.CodeContext;
import org.eclipse.escet.cif.codegen.DataValue;
import org.eclipse.escet.cif.codegen.ExprCode;
import org.eclipse.escet.cif.codegen.assignments.VariableInformation;
import org.eclipse.escet.cif.codegen.typeinfos.TypeInfo;
import org.eclipse.escet.common.box.CodeBox;
import org.eclipse.escet.common.box.MemoryCodeBox;
import org.eclipse.escet.common.java.Strings;

public class C99DataValue
implements DataValue {
    private ValueKind valueKind;
    private String value;

    protected C99DataValue(String value, ValueKind valueKind) {
        this.value = value;
        this.valueKind = valueKind;
    }

    @Override
    public String getData() {
        switch (this.valueKind) {
            case DATA: 
            case LITERAL: 
            case COMPUTED: {
                return this.value;
            }
            case POINTER: {
                return "*(" + this.value + ")";
            }
        }
        throw new RuntimeException("Unexpected kind of value: " + Strings.str((Object)((Object)this.valueKind)));
    }

    @Override
    public String getReference() {
        switch (this.valueKind) {
            case DATA: {
                return "&(" + this.value + ")";
            }
            case POINTER: {
                return this.value;
            }
            case LITERAL: 
            case COMPUTED: {
                throw new RuntimeException("Cannot construct a pointer to a literal");
            }
        }
        throw new RuntimeException("Unexpected kind of value: " + Strings.str((Object)((Object)this.valueKind)));
    }

    @Override
    public boolean isReferenceValue() {
        return this.valueKind.equals((Object)ValueKind.POINTER);
    }

    @Override
    public boolean canBeReferenced() {
        switch (this.valueKind) {
            case DATA: 
            case POINTER: {
                return true;
            }
            case LITERAL: 
            case COMPUTED: {
                return false;
            }
        }
        throw new RuntimeException("Unexpected kind of value: " + Strings.str((Object)((Object)this.valueKind)));
    }

    public boolean canBeReUsed() {
        return !this.valueKind.equals((Object)ValueKind.COMPUTED);
    }

    public static C99DataValue makeLiteral(String value) {
        return new C99DataValue(value, ValueKind.LITERAL);
    }

    public static C99DataValue makeComputed(String value) {
        return new C99DataValue(value, ValueKind.COMPUTED);
    }

    public static C99DataValue makeValue(String value) {
        return new C99DataValue(value, ValueKind.DATA);
    }

    public static C99DataValue makeReference(String value) {
        return new C99DataValue(value, ValueKind.POINTER);
    }

    public static String constructReference(DataValue value, TypeInfo valueTi, CodeContext ctxt, CodeBox box) {
        if (value.canBeReferenced()) {
            return value.getReference();
        }
        VariableInformation varInfo = ctxt.makeTempVariable(valueTi, "deref_store");
        box.add("%s %s = %s;", new Object[]{valueTi.getTargetType(), varInfo.targetName, value.getData()});
        return "&" + varInfo.targetName;
    }

    public static String constructReference(DataValue value, TypeInfo valueTi, CodeContext ctxt, ExprCode exprCode) {
        if (value.canBeReferenced()) {
            return value.getReference();
        }
        MemoryCodeBox code = ctxt.makeCodeBox();
        String result = C99DataValue.constructReference(value, valueTi, ctxt, (CodeBox)code);
        if (!code.isEmpty()) {
            exprCode.add((CodeBox)code);
        }
        return result;
    }

    public String toString() {
        throw new RuntimeException(Strings.fmt((String)"Do not try to print a C99 data value (contains \"%s\"", (Object[])new Object[]{this.value}));
    }

    protected static enum ValueKind {
        DATA,
        POINTER,
        LITERAL,
        COMPUTED;

    }
}

