/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.eventbased.analysis;

import java.io.DataOutputStream;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.escet.cif.eventbased.analysis.AddedEdgeInfo;
import org.eclipse.escet.cif.eventbased.analysis.AutomatonNamesInfo;
import org.eclipse.escet.cif.eventbased.analysis.EventInfo;
import org.eclipse.escet.cif.eventbased.analysis.RemovedEdgeInfo;
import org.eclipse.escet.cif.eventbased.analysis.RemovedLocationInfo;
import org.eclipse.escet.cif.eventbased.analysis.SynthesisDumpIO;
import org.eclipse.escet.cif.eventbased.analysis.SynthesisDumpInterface;
import org.eclipse.escet.cif.eventbased.apps.conversion.CifOrigin;
import org.eclipse.escet.cif.eventbased.automata.Automaton;
import org.eclipse.escet.cif.eventbased.automata.Event;
import org.eclipse.escet.cif.eventbased.automata.Location;
import org.eclipse.escet.cif.eventbased.builders.State;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Sets;

public class SynthesisDump
implements SynthesisDumpInterface {
    private int numAuts = -1;
    private List<Map<Location, Integer>> stateNumbers = null;
    private Map<Event, Integer> eventNumbers = null;
    private Map<Location, Integer> locNumbers = Maps.map();
    private DataOutputStream outHandle = null;

    public SynthesisDump(String filename) {
        Assert.check((this.outHandle == null ? 1 : 0) != 0);
        this.outHandle = SynthesisDumpIO.openOutput(filename);
    }

    @Override
    public void close() {
        if (this.outHandle != null) {
            SynthesisDumpIO.writeEndOfData(this.outHandle);
            SynthesisDumpIO.close(this.outHandle);
        }
        this.outHandle = null;
    }

    @Override
    public boolean isFake() {
        return false;
    }

    private String getLocationName(Location loc) {
        if (loc.origin instanceof CifOrigin) {
            CifOrigin cifOrigin = (CifOrigin)loc.origin;
            String name = cifOrigin.cifLoc.getName();
            return name == null ? "*" : name;
        }
        return loc.toString();
    }

    @Override
    public void storeAutomata(List<Automaton> auts, int numPlants) {
        this.numAuts = auts.size();
        List sourceInfo = Lists.listc((int)this.numAuts);
        this.stateNumbers = Lists.listc((int)this.numAuts);
        for (Automaton aut : auts) {
            int locCount = aut.size();
            Map locMap = Maps.mapc((int)locCount);
            List locNames = Lists.listc((int)locCount);
            Assert.notNull((Object)aut.initial);
            int locNumber = 0;
            locMap.put(aut.initial, locNumber);
            locNames.add(this.getLocationName(aut.initial));
            ++locNumber;
            for (Location loc : aut) {
                if (loc == aut.initial) continue;
                locMap.put(loc, locNumber);
                locNames.add(this.getLocationName(loc));
                ++locNumber;
            }
            sourceInfo.add(new AutomatonNamesInfo(aut.name, locNames));
            this.stateNumbers.add(locMap);
        }
        SynthesisDumpIO.writeSourceAutomataInformation(sourceInfo, numPlants, this.outHandle);
        Set eventSet = Sets.set();
        for (Automaton aut : auts) {
            eventSet.addAll(aut.alphabet);
        }
        int index = 0;
        List events = Lists.listc((int)eventSet.size());
        this.eventNumbers = Maps.mapc((int)eventSet.size());
        for (Event evt : eventSet) {
            this.eventNumbers.put(evt, index);
            events.add(new EventInfo(evt.name, evt.isControllable()));
            ++index;
        }
        SynthesisDumpIO.writeEvents(events, this.outHandle);
    }

    @Override
    public void newLocation(State state, Location loc) {
        int[] srcLocs = new int[this.numAuts];
        int index = 0;
        while (index < state.locs.length) {
            srcLocs[index] = this.stateNumbers.get(index).get(state.locs[index]);
            ++index;
        }
        int locIndex = this.locNumbers.size();
        Integer old = this.locNumbers.put(loc, locIndex);
        Assert.check((old == null ? 1 : 0) != 0);
        SynthesisDumpIO.writeNewLocation(srcLocs, locIndex, loc.marked, this.outHandle);
    }

    @Override
    public void newEdge(Event evt, Location src, Location dst) {
        int evtNum = this.eventNumbers.get(evt);
        int srcNum = this.locNumbers.get(src);
        int dstNum = this.locNumbers.get(dst);
        AddedEdgeInfo edgeInfo = new AddedEdgeInfo(srcNum, dstNum, evtNum);
        SynthesisDumpIO.writeNewEdge(edgeInfo, this.outHandle);
    }

    @Override
    public void disabledEvent(Location loc, Event evt, int autIndex) {
        int srcNumber = this.locNumbers.get(loc);
        int evtNumber = this.eventNumbers.get(evt);
        RemovedEdgeInfo edgeInfo = new RemovedEdgeInfo(srcNumber, autIndex, evtNumber, true);
        SynthesisDumpIO.writeRemovedEdge(edgeInfo, this.outHandle);
    }

    @Override
    public void removedDestination(Location loc, Event evt, Location dst) {
        int srcNumber = this.locNumbers.get(loc);
        int dstNumber = this.locNumbers.get(dst);
        int evtNumber = this.eventNumbers.get(evt);
        RemovedEdgeInfo edgeInfo = new RemovedEdgeInfo(srcNumber, dstNumber, evtNumber, false);
        SynthesisDumpIO.writeRemovedEdge(edgeInfo, this.outHandle);
    }

    @Override
    public void blockingLocation(Location loc) {
        int locNumber = this.locNumbers.get(loc);
        RemovedLocationInfo locInfo = new RemovedLocationInfo(locNumber, false);
        SynthesisDumpIO.writeRemovedLocation(locInfo, this.outHandle);
    }

    @Override
    public void nonCoreachableLocation(Location loc) {
        int locNumber = this.locNumbers.get(loc);
        RemovedLocationInfo locInfo = new RemovedLocationInfo(locNumber, true);
        SynthesisDumpIO.writeRemovedLocation(locInfo, this.outHandle);
    }
}

