/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.resource_throughput.ui.editors;

import activity.Activity;
import activity.PeripheralAction;
import com.google.common.base.Objects;
import dispatching.ActivityDispatching;
import dispatching.DispatchGroup;
import dispatching.util.DispatchingUtil;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import lsat_graph.PeripheralActionTask;
import machine.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.lsat.common.graph.directed.Aspect;
import org.eclipse.lsat.common.queries.QueryableIterable;
import org.eclipse.lsat.common.qvto.util.QvtoTransformationException;
import org.eclipse.lsat.common.scheduler.algorithm.AsapScheduler;
import org.eclipse.lsat.common.scheduler.algorithm.IScheduler;
import org.eclipse.lsat.common.scheduler.algorithm.SchedulerException;
import org.eclipse.lsat.common.scheduler.graph.Task;
import org.eclipse.lsat.common.scheduler.graph.TaskDependencyGraph;
import org.eclipse.lsat.common.scheduler.schedule.Schedule;
import org.eclipse.lsat.common.xtend.Queries;
import org.eclipse.lsat.motioncalculator.MotionException;
import org.eclipse.lsat.resource_throughput.ui.editors.FilteredTimingCalculator;
import org.eclipse.lsat.resource_throughput.ui.editors.ResourceThroughputEditingDomain;
import org.eclipse.lsat.resource_throughput.ui.editors.ResourceThroughputOutlineItem;
import org.eclipse.lsat.resource_throughput.ui.editors.ResourceThroughputTableContentProvider;
import org.eclipse.lsat.scheduler.ALAPScheduler;
import org.eclipse.lsat.scheduler.AddExecutionTimes;
import org.eclipse.lsat.scheduler.CleanupGraph;
import org.eclipse.lsat.scheduler.CriticalPathAnalysis;
import org.eclipse.lsat.scheduler.Dispatching2Graph;
import org.eclipse.lsat.scheduler.Dispatching2GraphOutput;
import org.eclipse.lsat.timing.util.ITimingCalculator;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceThroughputOutlineContentProvider
implements IStructuredContentProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourceThroughputOutlineContentProvider.class);
    @Extension
    private final IScheduler<Task> scheduler = new AsapScheduler();
    public final Map<String, Set<PeripheralAction>> _IntermediateProperty_criticalActions = new WeakHashMap<String, Set<PeripheralAction>>();
    private static final Set<PeripheralAction> _DEFAULT_STRING_CRITICALACTIONS = Collections.EMPTY_SET;

    public Object[] getElements(Object editingDomain) {
        if (editingDomain instanceof ResourceThroughputEditingDomain) {
            LOGGER.debug("Calculating Resource Throughput Outline Content");
            ActivityDispatching activityDispatching = ((ResourceThroughputEditingDomain)((Object)editingDomain)).getActivityDispatching();
            if (activityDispatching == null) {
                return new Object[0];
            }
            try {
                this._IntermediateProperty_criticalActions.clear();
                QueryableIterable<Activity> activities = ((ResourceThroughputEditingDomain)((Object)editingDomain)).getActivities();
                Functions.Function1 _function = it -> it.getNodes();
                Functions.Function1 _function_1 = it -> it.getResource();
                Functions.Function1 _function_2 = it -> it.getName();
                List resources = Queries.sortedBy((Iterable)IterableExtensions.toSet((Iterable)Queries.collectOne((Iterable)Queries.objectsOfKind((Iterable)Queries.collect(activities, (Functions.Function1)_function), PeripheralAction.class), (Functions.Function1)_function_1)), (Functions.Function1)_function_2, (Comparator)String.CASE_INSENSITIVE_ORDER);
                Dispatching2Graph d2g = new Dispatching2Graph();
                NullProgressMonitor _nullProgressMonitor = new NullProgressMonitor();
                Dispatching2GraphOutput d2gResult = (Dispatching2GraphOutput)d2g.transformModel((Object)activityDispatching, (IProgressMonitor)_nullProgressMonitor);
                CleanupGraph cleanupGraph = new CleanupGraph(true, CleanupGraph.RemoveClaimReleaseStrategy.KeepAll);
                TaskDependencyGraph _taskDependencyGraph = d2gResult.getTaskDependencyGraph();
                NullProgressMonitor _nullProgressMonitor_1 = new NullProgressMonitor();
                TaskDependencyGraph graph = (TaskDependencyGraph)cleanupGraph.transformModel((Object)_taskDependencyGraph, (IProgressMonitor)_nullProgressMonitor_1);
                Functions.Function1 _function_3 = resource -> {
                    try {
                        Functions.Function1 _function_4 = it -> ResourceThroughputTableContentProvider.getResourceActions(it, resource.fqn());
                        Set timedNodes = IterableExtensions.toSet((Iterable)Queries.collect(ResourceThroughputTableContentProvider.getResourceActivities((Iterable<Activity>)activities, resource.fqn()), (Functions.Function1)_function_4));
                        ITimingCalculator _timingCalculator = ((ResourceThroughputEditingDomain)((Object)((Object)editingDomain))).getTimingCalculator();
                        FilteredTimingCalculator timingCalculator = new FilteredTimingCalculator(_timingCalculator, timedNodes);
                        Integer yield = this.getYield(activityDispatching, (IResource)resource);
                        return this.createThroughputOutlineItem((TaskDependencyGraph)graph, timingCalculator, (IResource)resource, yield);
                    }
                    catch (Throwable _e) {
                        throw Exceptions.sneakyThrow((Throwable)_e);
                    }
                };
                Object[] objectArray = (Object[])Conversions.unwrapArray((Object)Queries.collectOne((Iterable)resources, (Functions.Function1)_function_3), Object.class);
                return objectArray;
            }
            catch (Throwable _t) {
                if (_t instanceof Exception) {
                    Exception e = (Exception)_t;
                    String _message = e.getMessage();
                    String _plus = "Failed to calculate resource throughput outline content: " + _message;
                    LOGGER.error(_plus, (Throwable)e);
                    Object[] objectArray = new Object[]{};
                    return objectArray;
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
            finally {
                LOGGER.debug("DONE: Calculating Resource Throughput Outline Content");
            }
        }
        throw new IllegalArgumentException();
    }

    private Integer getYield(ActivityDispatching ad, IResource resource) {
        Functions.Function1 _function = it -> DispatchingUtil.getYield((DispatchGroup)it, (IResource)resource);
        Functions.Function2 _function_1 = (p1, p2) -> p1 + p2;
        return (Integer)IterableExtensions.reduce((Iterable)ListExtensions.map((List)ad.getDispatchGroups(), (Functions.Function1)_function), (Functions.Function2)_function_1);
    }

    public <T extends Task> ResourceThroughputOutlineItem createThroughputOutlineItem(TaskDependencyGraph<T> graph, ITimingCalculator timingCalculator, IResource resource, int noIterations) throws MotionException, SchedulerException, QvtoTransformationException {
        try {
            TaskDependencyGraph timedGraph = new AddExecutionTimes(timingCalculator).transformModel(graph);
            Schedule schedule = ALAPScheduler.applyALAPScheduling((Schedule)this.scheduler.createSchedule(timedGraph));
            ResourceThroughputOutlineItem _resourceThroughputOutlineItem = new ResourceThroughputOutlineItem();
            Procedures.Procedure1 _function = it -> {
                it.setNumberOfIterations(noIterations);
                Functions.Function1 _function_1 = it_1 -> it_1.getEndTime();
                it.setTotalMakespan((BigDecimal)Queries.max((Iterable)Queries.collectOne((Iterable)schedule.getNodes(), (Functions.Function1)_function_1), (Comparable)BigDecimal.ZERO));
                double _doubleValue = it.getTotalMakespan().doubleValue();
                int _numberOfIterations = it.getNumberOfIterations();
                double _divide = _doubleValue / (double)_numberOfIterations;
                it.setIterationMakespan(_divide);
                double _xifexpression = 0.0;
                BigDecimal _totalMakespan = it.getTotalMakespan();
                boolean _equals = Objects.equal((Object)_totalMakespan, (Object)BigDecimal.ZERO);
                if (_equals) {
                    _xifexpression = Double.POSITIVE_INFINITY;
                } else {
                    Double _iterationMakespan = it.getIterationMakespan();
                    _xifexpression = 3600.0 / _iterationMakespan;
                }
                it.setThroughput(_xifexpression);
            };
            ResourceThroughputOutlineItem result = (ResourceThroughputOutlineItem)ObjectExtensions.operator_doubleArrow((Object)_resourceThroughputOutlineItem, (Procedures.Procedure1)_function);
            if (resource != null) {
                result.setResource(resource);
                CriticalPathAnalysis _criticalPathAnalysis = new CriticalPathAnalysis();
                NullProgressMonitor _nullProgressMonitor = new NullProgressMonitor();
                Schedule criticalSchedule = (Schedule)_criticalPathAnalysis.transformModel((Object)schedule, (IProgressMonitor)_nullProgressMonitor);
                String _fqn = resource.fqn();
                Functions.Function1 _function_1 = it -> {
                    String _name = it.getName();
                    return Objects.equal((Object)_name, (Object)"Critical");
                };
                Functions.Function1 _function_2 = it -> it.getTask();
                Functions.Function1 _function_3 = it -> (PeripheralAction)it.getAction();
                this.setCriticalActions(_fqn, IterableExtensions.toSet((Iterable)Queries.collectOne((Iterable)Queries.objectsOfKind((Iterable)Queries.collectOne((Iterable)((Aspect)IterableExtensions.head((Iterable)Queries.select((Iterable)criticalSchedule.getAspects(), (Functions.Function1)_function_1))).getNodes(), (Functions.Function1)_function_2), PeripheralActionTask.class), (Functions.Function1)_function_3)));
            }
            return result;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public Set<PeripheralAction> getCriticalActions(String owner) {
        Set<PeripheralAction> value = this._IntermediateProperty_criticalActions.get(owner);
        return value == null ? _DEFAULT_STRING_CRITICALACTIONS : value;
    }

    public void setCriticalActions(String owner, Set<PeripheralAction> value) {
        if (value == _DEFAULT_STRING_CRITICALACTIONS) {
            this._IntermediateProperty_criticalActions.remove(owner);
        } else {
            this._IntermediateProperty_criticalActions.put(owner, value);
        }
    }

    private void disposeCriticalActions() {
        this._IntermediateProperty_criticalActions.clear();
    }
}

