/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.typechecker.postchk;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.escet.cif.common.CifEquationUtils;
import org.eclipse.escet.cif.common.CifLocationUtils;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.Component;
import org.eclipse.escet.cif.metamodel.cif.Group;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.declarations.AlgVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.Constant;
import org.eclipse.escet.cif.metamodel.cif.declarations.ContVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.Declaration;
import org.eclipse.escet.cif.metamodel.cif.declarations.DiscVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.EnumDecl;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.cif.metamodel.cif.declarations.InputVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.TypeDecl;
import org.eclipse.escet.cif.metamodel.cif.expressions.AlgVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.BoolExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.CastExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.CompInstWrapExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.CompParamWrapExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ComponentExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ConstantExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ContVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.DictExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.DictPair;
import org.eclipse.escet.cif.metamodel.cif.expressions.DiscVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ElifExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.EnumLiteralExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.EventExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.FieldExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.FunctionCallExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.FunctionExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.IfExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.InputVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.IntExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ListExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.LocationExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ProjectionExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.RealExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ReceivedExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.SelfExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.SetExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.SliceExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.StdLibFunctionExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.StringExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.SwitchCase;
import org.eclipse.escet.cif.metamodel.cif.expressions.SwitchExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.TauExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.TimeExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.TupleExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.UnaryExpression;
import org.eclipse.escet.cif.metamodel.cif.functions.ExternalFunction;
import org.eclipse.escet.cif.metamodel.cif.functions.Function;
import org.eclipse.escet.cif.metamodel.cif.functions.InternalFunction;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.ComponentType;
import org.eclipse.escet.cif.typechecker.ErrMsg;
import org.eclipse.escet.cif.typechecker.postchk.CifPostCheckEnv;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.position.metamodel.position.Position;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;
import org.eclipse.escet.common.typechecker.SemanticException;

public class CyclePostChecker {
    private final CifPostCheckEnv env;
    private Set<PositionObject> done = Sets.set();
    private Map<ContVariable, Derivative> contDerMap = Maps.map();

    private CyclePostChecker(CifPostCheckEnv env) {
        this.env = env;
    }

    public static void check(Specification spec, CifPostCheckEnv env) {
        CyclePostChecker checker = new CyclePostChecker(env);
        checker.check((ComplexComponent)spec);
    }

    private Derivative getDerivative(ContVariable var) {
        Derivative rslt = this.contDerMap.get(var);
        if (rslt == null) {
            rslt = new Derivative(var);
            this.contDerMap.put(var, rslt);
        }
        return rslt;
    }

    private String getCycleElementName(PositionObject elem) {
        Location loc;
        if (elem instanceof Derivative) {
            return String.valueOf(this.getCycleElementName((PositionObject)((Derivative)elem).var)) + "'";
        }
        if (elem instanceof Location && (loc = (Location)elem).getName() == null) {
            Automaton aut = CifLocationUtils.getAutomaton((Location)loc);
            return String.valueOf(CifTextUtils.getAbsName((PositionObject)aut)) + ".<loc>";
        }
        return CifTextUtils.getAbsName((PositionObject)elem);
    }

    private void addToCycle(PositionObject obj, List<PositionObject> cycle) {
        if (!cycle.contains(obj)) {
            cycle.add(obj);
            return;
        }
        int idx = cycle.indexOf(obj);
        Assert.check((idx >= 0 ? 1 : 0) != 0);
        int i = idx;
        while (i < cycle.size()) {
            PositionObject startDecl = cycle.get(i);
            StringBuilder txt = new StringBuilder();
            int j = i;
            while (j < cycle.size()) {
                if (txt.length() > 0) {
                    txt.append(" -> ");
                }
                txt.append(this.getCycleElementName(cycle.get(j)));
                ++j;
            }
            j = idx;
            while (j <= i) {
                if (txt.length() > 0) {
                    txt.append(" -> ");
                }
                txt.append(this.getCycleElementName(cycle.get(j)));
                ++j;
            }
            this.env.addProblem(ErrMsg.DEF_USE_CYCLE, startDecl.getPosition(), this.getCycleElementName(startDecl), txt.toString());
            this.done.add(startDecl);
            ++i;
        }
        throw new SemanticException();
    }

    private void removeFromCycle(PositionObject obj, List<PositionObject> cycle) {
        PositionObject top = cycle.remove(cycle.size() - 1);
        if (top != obj) {
            throw new IllegalStateException("top of cycle != obj");
        }
    }

    private void check(ComplexComponent comp) {
        for (Declaration decl : comp.getDeclarations()) {
            this.check(decl);
        }
        if (comp instanceof Automaton) {
            List cycle = Lists.list();
            try {
                this.check((Automaton)comp, (List<PositionObject>)cycle);
                Assert.check((boolean)cycle.isEmpty());
            }
            catch (SemanticException semanticException) {
                // empty catch block
            }
        }
        if (comp instanceof Group) {
            Group group = (Group)comp;
            for (Component child : group.getComponents()) {
                Assert.check((boolean)(child instanceof ComplexComponent));
                this.check((ComplexComponent)child);
            }
        }
    }

    private void check(Automaton aut, List<PositionObject> cycle) {
        if (this.done.contains(aut)) {
            return;
        }
        this.addToCycle((PositionObject)aut, cycle);
        for (Location loc : aut.getLocations()) {
            if (loc.getInitials().isEmpty()) continue;
            this.check(loc, cycle);
        }
        this.removeFromCycle((PositionObject)aut, cycle);
        this.done.add((PositionObject)aut);
    }

    private void check(Location loc, List<PositionObject> cycle) {
        EList initials = loc.getInitials();
        if (initials.isEmpty()) {
            return;
        }
        if (this.done.contains(loc)) {
            return;
        }
        this.addToCycle((PositionObject)loc, cycle);
        for (Expression initial : initials) {
            this.check(initial, cycle);
        }
        this.removeFromCycle((PositionObject)loc, cycle);
        this.done.add((PositionObject)loc);
    }

    private void check(Function func) {
        if (func instanceof ExternalFunction) {
            return;
        }
        InternalFunction ifunc = (InternalFunction)func;
        for (Declaration decl : ifunc.getVariables()) {
            this.check(decl);
        }
    }

    private void check(Declaration decl) {
        if (decl instanceof Function) {
            this.check((Function)decl);
            return;
        }
        List cycle = Lists.list();
        try {
            if (decl instanceof AlgVariable) {
                this.check((AlgVariable)decl, (List<PositionObject>)cycle);
            } else if (!(decl instanceof Constant) && !(decl instanceof Event)) {
                if (decl instanceof ContVariable) {
                    ContVariable var = (ContVariable)decl;
                    this.check(var, (List<PositionObject>)cycle);
                    this.check(this.getDerivative(var), (List<PositionObject>)cycle);
                } else if (!(decl instanceof EnumDecl)) {
                    if (decl instanceof Function) {
                        throw new RuntimeException("Special case above.");
                    }
                    if (!(decl instanceof TypeDecl) && !(decl instanceof InputVariable)) {
                        if (decl instanceof DiscVariable) {
                            this.check((DiscVariable)decl, (List<PositionObject>)cycle);
                        } else {
                            throw new RuntimeException("Unknown decl: " + decl);
                        }
                    }
                }
            }
            Assert.check((boolean)cycle.isEmpty());
        }
        catch (SemanticException semanticException) {
            // empty catch block
        }
    }

    private void check(DiscVariable var, List<PositionObject> cycle) {
        if (this.done.contains(var)) {
            return;
        }
        this.addToCycle((PositionObject)var, cycle);
        if (var.getValue() != null) {
            for (Expression value : var.getValue().getValues()) {
                this.check(value, cycle);
            }
        }
        this.removeFromCycle((PositionObject)var, cycle);
        this.done.add((PositionObject)var);
    }

    private void check(ContVariable var, List<PositionObject> cycle) {
        if (this.done.contains(var)) {
            return;
        }
        this.addToCycle((PositionObject)var, cycle);
        if (var.getValue() != null) {
            this.check(var.getValue(), cycle);
        }
        this.removeFromCycle((PositionObject)var, cycle);
        this.done.add((PositionObject)var);
    }

    private void check(Derivative der, List<PositionObject> cycle) {
        if (this.done.contains((Object)der)) {
            return;
        }
        this.addToCycle(der, cycle);
        List values = CifEquationUtils.getDerivativesForContVar((ContVariable)der.var, (boolean)true);
        for (Expression value : values) {
            this.check(value, cycle);
        }
        this.removeFromCycle(der, cycle);
        this.done.add(der);
    }

    private void check(AlgVariable var, List<PositionObject> cycle) {
        if (this.done.contains(var)) {
            return;
        }
        this.addToCycle((PositionObject)var, cycle);
        List values = CifEquationUtils.getValuesForAlgVar((AlgVariable)var, (boolean)true);
        for (Expression value : values) {
            this.check(value, cycle);
        }
        this.removeFromCycle((PositionObject)var, cycle);
        this.done.add((PositionObject)var);
    }

    public void check(Expression expr, List<PositionObject> cycle) {
        if (!(expr instanceof BoolExpression || expr instanceof IntExpression || expr instanceof RealExpression || expr instanceof StringExpression || expr instanceof TimeExpression)) {
            if (expr instanceof CastExpression) {
                Expression child = ((CastExpression)expr).getChild();
                if (CifTypeUtils.isAutRefExpr((Expression)child)) {
                    CifType ctype = CifTypeUtils.normalizeType((CifType)child.getType());
                    Assert.check((boolean)(ctype instanceof ComponentType));
                    Component comp = ((ComponentType)ctype).getComponent();
                    Automaton aut = (Automaton)comp;
                    this.check(aut, cycle);
                    return;
                }
                this.check(child, cycle);
            } else if (expr instanceof UnaryExpression) {
                this.check(((UnaryExpression)expr).getChild(), cycle);
            } else if (expr instanceof BinaryExpression) {
                BinaryExpression bexpr = (BinaryExpression)expr;
                this.check(bexpr.getLeft(), cycle);
                this.check(bexpr.getRight(), cycle);
            } else if (expr instanceof IfExpression) {
                IfExpression ifExpr = (IfExpression)expr;
                for (Expression guard : ifExpr.getGuards()) {
                    this.check(guard, cycle);
                }
                this.check(ifExpr.getThen(), cycle);
                for (ElifExpression elif : ifExpr.getElifs()) {
                    for (Expression guard : elif.getGuards()) {
                        this.check(guard, cycle);
                    }
                    this.check(elif.getThen(), cycle);
                }
                this.check(ifExpr.getElse(), cycle);
            } else if (expr instanceof SwitchExpression) {
                SwitchExpression switchExpr = (SwitchExpression)expr;
                Expression value = switchExpr.getValue();
                if (CifTypeUtils.isAutRefExpr((Expression)value)) {
                    CifType ctype = CifTypeUtils.normalizeType((CifType)value.getType());
                    Assert.check((boolean)(ctype instanceof ComponentType));
                    Component comp = ((ComponentType)ctype).getComponent();
                    Automaton aut = (Automaton)comp;
                    this.check(aut, cycle);
                } else {
                    this.check(switchExpr.getValue(), cycle);
                }
                for (SwitchCase cse : switchExpr.getCases()) {
                    if (cse.getKey() != null) {
                        this.check(cse.getKey(), cycle);
                    }
                    this.check(cse.getValue(), cycle);
                }
            } else if (expr instanceof ProjectionExpression) {
                ProjectionExpression pexpr = (ProjectionExpression)expr;
                this.check(pexpr.getChild(), cycle);
                this.check(pexpr.getIndex(), cycle);
            } else if (expr instanceof SliceExpression) {
                SliceExpression sexpr = (SliceExpression)expr;
                this.check(sexpr.getChild(), cycle);
                if (sexpr.getBegin() != null) {
                    this.check(sexpr.getBegin(), cycle);
                }
                if (sexpr.getEnd() != null) {
                    this.check(sexpr.getEnd(), cycle);
                }
            } else if (expr instanceof FunctionCallExpression) {
                FunctionCallExpression fcexpr = (FunctionCallExpression)expr;
                this.check(fcexpr.getFunction(), cycle);
                for (Expression param : fcexpr.getParams()) {
                    this.check(param, cycle);
                }
            } else if (expr instanceof ListExpression) {
                ListExpression lexpr = (ListExpression)expr;
                for (Expression elem : lexpr.getElements()) {
                    this.check(elem, cycle);
                }
            } else if (expr instanceof SetExpression) {
                SetExpression sexpr = (SetExpression)expr;
                for (Expression elem : sexpr.getElements()) {
                    this.check(elem, cycle);
                }
            } else if (expr instanceof TupleExpression) {
                TupleExpression texpr = (TupleExpression)expr;
                for (Expression elem : texpr.getFields()) {
                    this.check(elem, cycle);
                }
            } else if (expr instanceof DictExpression) {
                DictExpression dexpr = (DictExpression)expr;
                for (DictPair pair : dexpr.getPairs()) {
                    this.check(pair.getKey(), cycle);
                    this.check(pair.getValue(), cycle);
                }
            } else if (!(expr instanceof ConstantExpression)) {
                if (expr instanceof DiscVariableExpression) {
                    DiscVariable var = ((DiscVariableExpression)expr).getVariable();
                    EObject parent = var.eContainer();
                    if (parent instanceof ComplexComponent || parent instanceof InternalFunction) {
                        this.check(var, cycle);
                    }
                } else if (expr instanceof AlgVariableExpression) {
                    AlgVariable var = ((AlgVariableExpression)expr).getVariable();
                    this.check(var, cycle);
                } else if (expr instanceof ContVariableExpression) {
                    ContVariableExpression ref = (ContVariableExpression)expr;
                    ContVariable var = ref.getVariable();
                    if (ref.isDerivative()) {
                        this.check(this.getDerivative(var), cycle);
                    } else {
                        this.check(var, cycle);
                    }
                } else {
                    if (expr instanceof TauExpression) {
                        throw new RuntimeException("Tau expression in value context.");
                    }
                    if (expr instanceof LocationExpression) {
                        Location loc = ((LocationExpression)expr).getLocation();
                        this.check(loc, cycle);
                    } else if (!(expr instanceof EnumLiteralExpression || expr instanceof EventExpression || expr instanceof FieldExpression || expr instanceof StdLibFunctionExpression || expr instanceof FunctionExpression || expr instanceof InputVariableExpression)) {
                        if (expr instanceof ComponentExpression) {
                            throw new RuntimeException("Component ref in value context.");
                        }
                        if (expr instanceof CompInstWrapExpression) {
                            throw new RuntimeException("Wrap expr unexpected.");
                        }
                        if (expr instanceof CompParamWrapExpression) {
                            throw new RuntimeException("Wrap expr unexpected.");
                        }
                        if (!(expr instanceof ReceivedExpression)) {
                            if (expr instanceof SelfExpression) {
                                throw new RuntimeException("Aut self ref in value context.");
                            }
                            throw new RuntimeException("Unknown expr: " + expr);
                        }
                    }
                }
            }
        }
    }

    private static class Derivative
    extends EObjectImpl
    implements PositionObject {
        public final ContVariable var;

        public Derivative(ContVariable var) {
            this.var = var;
        }

        public Position getPosition() {
            return this.var.getPosition();
        }

        public void setPosition(Position value) {
            throw new UnsupportedOperationException();
        }
    }
}

